import * as iam from "../../../aws-iam";
import * as sqs from "../../../aws-sqs";
import * as sfn from "../../../aws-stepfunctions";
import * as cdk from "../../../core";
import { Construct } from 'constructs';
/**
 * (experimental) Properties for sending a message to an SQS queue.
 *
 * @experimental
 */
export interface SqsSendMessageProps extends sfn.TaskStateBaseProps {
    /**
     * (experimental) The SQS queue that messages will be sent to.
     *
     * @experimental
     */
    readonly queue: sqs.IQueue;
    /**
     * (experimental) The text message to send to the queue.
     *
     * @experimental
     */
    readonly messageBody: sfn.TaskInput;
    /**
     * (experimental) The length of time, for which to delay a message.
     *
     * Messages that you send to the queue remain invisible to consumers for the duration
     * of the delay period. The maximum allowed delay is 15 minutes.
     *
     * @default - delay set on the queue. If a delay is not set on the queue,
     * messages are sent immediately (0 seconds).
     * @experimental
     */
    readonly delay?: cdk.Duration;
    /**
     * (experimental) The token used for deduplication of sent messages.
     *
     * Any messages sent with the same deduplication ID are accepted successfully,
     * but aren't delivered during the 5-minute deduplication interval.
     *
     * @default - None
     * @experimental
     */
    readonly messageDeduplicationId?: string;
    /**
     * (experimental) The tag that specifies that a message belongs to a specific message group.
     *
     * Messages that belong to the same message group are processed in a FIFO manner.
     * Messages in different message groups might be processed out of order.
     *
     * @default - None
     * @experimental
     */
    readonly messageGroupId?: string;
}
/**
 * (experimental) A StepFunctions Task to send messages to SQS queue.
 *
 * @experimental
 */
export declare class SqsSendMessage extends sfn.TaskStateBase {
    private readonly props;
    private static readonly SUPPORTED_INTEGRATION_PATTERNS;
    /**
     * @experimental
     */
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    /**
     * @experimental
     */
    protected readonly taskPolicies?: iam.PolicyStatement[];
    private readonly integrationPattern;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: SqsSendMessageProps);
}
