import * as iam from "../../../aws-iam";
import * as sfn from "../../../aws-stepfunctions";
import { Construct } from 'constructs';
/**
 * (experimental) Properties for creating an Amazon SageMaker endpoint.
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-sagemaker.html
 * @experimental
 */
export interface SageMakerCreateEndpointProps extends sfn.TaskStateBaseProps {
    /**
     * (experimental) The name of an endpoint configuration.
     *
     * @experimental
     */
    readonly endpointConfigName: string;
    /**
     * (experimental) The name of the endpoint.
     *
     * The name must be unique within an AWS Region in your AWS account.
     *
     * @experimental
     */
    readonly endpointName: string;
    /**
     * (experimental) Tags to be applied to the endpoint.
     *
     * @default - No tags
     * @experimental
     */
    readonly tags?: sfn.TaskInput;
}
/**
 * (experimental) A Step Functions Task to create a SageMaker endpoint.
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-sagemaker.html
 * @experimental
 */
export declare class SageMakerCreateEndpoint extends sfn.TaskStateBase {
    private readonly props;
    private static readonly SUPPORTED_INTEGRATION_PATTERNS;
    /**
     * @experimental
     */
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    /**
     * @experimental
     */
    protected readonly taskPolicies?: iam.PolicyStatement[];
    private readonly integrationPattern;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: SageMakerCreateEndpointProps);
    private renderParameters;
    private makePolicyStatements;
}
