"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EvaluateExpression = void 0;
const path = require("path");
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const lambda = require("../../aws-lambda"); // Automatically re-written from '@aws-cdk/aws-lambda'
const sfn = require("../../aws-stepfunctions"); // Automatically re-written from '@aws-cdk/aws-stepfunctions'
/**
 * (experimental) A Step Functions Task to evaluate an expression.
 *
 * OUTPUT: the output of this task is the evaluated expression.
 *
 * @experimental
 */
class EvaluateExpression extends sfn.TaskStateBase {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id, props);
        this.props = props;
        this.evalFn = createEvalFn(this.props.runtime || lambda.Runtime.NODEJS_10_X, this);
        this.taskPolicies = [
            new iam.PolicyStatement({
                resources: [this.evalFn.functionArn],
                actions: ['lambda:InvokeFunction'],
            }),
        ];
    }
    /**
     * @internal
     */
    _renderTask() {
        const matches = this.props.expression.match(/\$[.\[][.a-zA-Z[\]0-9]+/g);
        let expressionAttributeValues = {};
        if (matches) {
            expressionAttributeValues = matches.reduce((acc, m) => ({
                ...acc,
                [m]: sfn.JsonPath.stringAt(m),
            }), {});
        }
        const parameters = {
            expression: this.props.expression,
            expressionAttributeValues,
        };
        return {
            Resource: this.evalFn.functionArn,
            Parameters: sfn.FieldUtils.renderObject(parameters),
        };
    }
}
exports.EvaluateExpression = EvaluateExpression;
function createEvalFn(runtime, scope) {
    const code = lambda.Code.asset(path.join(__dirname, `eval-${runtime.name}-handler`));
    const lambdaPurpose = 'Eval';
    switch (runtime) {
        case lambda.Runtime.NODEJS_10_X:
            return new lambda.SingletonFunction(scope, 'EvalFunction', {
                runtime,
                handler: 'index.handler',
                uuid: 'a0d2ce44-871b-4e74-87a1-f5e63d7c3bdc',
                lambdaPurpose,
                code,
            });
        // TODO: implement other runtimes
        default:
            throw new Error(`The runtime ${runtime.name} is currently not supported.`);
    }
}
//# sourceMappingURL=data:application/json;base64,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