import * as iam from "../../aws-iam";
import * as lambda from "../../aws-lambda";
import * as sfn from "../../aws-stepfunctions";
import { Construct } from 'constructs';
/**
 * (experimental) Properties for EvaluateExpression.
 *
 * @experimental
 */
export interface EvaluateExpressionProps extends sfn.TaskStateBaseProps {
    /**
     * (experimental) The expression to evaluate.
     *
     * The expression may contain state paths.
     *
     * @experimental
     * @example
     *
     * '$.a + $.b'
     */
    readonly expression: string;
    /**
     * (experimental) The runtime language to use to evaluate the expression.
     *
     * @default lambda.Runtime.NODEJS_10_X
     * @experimental
     */
    readonly runtime?: lambda.Runtime;
}
/**
 * (experimental) A Step Functions Task to evaluate an expression.
 *
 * OUTPUT: the output of this task is the evaluated expression.
 *
 * @experimental
 */
export declare class EvaluateExpression extends sfn.TaskStateBase {
    private readonly props;
    /**
     * @experimental
     */
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    /**
     * @experimental
     */
    protected readonly taskPolicies?: iam.PolicyStatement[];
    private readonly evalFn;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: EvaluateExpressionProps);
}
