import * as iam from "../../../aws-iam";
import * as sfn from "../../../aws-stepfunctions";
import { Construct } from 'constructs';
/**
 * (experimental) Properties for EmrModifyInstanceFleetByName.
 *
 * @experimental
 */
export interface EmrModifyInstanceFleetByNameProps extends sfn.TaskStateBaseProps {
    /**
     * (experimental) The ClusterId to update.
     *
     * @experimental
     */
    readonly clusterId: string;
    /**
     * (experimental) The InstanceFleetName to update.
     *
     * @experimental
     */
    readonly instanceFleetName: string;
    /**
     * (experimental) The target capacity of On-Demand units for the instance fleet.
     *
     * @default - None
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_InstanceFleetModifyConfig.html
     * @experimental
     */
    readonly targetOnDemandCapacity: number;
    /**
     * (experimental) The target capacity of Spot units for the instance fleet.
     *
     * @default - None
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_InstanceFleetModifyConfig.html
     * @experimental
     */
    readonly targetSpotCapacity: number;
}
/**
 * (experimental) A Step Functions Task to to modify an InstanceFleet on an EMR Cluster.
 *
 * @experimental
 */
export declare class EmrModifyInstanceFleetByName extends sfn.TaskStateBase {
    private readonly props;
    /**
     * @experimental
     */
    protected readonly taskPolicies?: iam.PolicyStatement[];
    /**
     * @experimental
     */
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: EmrModifyInstanceFleetByNameProps);
}
