import * as ec2 from "../../../aws-ec2";
import * as ecs from "../../../aws-ecs";
import { CommonEcsRunTaskProps, EcsRunTaskBase } from './run-ecs-task-base';
/**
 * (experimental) Properties to define an ECS service.
 *
 * @experimental
 */
export interface RunEcsFargateTaskProps extends CommonEcsRunTaskProps {
    /**
     * (experimental) Assign public IP addresses to each task.
     *
     * @default false
     * @experimental
     */
    readonly assignPublicIp?: boolean;
    /**
     * (experimental) In what subnets to place the task's ENIs.
     *
     * @default Private subnet if assignPublicIp, public subnets otherwise
     * @experimental
     */
    readonly subnets?: ec2.SubnetSelection;
    /**
     * (experimental) Existing security group to use for the tasks.
     *
     * @default A new security group is created
     * @experimental
     */
    readonly securityGroup?: ec2.ISecurityGroup;
    /**
     * (experimental) Fargate platform version to run this service on.
     *
     * Unless you have specific compatibility requirements, you don't need to
     * specify this.
     *
     * @default Latest
     * @experimental
     */
    readonly platformVersion?: ecs.FargatePlatformVersion;
}
/**
 * (deprecated) Start a service on an ECS cluster.
 *
 * @deprecated - replaced by `EcsFargateRunTask`
 */
export declare class RunEcsFargateTask extends EcsRunTaskBase {
    /**
     * @deprecated
     */
    constructor(props: RunEcsFargateTaskProps);
}
