"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RunEcsEc2Task = void 0;
const ecs = require("../../../aws-ecs"); // Automatically re-written from '@aws-cdk/aws-ecs'
const run_ecs_task_base_1 = require("./run-ecs-task-base");
/**
 * (deprecated) Run an ECS/EC2 Task in a StepFunctions workflow.
 *
 * @deprecated - replaced by `EcsEc2RunTask`
 */
class RunEcsEc2Task extends run_ecs_task_base_1.EcsRunTaskBase {
    /**
     * @deprecated
     */
    constructor(props) {
        if (!props.taskDefinition.isEc2Compatible) {
            throw new Error('Supplied TaskDefinition is not configured for compatibility with EC2');
        }
        if (!props.cluster.hasEc2Capacity) {
            throw new Error('Cluster for this service needs Ec2 capacity. Call addXxxCapacity() on the cluster.');
        }
        if (!props.taskDefinition.defaultContainer) {
            throw new Error('A TaskDefinition must have at least one essential container');
        }
        super({
            ...props,
            parameters: {
                LaunchType: 'EC2',
                PlacementConstraints: noEmpty(flatten((props.placementConstraints || []).map(c => c.toJson().map(uppercaseKeys)))),
                PlacementStrategy: noEmpty(flatten((props.placementStrategies || []).map(c => c.toJson().map(uppercaseKeys)))),
            },
        });
        if (props.taskDefinition.networkMode === ecs.NetworkMode.AWS_VPC) {
            this.configureAwsVpcNetworking(props.cluster.vpc, undefined, props.subnets, props.securityGroup);
        }
        else {
            // Either None, Bridge or Host networking. Copy SecurityGroup from ASG.
            validateNoNetworkingProps(props);
            this.connections.addSecurityGroup(...props.cluster.connections.securityGroups);
        }
    }
}
exports.RunEcsEc2Task = RunEcsEc2Task;
/**
 * Validate combinations of networking arguments
 */
function validateNoNetworkingProps(props) {
    if (props.subnets !== undefined || props.securityGroup !== undefined) {
        throw new Error('vpcPlacement and securityGroup can only be used in AwsVpc networking mode');
    }
}
function uppercaseKeys(obj) {
    const ret = {};
    for (const key of Object.keys(obj)) {
        ret[key.slice(0, 1).toUpperCase() + key.slice(1)] = obj[key];
    }
    return ret;
}
function flatten(xs) {
    return Array.prototype.concat([], ...xs);
}
function noEmpty(xs) {
    if (xs.length === 0) {
        return undefined;
    }
    return xs;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicnVuLWVjcy1lYzItdGFzay5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInJ1bi1lY3MtZWMyLXRhc2sudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQ0Esd0NBQXdDLENBQUMsbURBQW1EO0FBQzVGLDJEQUE0RTs7Ozs7O0FBdUM1RSxNQUFhLGFBQWMsU0FBUSxrQ0FBYzs7OztJQUM3QyxZQUFZLEtBQXlCO1FBQ2pDLElBQUksQ0FBQyxLQUFLLENBQUMsY0FBYyxDQUFDLGVBQWUsRUFBRTtZQUN2QyxNQUFNLElBQUksS0FBSyxDQUFDLHNFQUFzRSxDQUFDLENBQUM7U0FDM0Y7UUFDRCxJQUFJLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxjQUFjLEVBQUU7WUFDL0IsTUFBTSxJQUFJLEtBQUssQ0FBQyxvRkFBb0YsQ0FBQyxDQUFDO1NBQ3pHO1FBQ0QsSUFBSSxDQUFDLEtBQUssQ0FBQyxjQUFjLENBQUMsZ0JBQWdCLEVBQUU7WUFDeEMsTUFBTSxJQUFJLEtBQUssQ0FBQyw2REFBNkQsQ0FBQyxDQUFDO1NBQ2xGO1FBQ0QsS0FBSyxDQUFDO1lBQ0YsR0FBRyxLQUFLO1lBQ1IsVUFBVSxFQUFFO2dCQUNSLFVBQVUsRUFBRSxLQUFLO2dCQUNqQixvQkFBb0IsRUFBRSxPQUFPLENBQUMsT0FBTyxDQUFDLENBQUMsS0FBSyxDQUFDLG9CQUFvQixJQUFJLEVBQUUsQ0FBQyxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxNQUFNLEVBQUUsQ0FBQyxHQUFHLENBQUMsYUFBYSxDQUFDLENBQUMsQ0FBQyxDQUFDO2dCQUNsSCxpQkFBaUIsRUFBRSxPQUFPLENBQUMsT0FBTyxDQUFDLENBQUMsS0FBSyxDQUFDLG1CQUFtQixJQUFJLEVBQUUsQ0FBQyxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxNQUFNLEVBQUUsQ0FBQyxHQUFHLENBQUMsYUFBYSxDQUFDLENBQUMsQ0FBQyxDQUFDO2FBQ2pIO1NBQ0osQ0FBQyxDQUFDO1FBQ0gsSUFBSSxLQUFLLENBQUMsY0FBYyxDQUFDLFdBQVcsS0FBSyxHQUFHLENBQUMsV0FBVyxDQUFDLE9BQU8sRUFBRTtZQUM5RCxJQUFJLENBQUMseUJBQXlCLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxHQUFHLEVBQUUsU0FBUyxFQUFFLEtBQUssQ0FBQyxPQUFPLEVBQUUsS0FBSyxDQUFDLGFBQWEsQ0FBQyxDQUFDO1NBQ3BHO2FBQ0k7WUFDRCx1RUFBdUU7WUFDdkUseUJBQXlCLENBQUMsS0FBSyxDQUFDLENBQUM7WUFDakMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxnQkFBZ0IsQ0FBQyxHQUFHLEtBQUssQ0FBQyxPQUFPLENBQUMsV0FBVyxDQUFDLGNBQWMsQ0FBQyxDQUFDO1NBQ2xGO0lBQ0wsQ0FBQztDQUNKO0FBNUJELHNDQTRCQztBQUNEOztHQUVHO0FBQ0gsU0FBUyx5QkFBeUIsQ0FBQyxLQUF5QjtJQUN4RCxJQUFJLEtBQUssQ0FBQyxPQUFPLEtBQUssU0FBUyxJQUFJLEtBQUssQ0FBQyxhQUFhLEtBQUssU0FBUyxFQUFFO1FBQ2xFLE1BQU0sSUFBSSxLQUFLLENBQUMsMkVBQTJFLENBQUMsQ0FBQztLQUNoRztBQUNMLENBQUM7QUFDRCxTQUFTLGFBQWEsQ0FBQyxHQUV0QjtJQUdHLE1BQU0sR0FBRyxHQUVMLEVBQUUsQ0FBQztJQUNQLEtBQUssTUFBTSxHQUFHLElBQUksTUFBTSxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsRUFBRTtRQUNoQyxHQUFHLENBQUMsR0FBRyxDQUFDLEtBQUssQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsV0FBVyxFQUFFLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsQ0FBQyxHQUFHLEdBQUcsQ0FBQyxHQUFHLENBQUMsQ0FBQztLQUNoRTtJQUNELE9BQU8sR0FBRyxDQUFDO0FBQ2YsQ0FBQztBQUNELFNBQVMsT0FBTyxDQUFJLEVBQVM7SUFDekIsT0FBTyxLQUFLLENBQUMsU0FBUyxDQUFDLE1BQU0sQ0FBQyxFQUFFLEVBQUUsR0FBRyxFQUFFLENBQUMsQ0FBQztBQUM3QyxDQUFDO0FBQ0QsU0FBUyxPQUFPLENBQUksRUFBTztJQUN2QixJQUFJLEVBQUUsQ0FBQyxNQUFNLEtBQUssQ0FBQyxFQUFFO1FBQ2pCLE9BQU8sU0FBUyxDQUFDO0tBQ3BCO0lBQ0QsT0FBTyxFQUFFLENBQUM7QUFDZCxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgZWMyIGZyb20gXCIuLi8uLi8uLi9hd3MtZWMyXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9hd3MtZWMyJ1xuaW1wb3J0ICogYXMgZWNzIGZyb20gXCIuLi8uLi8uLi9hd3MtZWNzXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9hd3MtZWNzJ1xuaW1wb3J0IHsgQ29tbW9uRWNzUnVuVGFza1Byb3BzLCBFY3NSdW5UYXNrQmFzZSB9IGZyb20gJy4vcnVuLWVjcy10YXNrLWJhc2UnO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBSdW5FY3NFYzJUYXNrUHJvcHMgZXh0ZW5kcyBDb21tb25FY3NSdW5UYXNrUHJvcHMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICByZWFkb25seSBzdWJuZXRzPzogZWMyLlN1Ym5ldFNlbGVjdGlvbjtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICByZWFkb25seSBzZWN1cml0eUdyb3VwPzogZWMyLklTZWN1cml0eUdyb3VwO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHJlYWRvbmx5IHBsYWNlbWVudENvbnN0cmFpbnRzPzogZWNzLlBsYWNlbWVudENvbnN0cmFpbnRbXTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcmVhZG9ubHkgcGxhY2VtZW50U3RyYXRlZ2llcz86IGVjcy5QbGFjZW1lbnRTdHJhdGVneVtdO1xufVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIFJ1bkVjc0VjMlRhc2sgZXh0ZW5kcyBFY3NSdW5UYXNrQmFzZSB7XG4gICAgY29uc3RydWN0b3IocHJvcHM6IFJ1bkVjc0VjMlRhc2tQcm9wcykge1xuICAgICAgICBpZiAoIXByb3BzLnRhc2tEZWZpbml0aW9uLmlzRWMyQ29tcGF0aWJsZSkge1xuICAgICAgICAgICAgdGhyb3cgbmV3IEVycm9yKCdTdXBwbGllZCBUYXNrRGVmaW5pdGlvbiBpcyBub3QgY29uZmlndXJlZCBmb3IgY29tcGF0aWJpbGl0eSB3aXRoIEVDMicpO1xuICAgICAgICB9XG4gICAgICAgIGlmICghcHJvcHMuY2x1c3Rlci5oYXNFYzJDYXBhY2l0eSkge1xuICAgICAgICAgICAgdGhyb3cgbmV3IEVycm9yKCdDbHVzdGVyIGZvciB0aGlzIHNlcnZpY2UgbmVlZHMgRWMyIGNhcGFjaXR5LiBDYWxsIGFkZFh4eENhcGFjaXR5KCkgb24gdGhlIGNsdXN0ZXIuJyk7XG4gICAgICAgIH1cbiAgICAgICAgaWYgKCFwcm9wcy50YXNrRGVmaW5pdGlvbi5kZWZhdWx0Q29udGFpbmVyKSB7XG4gICAgICAgICAgICB0aHJvdyBuZXcgRXJyb3IoJ0EgVGFza0RlZmluaXRpb24gbXVzdCBoYXZlIGF0IGxlYXN0IG9uZSBlc3NlbnRpYWwgY29udGFpbmVyJyk7XG4gICAgICAgIH1cbiAgICAgICAgc3VwZXIoe1xuICAgICAgICAgICAgLi4ucHJvcHMsXG4gICAgICAgICAgICBwYXJhbWV0ZXJzOiB7XG4gICAgICAgICAgICAgICAgTGF1bmNoVHlwZTogJ0VDMicsXG4gICAgICAgICAgICAgICAgUGxhY2VtZW50Q29uc3RyYWludHM6IG5vRW1wdHkoZmxhdHRlbigocHJvcHMucGxhY2VtZW50Q29uc3RyYWludHMgfHwgW10pLm1hcChjID0+IGMudG9Kc29uKCkubWFwKHVwcGVyY2FzZUtleXMpKSkpLFxuICAgICAgICAgICAgICAgIFBsYWNlbWVudFN0cmF0ZWd5OiBub0VtcHR5KGZsYXR0ZW4oKHByb3BzLnBsYWNlbWVudFN0cmF0ZWdpZXMgfHwgW10pLm1hcChjID0+IGMudG9Kc29uKCkubWFwKHVwcGVyY2FzZUtleXMpKSkpLFxuICAgICAgICAgICAgfSxcbiAgICAgICAgfSk7XG4gICAgICAgIGlmIChwcm9wcy50YXNrRGVmaW5pdGlvbi5uZXR3b3JrTW9kZSA9PT0gZWNzLk5ldHdvcmtNb2RlLkFXU19WUEMpIHtcbiAgICAgICAgICAgIHRoaXMuY29uZmlndXJlQXdzVnBjTmV0d29ya2luZyhwcm9wcy5jbHVzdGVyLnZwYywgdW5kZWZpbmVkLCBwcm9wcy5zdWJuZXRzLCBwcm9wcy5zZWN1cml0eUdyb3VwKTtcbiAgICAgICAgfVxuICAgICAgICBlbHNlIHtcbiAgICAgICAgICAgIC8vIEVpdGhlciBOb25lLCBCcmlkZ2Ugb3IgSG9zdCBuZXR3b3JraW5nLiBDb3B5IFNlY3VyaXR5R3JvdXAgZnJvbSBBU0cuXG4gICAgICAgICAgICB2YWxpZGF0ZU5vTmV0d29ya2luZ1Byb3BzKHByb3BzKTtcbiAgICAgICAgICAgIHRoaXMuY29ubmVjdGlvbnMuYWRkU2VjdXJpdHlHcm91cCguLi5wcm9wcy5jbHVzdGVyLmNvbm5lY3Rpb25zLnNlY3VyaXR5R3JvdXBzKTtcbiAgICAgICAgfVxuICAgIH1cbn1cbi8qKlxuICogVmFsaWRhdGUgY29tYmluYXRpb25zIG9mIG5ldHdvcmtpbmcgYXJndW1lbnRzXG4gKi9cbmZ1bmN0aW9uIHZhbGlkYXRlTm9OZXR3b3JraW5nUHJvcHMocHJvcHM6IFJ1bkVjc0VjMlRhc2tQcm9wcykge1xuICAgIGlmIChwcm9wcy5zdWJuZXRzICE9PSB1bmRlZmluZWQgfHwgcHJvcHMuc2VjdXJpdHlHcm91cCAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICAgIHRocm93IG5ldyBFcnJvcigndnBjUGxhY2VtZW50IGFuZCBzZWN1cml0eUdyb3VwIGNhbiBvbmx5IGJlIHVzZWQgaW4gQXdzVnBjIG5ldHdvcmtpbmcgbW9kZScpO1xuICAgIH1cbn1cbmZ1bmN0aW9uIHVwcGVyY2FzZUtleXMob2JqOiB7XG4gICAgW2tleTogc3RyaW5nXTogYW55O1xufSk6IHtcbiAgICBba2V5OiBzdHJpbmddOiBhbnk7XG59IHtcbiAgICBjb25zdCByZXQ6IHtcbiAgICAgICAgW2tleTogc3RyaW5nXTogYW55O1xuICAgIH0gPSB7fTtcbiAgICBmb3IgKGNvbnN0IGtleSBvZiBPYmplY3Qua2V5cyhvYmopKSB7XG4gICAgICAgIHJldFtrZXkuc2xpY2UoMCwgMSkudG9VcHBlckNhc2UoKSArIGtleS5zbGljZSgxKV0gPSBvYmpba2V5XTtcbiAgICB9XG4gICAgcmV0dXJuIHJldDtcbn1cbmZ1bmN0aW9uIGZsYXR0ZW48QT4oeHM6IEFbXVtdKTogQVtdIHtcbiAgICByZXR1cm4gQXJyYXkucHJvdG90eXBlLmNvbmNhdChbXSwgLi4ueHMpO1xufVxuZnVuY3Rpb24gbm9FbXB0eTxBPih4czogQVtdKTogQVtdIHwgdW5kZWZpbmVkIHtcbiAgICBpZiAoeHMubGVuZ3RoID09PSAwKSB7XG4gICAgICAgIHJldHVybiB1bmRlZmluZWQ7XG4gICAgfVxuICAgIHJldHVybiB4cztcbn1cbiJdfQ==