/**
 * (experimental) Determines the level of detail about provisioned throughput consumption that is returned.
 *
 * @experimental
 */
export declare enum DynamoConsumedCapacity {
    /**
     * (experimental) The response includes the aggregate ConsumedCapacity for the operation, together with ConsumedCapacity for each table and secondary index that was accessed.
     *
     * @experimental
     */
    INDEXES = "INDEXES",
    /**
     * (experimental) The response includes only the aggregate ConsumedCapacity for the operation.
     *
     * @experimental
     */
    TOTAL = "TOTAL",
    /**
     * (experimental) No ConsumedCapacity details are included in the response.
     *
     * @experimental
     */
    NONE = "NONE"
}
/**
 * (experimental) Determines whether item collection metrics are returned.
 *
 * @experimental
 */
export declare enum DynamoItemCollectionMetrics {
    /**
     * (experimental) If set to SIZE, the response includes statistics about item collections, if any, that were modified during the operation.
     *
     * @experimental
     */
    SIZE = "SIZE",
    /**
     * (experimental) If set to NONE, no statistics are returned.
     *
     * @experimental
     */
    NONE = "NONE"
}
/**
 * (experimental) Use ReturnValues if you want to get the item attributes as they appear before or after they are changed.
 *
 * @experimental
 */
export declare enum DynamoReturnValues {
    /**
     * (experimental) Nothing is returned.
     *
     * @experimental
     */
    NONE = "NONE",
    /**
     * (experimental) Returns all of the attributes of the item.
     *
     * @experimental
     */
    ALL_OLD = "ALL_OLD",
    /**
     * (experimental) Returns only the updated attributes.
     *
     * @experimental
     */
    UPDATED_OLD = "UPDATED_OLD",
    /**
     * (experimental) Returns all of the attributes of the item.
     *
     * @experimental
     */
    ALL_NEW = "ALL_NEW",
    /**
     * (experimental) Returns only the updated attributes.
     *
     * @experimental
     */
    UPDATED_NEW = "UPDATED_NEW"
}
/**
 * (experimental) Class to generate projection expression.
 *
 * @experimental
 */
export declare class DynamoProjectionExpression {
    private expression;
    /**
     * (experimental) Adds the passed attribute to the chain.
     *
     * @param attr Attribute name.
     * @experimental
     */
    withAttribute(attr: string): DynamoProjectionExpression;
    /**
     * (experimental) Adds the array literal access for passed index.
     *
     * @param index array index.
     * @experimental
     */
    atIndex(index: number): DynamoProjectionExpression;
    /**
     * (experimental) converts and return the string expression.
     *
     * @experimental
     */
    toString(): string;
}
/**
 * (experimental) Represents the data for an attribute.
 *
 * Each attribute value is described as a name-value pair.
 * The name is the data type, and the value is the data itself.
 *
 * @see https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_AttributeValue.html
 * @experimental
 */
export declare class DynamoAttributeValue {
    /**
     * (experimental) Sets an attribute of type String.
     *
     * For example:  "S": "Hello"
     * Strings may be literal values or as JsonPath
     *
     * @experimental
     */
    static fromString(value: string): DynamoAttributeValue;
    /**
     * (experimental) Sets a literal number.
     *
     * For example: 1234
     * Numbers are sent across the network to DynamoDB as strings,
     * to maximize compatibility across languages and libraries.
     * However, DynamoDB treats them as number type attributes for mathematical operations.
     *
     * @experimental
     */
    static fromNumber(value: number): DynamoAttributeValue;
    /**
     * (experimental) Sets an attribute of type Number.
     *
     * For example:  "N": "123.45"
     * Numbers are sent across the network to DynamoDB as strings,
     * to maximize compatibility across languages and libraries.
     * However, DynamoDB treats them as number type attributes for mathematical operations.
     *
     * Numbers may be expressed as literal strings or as JsonPath
     *
     * @experimental
     */
    static numberFromString(value: string): DynamoAttributeValue;
    /**
     * (experimental) Sets an attribute of type Binary.
     *
     * For example:  "B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"
     *
     * @param value base-64 encoded string.
     * @experimental
     */
    static fromBinary(value: string): DynamoAttributeValue;
    /**
     * (experimental) Sets an attribute of type String Set.
     *
     * For example:  "SS": ["Giraffe", "Hippo" ,"Zebra"]
     *
     * @experimental
     */
    static fromStringSet(value: string[]): DynamoAttributeValue;
    /**
     * (experimental) Sets an attribute of type Number Set.
     *
     * For example:  "NS": ["42.2", "-19", "7.5", "3.14"]
     * Numbers are sent across the network to DynamoDB as strings,
     * to maximize compatibility across languages and libraries.
     * However, DynamoDB treats them as number type attributes for mathematical operations.
     *
     * @experimental
     */
    static fromNumberSet(value: number[]): DynamoAttributeValue;
    /**
     * (experimental) Sets an attribute of type Number Set.
     *
     * For example:  "NS": ["42.2", "-19", "7.5", "3.14"]
     * Numbers are sent across the network to DynamoDB as strings,
     * to maximize compatibility across languages and libraries.
     * However, DynamoDB treats them as number type attributes for mathematical operations.
     *
     * Numbers may be expressed as literal strings or as JsonPath
     *
     * @experimental
     */
    static numberSetFromStrings(value: string[]): DynamoAttributeValue;
    /**
     * (experimental) Sets an attribute of type Binary Set.
     *
     * For example:  "BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]
     *
     * @experimental
     */
    static fromBinarySet(value: string[]): DynamoAttributeValue;
    /**
     * (experimental) Sets an attribute of type Map.
     *
     * For example:  "M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}
     *
     * @experimental
     */
    static fromMap(value: {
        [key: string]: DynamoAttributeValue;
    }): DynamoAttributeValue;
    /**
     * (experimental) Sets an attribute of type Map.
     *
     * For example:  "M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}
     *
     * @param value Json path that specifies state input to be used.
     * @experimental
     */
    static mapFromJsonPath(value: string): DynamoAttributeValue;
    /**
     * (experimental) Sets an attribute of type List.
     *
     * For example:  "L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N", "3.14159"}]
     *
     * @experimental
     */
    static fromList(value: DynamoAttributeValue[]): DynamoAttributeValue;
    /**
     * (experimental) Sets an attribute of type Null.
     *
     * For example:  "NULL": true
     *
     * @experimental
     */
    static fromNull(value: boolean): DynamoAttributeValue;
    /**
     * (experimental) Sets an attribute of type Boolean.
     *
     * For example:  "BOOL": true
     *
     * @experimental
     */
    static fromBoolean(value: boolean): DynamoAttributeValue;
    /**
     * (experimental) Sets an attribute of type Boolean from state input through Json path.
     *
     * For example:  "BOOL": true
     *
     * @param value Json path that specifies state input to be used.
     * @experimental
     */
    static booleanFromJsonPath(value: string): DynamoAttributeValue;
    /**
     * (experimental) Represents the data for the attribute.
     *
     * Data can be
     * i.e. "S": "Hello"
     *
     * @experimental
     */
    readonly attributeValue: any;
    private constructor();
    /**
     * (experimental) Returns the DynamoDB attribute value.
     *
     * @experimental
     */
    toObject(): any;
}
