import * as ddb from "../../../aws-dynamodb";
import * as iam from "../../../aws-iam";
import * as sfn from "../../../aws-stepfunctions";
import { Construct } from 'constructs';
import { DynamoAttributeValue, DynamoConsumedCapacity, DynamoItemCollectionMetrics, DynamoReturnValues } from './shared-types';
/**
 * (experimental) Properties for DynamoPutItem Task.
 *
 * @experimental
 */
export interface DynamoPutItemProps extends sfn.TaskStateBaseProps {
    /**
     * (experimental) A map of attribute name/value pairs, one for each attribute.
     *
     * Only the primary key attributes are required;
     * you can optionally provide other attribute name-value pairs for the item.
     *
     * @see https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_PutItem.html#DDB-PutItem-request-Item
     * @experimental
     */
    readonly item: {
        [key: string]: DynamoAttributeValue;
    };
    /**
     * (experimental) The name of the table where the item should be written .
     *
     * @experimental
     */
    readonly table: ddb.ITable;
    /**
     * (experimental) A condition that must be satisfied in order for a conditional PutItem operation to succeed.
     *
     * @default - No condition expression
     * @see https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_PutItem.html#DDB-PutItem-request-ConditionExpression
     * @experimental
     */
    readonly conditionExpression?: string;
    /**
     * (experimental) One or more substitution tokens for attribute names in an expression.
     *
     * @default - No expression attribute names
     * @see https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_PutItem.html#DDB-PutItem-request-ExpressionAttributeNames
     * @experimental
     */
    readonly expressionAttributeNames?: {
        [key: string]: string;
    };
    /**
     * (experimental) One or more values that can be substituted in an expression.
     *
     * @default - No expression attribute values
     * @see https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_PutItem.html#DDB-PutItem-request-ExpressionAttributeValues
     * @experimental
     */
    readonly expressionAttributeValues?: {
        [key: string]: DynamoAttributeValue;
    };
    /**
     * (experimental) Determines the level of detail about provisioned throughput consumption that is returned in the response.
     *
     * @default DynamoConsumedCapacity.NONE
     * @see https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_PutItem.html#DDB-PutItem-request-ReturnConsumedCapacity
     * @experimental
     */
    readonly returnConsumedCapacity?: DynamoConsumedCapacity;
    /**
     * (experimental) The item collection metrics to returned in the response.
     *
     * @default DynamoItemCollectionMetrics.NONE
     * @see https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LSI.html#LSI.ItemCollections
     * @experimental
     */
    readonly returnItemCollectionMetrics?: DynamoItemCollectionMetrics;
    /**
     * (experimental) Use ReturnValues if you want to get the item attributes as they appeared before they were updated with the PutItem request.
     *
     * @default DynamoReturnValues.NONE
     * @see https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_PutItem.html#DDB-PutItem-request-ReturnValues
     * @experimental
     */
    readonly returnValues?: DynamoReturnValues;
}
/**
 * (experimental) A StepFunctions task to call DynamoPutItem.
 *
 * @experimental
 */
export declare class DynamoPutItem extends sfn.TaskStateBase {
    private readonly props;
    /**
     * @experimental
     */
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    /**
     * @experimental
     */
    protected readonly taskPolicies?: iam.PolicyStatement[];
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: DynamoPutItemProps);
}
