import * as batch from "../../../aws-batch";
import * as ec2 from "../../../aws-ec2";
import * as iam from "../../../aws-iam";
import * as sfn from "../../../aws-stepfunctions";
import { Size } from "../../../core";
import { Construct } from 'constructs';
/**
 * (experimental) The overrides that should be sent to a container.
 *
 * @experimental
 */
export interface BatchContainerOverrides {
    /**
     * (experimental) The command to send to the container that overrides the default command from the Docker image or the job definition.
     *
     * @default - No command overrides
     * @experimental
     */
    readonly command?: string[];
    /**
     * (experimental) The environment variables to send to the container.
     *
     * You can add new environment variables, which are added to the container
     * at launch, or you can override the existing environment variables from
     * the Docker image or the job definition.
     *
     * @default - No environment overrides
     * @experimental
     */
    readonly environment?: {
        [key: string]: string;
    };
    /**
     * (experimental) The instance type to use for a multi-node parallel job.
     *
     * This parameter is not valid for single-node container jobs.
     *
     * @default - No instance type overrides
     * @experimental
     */
    readonly instanceType?: ec2.InstanceType;
    /**
     * (experimental) Memory reserved for the job.
     *
     * @default - No memory overrides. The memory supplied in the job definition will be used.
     * @experimental
     */
    readonly memory?: Size;
    /**
     * (experimental) The number of physical GPUs to reserve for the container.
     *
     * The number of GPUs reserved for all containers in a job
     * should not exceed the number of available GPUs on the compute
     * resource that the job is launched on.
     *
     * @default - No GPU reservation
     * @experimental
     */
    readonly gpuCount?: number;
    /**
     * (experimental) The number of vCPUs to reserve for the container.
     *
     * This value overrides the value set in the job definition.
     *
     * @default - No vCPUs overrides
     * @experimental
     */
    readonly vcpus?: number;
}
/**
 * (experimental) An object representing an AWS Batch job dependency.
 *
 * @experimental
 */
export interface BatchJobDependency {
    /**
     * (experimental) The job ID of the AWS Batch job associated with this dependency.
     *
     * @default - No jobId
     * @experimental
     */
    readonly jobId?: string;
    /**
     * (experimental) The type of the job dependency.
     *
     * @default - No type
     * @experimental
     */
    readonly type?: string;
}
/**
 * (experimental) Properties for RunBatchJob.
 *
 * @experimental
 */
export interface BatchSubmitJobProps extends sfn.TaskStateBaseProps {
    /**
     * (experimental) The job definition used by this job.
     *
     * @experimental
     */
    readonly jobDefinition: batch.IJobDefinition;
    /**
     * (experimental) The name of the job.
     *
     * The first character must be alphanumeric, and up to 128 letters (uppercase and lowercase),
     * numbers, hyphens, and underscores are allowed.
     *
     * @experimental
     */
    readonly jobName: string;
    /**
     * (experimental) The job queue into which the job is submitted.
     *
     * @experimental
     */
    readonly jobQueue: batch.IJobQueue;
    /**
     * (experimental) The array size can be between 2 and 10,000.
     *
     * If you specify array properties for a job, it becomes an array job.
     * For more information, see Array Jobs in the AWS Batch User Guide.
     *
     * @default - No array size
     * @experimental
     */
    readonly arraySize?: number;
    /**
     * (experimental) A list of container overrides in JSON format that specify the name of a container in the specified job definition and the overrides it should receive.
     *
     * @default - No container overrides
     * @see https://docs.aws.amazon.com/batch/latest/APIReference/API_SubmitJob.html#Batch-SubmitJob-request-containerOverrides
     * @experimental
     */
    readonly containerOverrides?: BatchContainerOverrides;
    /**
     * (experimental) A list of dependencies for the job.
     *
     * A job can depend upon a maximum of 20 jobs.
     *
     * @default - No dependencies
     * @see https://docs.aws.amazon.com/batch/latest/APIReference/API_SubmitJob.html#Batch-SubmitJob-request-dependsOn
     * @experimental
     */
    readonly dependsOn?: BatchJobDependency[];
    /**
     * (experimental) The payload to be passed as parameters to the batch job.
     *
     * @default - No parameters are passed
     * @experimental
     */
    readonly payload?: sfn.TaskInput;
    /**
     * (experimental) The number of times to move a job to the RUNNABLE status.
     *
     * You may specify between 1 and 10 attempts.
     * If the value of attempts is greater than one,
     * the job is retried on failure the same number of attempts as the value.
     *
     * @default 1
     * @experimental
     */
    readonly attempts?: number;
}
/**
 * (experimental) Task to submits an AWS Batch job from a job definition.
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-batch.html
 * @experimental
 */
export declare class BatchSubmitJob extends sfn.TaskStateBase {
    private readonly props;
    private static readonly SUPPORTED_INTEGRATION_PATTERNS;
    /**
     * @experimental
     */
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    /**
     * @experimental
     */
    protected readonly taskPolicies?: iam.PolicyStatement[];
    private readonly integrationPattern;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: BatchSubmitJobProps);
    private configurePolicyStatements;
    private configureContainerOverrides;
}
