import * as batch from "../../../aws-batch";
import * as ec2 from "../../../aws-ec2";
import * as sfn from "../../../aws-stepfunctions";
import { Duration } from "../../../core";
/**
 * (experimental) The overrides that should be sent to a container.
 *
 * @experimental
 */
export interface ContainerOverrides {
    /**
     * (experimental) The command to send to the container that overrides the default command from the Docker image or the job definition.
     *
     * @default - No command overrides
     * @experimental
     */
    readonly command?: string[];
    /**
     * (experimental) The environment variables to send to the container.
     *
     * You can add new environment variables, which are added to the container
     * at launch, or you can override the existing environment variables from
     * the Docker image or the job definition.
     *
     * @default - No environment overrides
     * @experimental
     */
    readonly environment?: {
        [key: string]: string;
    };
    /**
     * (experimental) The instance type to use for a multi-node parallel job.
     *
     * This parameter is not valid for single-node container jobs.
     *
     * @default - No instance type overrides
     * @experimental
     */
    readonly instanceType?: ec2.InstanceType;
    /**
     * (experimental) The number of MiB of memory reserved for the job.
     *
     * This value overrides the value set in the job definition.
     *
     * @default - No memory overrides
     * @experimental
     */
    readonly memory?: number;
    /**
     * (experimental) The number of physical GPUs to reserve for the container.
     *
     * The number of GPUs reserved for all containers in a job
     * should not exceed the number of available GPUs on the compute
     * resource that the job is launched on.
     *
     * @default - No GPU reservation
     * @experimental
     */
    readonly gpuCount?: number;
    /**
     * (experimental) The number of vCPUs to reserve for the container.
     *
     * This value overrides the value set in the job definition.
     *
     * @default - No vCPUs overrides
     * @experimental
     */
    readonly vcpus?: number;
}
/**
 * (experimental) An object representing an AWS Batch job dependency.
 *
 * @experimental
 */
export interface JobDependency {
    /**
     * (experimental) The job ID of the AWS Batch job associated with this dependency.
     *
     * @default - No jobId
     * @experimental
     */
    readonly jobId?: string;
    /**
     * (experimental) The type of the job dependency.
     *
     * @default - No type
     * @experimental
     */
    readonly type?: string;
}
/**
 * (deprecated) Properties for RunBatchJob.
 *
 * @deprecated use `BatchSubmitJob`
 */
export interface RunBatchJobProps {
    /**
     * (deprecated) The job definition used by this job.
     *
     * @deprecated
     */
    readonly jobDefinition: batch.IJobDefinition;
    /**
     * (deprecated) The name of the job.
     *
     * The first character must be alphanumeric, and up to 128 letters (uppercase and lowercase),
     * numbers, hyphens, and underscores are allowed.
     *
     * @deprecated
     */
    readonly jobName: string;
    /**
     * (deprecated) The job queue into which the job is submitted.
     *
     * @deprecated
     */
    readonly jobQueue: batch.IJobQueue;
    /**
     * (deprecated) The array size can be between 2 and 10,000.
     *
     * If you specify array properties for a job, it becomes an array job.
     * For more information, see Array Jobs in the AWS Batch User Guide.
     *
     * @default - No array size
     * @deprecated
     */
    readonly arraySize?: number;
    /**
     * (deprecated) A list of container overrides in JSON format that specify the name of a container in the specified job definition and the overrides it should receive.
     *
     * @default - No container overrides
     * @see https://docs.aws.amazon.com/batch/latest/APIReference/API_SubmitJob.html#Batch-SubmitJob-request-containerOverrides
     * @deprecated
     */
    readonly containerOverrides?: ContainerOverrides;
    /**
     * (deprecated) A list of dependencies for the job.
     *
     * A job can depend upon a maximum of 20 jobs.
     *
     * @default - No dependencies
     * @see https://docs.aws.amazon.com/batch/latest/APIReference/API_SubmitJob.html#Batch-SubmitJob-request-dependsOn
     * @deprecated
     */
    readonly dependsOn?: JobDependency[];
    /**
     * (deprecated) The payload to be passed as parametrs to the batch job.
     *
     * @default - No parameters are passed
     * @deprecated
     */
    readonly payload?: {
        [key: string]: any;
    };
    /**
     * (deprecated) The number of times to move a job to the RUNNABLE status.
     *
     * You may specify between 1 and 10 attempts.
     * If the value of attempts is greater than one,
     * the job is retried on failure the same number of attempts as the value.
     *
     * @default - 1
     * @deprecated
     */
    readonly attempts?: number;
    /**
     * (deprecated) The timeout configuration for this SubmitJob operation.
     *
     * The minimum value for the timeout is 60 seconds.
     *
     * @default - No timeout
     * @see https://docs.aws.amazon.com/batch/latest/APIReference/API_SubmitJob.html#Batch-SubmitJob-request-timeout
     * @deprecated
     */
    readonly timeout?: Duration;
    /**
     * (deprecated) The service integration pattern indicates different ways to call TerminateCluster.
     *
     * The valid value is either FIRE_AND_FORGET or SYNC.
     *
     * @default SYNC
     * @deprecated
     */
    readonly integrationPattern?: sfn.ServiceIntegrationPattern;
}
/**
 * (deprecated) A Step Functions Task to run AWS Batch.
 *
 * @deprecated use `BatchSubmitJob`
 */
export declare class RunBatchJob implements sfn.IStepFunctionsTask {
    private readonly props;
    private readonly integrationPattern;
    /**
     * @deprecated
     */
    constructor(props: RunBatchJobProps);
    /**
     * (deprecated) Called when the task object is used in a workflow.
     *
     * @deprecated
     */
    bind(_task: sfn.Task): sfn.StepFunctionsTaskConfig;
    private configurePolicyStatements;
    private configureContainerOverrides;
}
