import * as cdk from "../../core";
/**
 * Properties for defining a `AWS::SQS::Queue`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html
 * @external
 */
export interface CfnQueueProps {
    /**
     * `AWS::SQS::Queue.ContentBasedDeduplication`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-contentbaseddeduplication
     * @external
     */
    readonly contentBasedDeduplication?: boolean | cdk.IResolvable;
    /**
     * `AWS::SQS::Queue.DelaySeconds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-delayseconds
     * @external
     */
    readonly delaySeconds?: number;
    /**
     * `AWS::SQS::Queue.FifoQueue`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-fifoqueue
     * @external
     */
    readonly fifoQueue?: boolean | cdk.IResolvable;
    /**
     * `AWS::SQS::Queue.KmsDataKeyReusePeriodSeconds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-kmsdatakeyreuseperiodseconds
     * @external
     */
    readonly kmsDataKeyReusePeriodSeconds?: number;
    /**
     * `AWS::SQS::Queue.KmsMasterKeyId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-kmsmasterkeyid
     * @external
     */
    readonly kmsMasterKeyId?: string;
    /**
     * `AWS::SQS::Queue.MaximumMessageSize`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-maxmesgsize
     * @external
     */
    readonly maximumMessageSize?: number;
    /**
     * `AWS::SQS::Queue.MessageRetentionPeriod`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-msgretentionperiod
     * @external
     */
    readonly messageRetentionPeriod?: number;
    /**
     * `AWS::SQS::Queue.QueueName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-name
     * @external
     */
    readonly queueName?: string;
    /**
     * `AWS::SQS::Queue.ReceiveMessageWaitTimeSeconds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-receivemsgwaittime
     * @external
     */
    readonly receiveMessageWaitTimeSeconds?: number;
    /**
     * `AWS::SQS::Queue.RedrivePolicy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-redrive
     * @external
     */
    readonly redrivePolicy?: any | cdk.IResolvable;
    /**
     * `AWS::SQS::Queue.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#cfn-sqs-queue-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::SQS::Queue.VisibilityTimeout`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-visiblitytimeout
     * @external
     */
    readonly visibilityTimeout?: number;
}
/**
 * A CloudFormation `AWS::SQS::Queue`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html
 * @external
 * @cloudformationResource AWS::SQS::Queue
 */
export declare class CfnQueue extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SQS::Queue";
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute QueueName
     */
    readonly attrQueueName: string;
    /**
     * `AWS::SQS::Queue.ContentBasedDeduplication`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-contentbaseddeduplication
     * @external
     */
    contentBasedDeduplication: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::SQS::Queue.DelaySeconds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-delayseconds
     * @external
     */
    delaySeconds: number | undefined;
    /**
     * `AWS::SQS::Queue.FifoQueue`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-fifoqueue
     * @external
     */
    fifoQueue: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::SQS::Queue.KmsDataKeyReusePeriodSeconds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-kmsdatakeyreuseperiodseconds
     * @external
     */
    kmsDataKeyReusePeriodSeconds: number | undefined;
    /**
     * `AWS::SQS::Queue.KmsMasterKeyId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-kmsmasterkeyid
     * @external
     */
    kmsMasterKeyId: string | undefined;
    /**
     * `AWS::SQS::Queue.MaximumMessageSize`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-maxmesgsize
     * @external
     */
    maximumMessageSize: number | undefined;
    /**
     * `AWS::SQS::Queue.MessageRetentionPeriod`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-msgretentionperiod
     * @external
     */
    messageRetentionPeriod: number | undefined;
    /**
     * `AWS::SQS::Queue.QueueName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-name
     * @external
     */
    queueName: string | undefined;
    /**
     * `AWS::SQS::Queue.ReceiveMessageWaitTimeSeconds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-receivemsgwaittime
     * @external
     */
    receiveMessageWaitTimeSeconds: number | undefined;
    /**
     * `AWS::SQS::Queue.RedrivePolicy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-redrive
     * @external
     */
    redrivePolicy: any | cdk.IResolvable | undefined;
    /**
     * `AWS::SQS::Queue.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#cfn-sqs-queue-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::SQS::Queue.VisibilityTimeout`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-visiblitytimeout
     * @external
     */
    visibilityTimeout: number | undefined;
    /**
     * Create a new `AWS::SQS::Queue`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnQueueProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::SQS::QueuePolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html
 * @external
 */
export interface CfnQueuePolicyProps {
    /**
     * `AWS::SQS::QueuePolicy.PolicyDocument`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html#cfn-sqs-queuepolicy-policydoc
     * @external
     */
    readonly policyDocument: any | cdk.IResolvable;
    /**
     * `AWS::SQS::QueuePolicy.Queues`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html#cfn-sqs-queuepolicy-queues
     * @external
     */
    readonly queues: string[];
}
/**
 * A CloudFormation `AWS::SQS::QueuePolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html
 * @external
 * @cloudformationResource AWS::SQS::QueuePolicy
 */
export declare class CfnQueuePolicy extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SQS::QueuePolicy";
    /**
     * `AWS::SQS::QueuePolicy.PolicyDocument`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html#cfn-sqs-queuepolicy-policydoc
     * @external
     */
    policyDocument: any | cdk.IResolvable;
    /**
     * `AWS::SQS::QueuePolicy.Queues`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html#cfn-sqs-queuepolicy-queues
     * @external
     */
    queues: string[];
    /**
     * Create a new `AWS::SQS::QueuePolicy`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnQueuePolicyProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
