import { PolicyDocument } from "../../aws-iam";
import { Resource } from "../../core";
import { Construct } from 'constructs';
import { IQueue } from './queue-base';
/**
 * (experimental) Properties to associate SQS queues with a policy.
 *
 * @experimental
 */
export interface QueuePolicyProps {
    /**
     * (experimental) The set of queues this policy applies to.
     *
     * @experimental
     */
    readonly queues: IQueue[];
}
/**
 * (experimental) Applies a policy to SQS queues.
 *
 * @experimental
 */
export declare class QueuePolicy extends Resource {
    /**
     * (experimental) The IAM policy document for this policy.
     *
     * @experimental
     */
    readonly document: PolicyDocument;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: QueuePolicyProps);
}
