import { IKey } from "../../aws-kms";
import { Construct } from 'constructs';
import { ITopic, TopicBase } from './topic-base';
/**
 * (experimental) Properties for a new SNS topic.
 *
 * @experimental
 */
export interface TopicProps {
    /**
     * (experimental) A developer-defined string that can be used to identify this SNS topic.
     *
     * @default None
     * @experimental
     */
    readonly displayName?: string;
    /**
     * (experimental) A name for the topic.
     *
     * If you don't specify a name, AWS CloudFormation generates a unique
     * physical ID and uses that ID for the topic name. For more information,
     * see Name Type.
     *
     * @default Generated name
     * @experimental
     */
    readonly topicName?: string;
    /**
     * (experimental) A KMS Key, either managed by this CDK app, or imported.
     *
     * @default None
     * @experimental
     */
    readonly masterKey?: IKey;
}
/**
 * (experimental) A new SNS topic.
 *
 * @experimental
 */
export declare class Topic extends TopicBase {
    /**
     * (experimental) Import an existing SNS topic provided an ARN.
     *
     * @param scope The parent creating construct.
     * @param id The construct's name.
     * @param topicArn topic ARN (i.e. arn:aws:sns:us-east-2:444455556666:MyTopic).
     * @experimental
     */
    static fromTopicArn(scope: Construct, id: string, topicArn: string): ITopic;
    /**
     * (experimental) The ARN of the topic.
     *
     * @experimental
     */
    readonly topicArn: string;
    /**
     * (experimental) The name of the topic.
     *
     * @experimental
     */
    readonly topicName: string;
    /**
     * (experimental) Controls automatic creation of policy objects.
     *
     * Set by subclasses.
     *
     * @experimental
     */
    protected readonly autoCreatePolicy: boolean;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: TopicProps);
}
