import { IQueue } from "../../aws-sqs";
import { Resource } from "../../core";
import { Construct } from 'constructs';
import { SubscriptionFilter } from './subscription-filter';
import { ITopic } from './topic-base';
/**
 * (experimental) Options for creating a new subscription.
 *
 * @experimental
 */
export interface SubscriptionOptions {
    /**
     * (experimental) What type of subscription to add.
     *
     * @experimental
     */
    readonly protocol: SubscriptionProtocol;
    /**
     * (experimental) The subscription endpoint.
     *
     * The meaning of this value depends on the value for 'protocol'.
     *
     * @experimental
     */
    readonly endpoint: string;
    /**
     * (experimental) true if raw message delivery is enabled for the subscription.
     *
     * Raw messages are free of JSON formatting and can be
     * sent to HTTP/S and Amazon SQS endpoints. For more information, see GetSubscriptionAttributes in the Amazon Simple
     * Notification Service API Reference.
     *
     * @default false
     * @experimental
     */
    readonly rawMessageDelivery?: boolean;
    /**
     * (experimental) The filter policy.
     *
     * @default - all messages are delivered
     * @experimental
     */
    readonly filterPolicy?: {
        [attribute: string]: SubscriptionFilter;
    };
    /**
     * (experimental) The region where the topic resides, in the case of cross-region subscriptions.
     *
     * @default - the region where the CloudFormation stack is being deployed.
     * @experimental
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-subscription.html#cfn-sns-subscription-region
     */
    readonly region?: string;
    /**
     * (experimental) Queue to be used as dead letter queue.
     *
     * If not passed no dead letter queue is enabled.
     *
     * @default - No dead letter queue enabled.
     * @experimental
     */
    readonly deadLetterQueue?: IQueue;
}
/**
 * (experimental) Properties for creating a new subscription.
 *
 * @experimental
 */
export interface SubscriptionProps extends SubscriptionOptions {
    /**
     * (experimental) The topic to subscribe to.
     *
     * @experimental
     */
    readonly topic: ITopic;
}
/**
 * (experimental) A new subscription.
 *
 * Prefer to use the `ITopic.addSubscription()` methods to create instances of
 * this class.
 *
 * @experimental
 */
export declare class Subscription extends Resource {
    /**
     * (experimental) The DLQ associated with this subscription if present.
     *
     * @experimental
     */
    readonly deadLetterQueue?: IQueue;
    private readonly filterPolicy?;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: SubscriptionProps);
    private buildDeadLetterQueue;
    private buildDeadLetterConfig;
}
/**
 * (experimental) The type of subscription, controlling the type of the endpoint parameter.
 *
 * @experimental
 */
export declare enum SubscriptionProtocol {
    /**
     * (experimental) JSON-encoded message is POSTED to an HTTP url.
     *
     * @experimental
     */
    HTTP = "http",
    /**
     * (experimental) JSON-encoded message is POSTed to an HTTPS url.
     *
     * @experimental
     */
    HTTPS = "https",
    /**
     * (experimental) Notifications are sent via email.
     *
     * @experimental
     */
    EMAIL = "email",
    /**
     * (experimental) Notifications are JSON-encoded and sent via mail.
     *
     * @experimental
     */
    EMAIL_JSON = "email-json",
    /**
     * (experimental) Notification is delivered by SMS.
     *
     * @experimental
     */
    SMS = "sms",
    /**
     * (experimental) Notifications are enqueued into an SQS queue.
     *
     * @experimental
     */
    SQS = "sqs",
    /**
     * (experimental) JSON-encoded notifications are sent to a mobile app endpoint.
     *
     * @experimental
     */
    APPLICATION = "application",
    /**
     * (experimental) Notifications trigger a Lambda function.
     *
     * @experimental
     */
    LAMBDA = "lambda"
}
