import * as sns from "../../aws-sns";
import { SubscriptionProps } from './subscription';
/**
 * (experimental) Options for URL subscriptions.
 *
 * @experimental
 */
export interface UrlSubscriptionProps extends SubscriptionProps {
    /**
     * (experimental) The message to the queue is the same as it was sent to the topic.
     *
     * If false, the message will be wrapped in an SNS envelope.
     *
     * @default false
     * @experimental
     */
    readonly rawMessageDelivery?: boolean;
    /**
     * (experimental) The subscription's protocol.
     *
     * @default - Protocol is derived from url
     * @experimental
     */
    readonly protocol?: sns.SubscriptionProtocol;
}
/**
 * (experimental) Use a URL as a subscription target.
 *
 * The message will be POSTed to the given URL.
 *
 * @see https://docs.aws.amazon.com/sns/latest/dg/sns-http-https-endpoint-as-subscriber.html
 * @experimental
 */
export declare class UrlSubscription implements sns.ITopicSubscription {
    private readonly url;
    private readonly props;
    private readonly protocol;
    private readonly unresolvedUrl;
    /**
     * @experimental
     */
    constructor(url: string, props?: UrlSubscriptionProps);
    /**
     * (experimental) Returns a configuration for a URL to subscribe to an SNS topic.
     *
     * @experimental
     */
    bind(_topic: sns.ITopic): sns.TopicSubscriptionConfig;
}
