import * as lambda from "../../aws-lambda";
import * as sns from "../../aws-sns";
import { SubscriptionProps } from './subscription';
/**
 * (experimental) Properties for a Lambda subscription.
 *
 * @experimental
 */
export interface LambdaSubscriptionProps extends SubscriptionProps {
}
/**
 * (experimental) Use a Lambda function as a subscription target.
 *
 * @experimental
 */
export declare class LambdaSubscription implements sns.ITopicSubscription {
    private readonly fn;
    private readonly props;
    /**
     * @experimental
     */
    constructor(fn: lambda.IFunction, props?: LambdaSubscriptionProps);
    /**
     * (experimental) Returns a configuration for a Lambda function to subscribe to an SNS topic.
     *
     * @experimental
     */
    bind(topic: sns.ITopic): sns.TopicSubscriptionConfig;
    private regionFromArn;
}
