import * as sns from "../../aws-sns";
import { SubscriptionProps } from './subscription';
/**
 * (experimental) Options for email subscriptions.
 *
 * @experimental
 */
export interface EmailSubscriptionProps extends SubscriptionProps {
    /**
     * (experimental) Indicates if the full notification JSON should be sent to the email address or just the message text.
     *
     * @default false (Message text)
     * @experimental
     */
    readonly json?: boolean;
}
/**
 * (experimental) Use an email address as a subscription target.
 *
 * Email subscriptions require confirmation.
 *
 * @experimental
 */
export declare class EmailSubscription implements sns.ITopicSubscription {
    private readonly emailAddress;
    private readonly props;
    /**
     * @experimental
     */
    constructor(emailAddress: string, props?: EmailSubscriptionProps);
    /**
     * (experimental) Returns a configuration for an email address to subscribe to an SNS topic.
     *
     * @experimental
     */
    bind(_topic: sns.ITopic): sns.TopicSubscriptionConfig;
}
