import * as kms from "../../aws-kms";
import * as s3 from "../../aws-s3";
import * as ses from "../../aws-ses";
import * as sns from "../../aws-sns";
/**
 * (experimental) Construction properties for a S3 action.
 *
 * @experimental
 */
export interface S3Props {
    /**
     * (experimental) The S3 bucket that incoming email will be saved to.
     *
     * @experimental
     */
    readonly bucket: s3.IBucket;
    /**
     * (experimental) The master key that SES should use to encrypt your emails before saving them to the S3 bucket.
     *
     * @default no encryption
     * @experimental
     */
    readonly kmsKey?: kms.IKey;
    /**
     * (experimental) The key prefix of the S3 bucket.
     *
     * @default no prefix
     * @experimental
     */
    readonly objectKeyPrefix?: string;
    /**
     * (experimental) The SNS topic to notify when the S3 action is taken.
     *
     * @default no notification
     * @experimental
     */
    readonly topic?: sns.ITopic;
}
/**
 * (experimental) Saves the received message to an Amazon S3 bucket and, optionally, publishes a notification to Amazon SNS.
 *
 * @experimental
 */
export declare class S3 implements ses.IReceiptRuleAction {
    private readonly props;
    /**
     * @experimental
     */
    constructor(props: S3Props);
    /**
     * (experimental) Returns the receipt rule action specification.
     *
     * @experimental
     */
    bind(rule: ses.IReceiptRule): ses.ReceiptRuleActionConfig;
}
