import * as ses from "../../aws-ses";
/**
 * (experimental) Construction properties for a add header action.
 *
 * @experimental
 */
export interface AddHeaderProps {
    /**
     * (experimental) The name of the header to add.
     *
     * Must be between 1 and 50 characters,
     * inclusive, and consist of alphanumeric (a-z, A-Z, 0-9) characters
     * and dashes only.
     *
     * @experimental
     */
    readonly name: string;
    /**
     * (experimental) The value of the header to add.
     *
     * Must be less than 2048 characters,
     * and must not contain newline characters ("\r" or "\n").
     *
     * @experimental
     */
    readonly value: string;
}
/**
 * (experimental) Adds a header to the received email.
 *
 * @experimental
 */
export declare class AddHeader implements ses.IReceiptRuleAction {
    private readonly name;
    private readonly value;
    /**
     * @experimental
     */
    constructor(props: AddHeaderProps);
    /**
     * (experimental) Returns the receipt rule action specification.
     *
     * @experimental
     */
    bind(_rule: ses.IReceiptRule): ses.ReceiptRuleActionConfig;
}
