"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PublicDnsNamespace = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const namespace_1 = require("./namespace");
const service_1 = require("./service");
const servicediscovery_generated_1 = require("./servicediscovery.generated");
/**
 * (experimental) Define a Public DNS Namespace.
 *
 * @experimental
 */
class PublicDnsNamespace extends core_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        const ns = new servicediscovery_generated_1.CfnPublicDnsNamespace(this, 'Resource', {
            name: props.name,
            description: props.description,
        });
        this.namespaceName = props.name;
        this.namespaceId = ns.attrId;
        this.namespaceArn = ns.attrArn;
        this.type = namespace_1.NamespaceType.DNS_PUBLIC;
    }
    /**
     * @experimental
     */
    static fromPublicDnsNamespaceAttributes(scope, id, attrs) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.namespaceName = attrs.namespaceName;
                this.namespaceId = attrs.namespaceId;
                this.namespaceArn = attrs.namespaceArn;
                this.type = namespace_1.NamespaceType.DNS_PUBLIC;
            }
        }
        return new Import(scope, id);
    }
    /**
     * @experimental
     * @attribute true
     */
    get publicDnsNamespaceArn() { return this.namespaceArn; }
    /**
     * @experimental
     * @attribute true
     */
    get publicDnsNamespaceName() { return this.namespaceName; }
    /**
     * @experimental
     * @attribute true
     */
    get publicDnsNamespaceId() { return this.namespaceId; }
    /**
     * (experimental) Creates a service within the namespace.
     *
     * @experimental
     */
    createService(id, props) {
        return new service_1.Service(this, id, {
            namespace: this,
            ...props,
        });
    }
}
exports.PublicDnsNamespace = PublicDnsNamespace;
//# sourceMappingURL=data:application/json;base64,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