import { Resource } from "../../core";
import { Construct } from 'constructs';
import { BaseNamespaceProps, INamespace, NamespaceType } from './namespace';
import { DnsServiceProps, Service } from './service';
/**
 * @experimental
 */
export interface PublicDnsNamespaceProps extends BaseNamespaceProps {
}
/**
 * @experimental
 */
export interface IPublicDnsNamespace extends INamespace {
}
/**
 * @experimental
 */
export interface PublicDnsNamespaceAttributes {
    /**
     * (experimental) A name for the Namespace.
     *
     * @experimental
     */
    readonly namespaceName: string;
    /**
     * (experimental) Namespace Id for the Namespace.
     *
     * @experimental
     */
    readonly namespaceId: string;
    /**
     * (experimental) Namespace ARN for the Namespace.
     *
     * @experimental
     */
    readonly namespaceArn: string;
}
/**
 * (experimental) Define a Public DNS Namespace.
 *
 * @experimental
 */
export declare class PublicDnsNamespace extends Resource implements IPublicDnsNamespace {
    /**
     * @experimental
     */
    static fromPublicDnsNamespaceAttributes(scope: Construct, id: string, attrs: PublicDnsNamespaceAttributes): IPublicDnsNamespace;
    /**
     * (experimental) A name for the namespace.
     *
     * @experimental
     */
    readonly namespaceName: string;
    /**
     * (experimental) Namespace Id for the namespace.
     *
     * @experimental
     */
    readonly namespaceId: string;
    /**
     * (experimental) Namespace Arn for the namespace.
     *
     * @experimental
     */
    readonly namespaceArn: string;
    /**
     * (experimental) Type of the namespace.
     *
     * @experimental
     */
    readonly type: NamespaceType;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: PublicDnsNamespaceProps);
    /**
     * @experimental
     * @attribute true
     */
    get publicDnsNamespaceArn(): string;
    /**
     * @experimental
     * @attribute true
     */
    get publicDnsNamespaceName(): string;
    /**
     * @experimental
     * @attribute true
     */
    get publicDnsNamespaceId(): string;
    /**
     * (experimental) Creates a service within the namespace.
     *
     * @experimental
     */
    createService(id: string, props?: DnsServiceProps): Service;
}
