"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NonIpInstance = void 0;
const instance_1 = require("./instance");
const namespace_1 = require("./namespace");
const servicediscovery_generated_1 = require("./servicediscovery.generated");
/**
 * (experimental) Instance accessible using values other than an IP address or a domain name (CNAME).
 *
 * Specify the other values in Custom attributes.
 *
 * @experimental
 * @resource AWS::ServiceDiscovery::Instance
 */
class NonIpInstance extends instance_1.InstanceBase {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        if (props.service.namespace.type !== namespace_1.NamespaceType.HTTP) {
            throw new Error('This type of instance can only be registered for HTTP namespaces.');
        }
        if (props.customAttributes === undefined || Object.keys(props.customAttributes).length === 0) {
            throw new Error('You must specify at least one custom attribute for this instance type.');
        }
        const resource = new servicediscovery_generated_1.CfnInstance(this, 'Resource', {
            instanceId: props.instanceId || this.uniqueInstanceId(),
            serviceId: props.service.serviceId,
            instanceAttributes: {
                ...props.customAttributes,
            },
        });
        this.service = props.service;
        this.instanceId = resource.ref;
    }
}
exports.NonIpInstance = NonIpInstance;
//# sourceMappingURL=data:application/json;base64,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