import { IResource } from "../../core";
/**
 * @experimental
 */
export interface INamespace extends IResource {
    /**
     * (experimental) A name for the Namespace.
     *
     * @experimental
     * @attribute true
     */
    readonly namespaceName: string;
    /**
     * (experimental) Namespace Id for the Namespace.
     *
     * @experimental
     * @attribute true
     */
    readonly namespaceId: string;
    /**
     * (experimental) Namespace ARN for the Namespace.
     *
     * @experimental
     * @attribute true
     */
    readonly namespaceArn: string;
    /**
     * (experimental) Type of Namespace.
     *
     * @experimental
     */
    readonly type: NamespaceType;
}
/**
 * @experimental
 */
export interface BaseNamespaceProps {
    /**
     * (experimental) A name for the Namespace.
     *
     * @experimental
     */
    readonly name: string;
    /**
     * (experimental) A description of the Namespace.
     *
     * @default none
     * @experimental
     */
    readonly description?: string;
}
/**
 * @experimental
 */
export declare enum NamespaceType {
    /**
     * (experimental) Choose this option if you want your application to use only API calls to discover registered instances.
     *
     * @experimental
     */
    HTTP = "HTTP",
    /**
     * (experimental) Choose this option if you want your application to be able to discover instances using either API calls or using DNS queries in a VPC.
     *
     * @experimental
     */
    DNS_PRIVATE = "DNS_PRIVATE",
    /**
     * (experimental) Choose this option if you want your application to be able to discover instances using either API calls or using public DNS queries.
     *
     * You aren't required to use both methods.
     *
     * @experimental
     */
    DNS_PUBLIC = "DNS_PUBLIC"
}
