"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CnameInstance = void 0;
const instance_1 = require("./instance");
const namespace_1 = require("./namespace");
const service_1 = require("./service");
const servicediscovery_generated_1 = require("./servicediscovery.generated");
/**
 * (experimental) Instance that is accessible using a domain name (CNAME).
 *
 * @experimental
 * @resource AWS::ServiceDiscovery::Instance
 */
class CnameInstance extends instance_1.InstanceBase {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        if (props.service.namespace.type === namespace_1.NamespaceType.HTTP) {
            throw new Error('Namespace associated with Service must be a DNS Namespace.');
        }
        if (props.service.dnsRecordType !== service_1.DnsRecordType.CNAME) {
            throw new Error('A `CnameIntance` can only be used with a service using a `CNAME` record.');
        }
        const resource = new servicediscovery_generated_1.CfnInstance(this, 'Resource', {
            instanceId: props.instanceId || this.uniqueInstanceId(),
            serviceId: props.service.serviceId,
            instanceAttributes: {
                AWS_INSTANCE_CNAME: props.instanceCname,
                ...props.customAttributes,
            },
        });
        this.service = props.service;
        this.instanceId = resource.ref;
        this.cname = props.instanceCname;
    }
}
exports.CnameInstance = CnameInstance;
//# sourceMappingURL=data:application/json;base64,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