import * as iam from "../../aws-iam";
import * as kms from "../../aws-kms";
import { IResource, RemovalPolicy, Resource, SecretValue } from "../../core";
import { Construct } from 'constructs';
import { RotationSchedule, RotationScheduleOptions } from './rotation-schedule';
/**
 * (experimental) A secret in AWS Secrets Manager.
 *
 * @experimental
 */
export interface ISecret extends IResource {
    /**
     * (experimental) The customer-managed encryption key that is used to encrypt this secret, if any.
     *
     * When not specified, the default
     * KMS key for the account and region is being used.
     *
     * @experimental
     */
    readonly encryptionKey?: kms.IKey;
    /**
     * (experimental) The ARN of the secret in AWS Secrets Manager.
     *
     * @experimental
     * @attribute true
     */
    readonly secretArn: string;
    /**
     * (experimental) The name of the secret.
     *
     * @experimental
     */
    readonly secretName: string;
    /**
     * (experimental) Retrieve the value of the stored secret as a `SecretValue`.
     *
     * @experimental
     * @attribute true
     */
    readonly secretValue: SecretValue;
    /**
     * (experimental) Interpret the secret as a JSON object and return a field's value from it as a `SecretValue`.
     *
     * @experimental
     */
    secretValueFromJson(key: string): SecretValue;
    /**
     * (experimental) Grants reading the secret value to some role.
     *
     * @param grantee the principal being granted permission.
     * @param versionStages the version stages the grant is limited to.
     * @experimental
     */
    grantRead(grantee: iam.IGrantable, versionStages?: string[]): iam.Grant;
    /**
     * (experimental) Grants writing and updating the secret value to some role.
     *
     * @param grantee the principal being granted permission.
     * @experimental
     */
    grantWrite(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Adds a rotation schedule to the secret.
     *
     * @experimental
     */
    addRotationSchedule(id: string, options: RotationScheduleOptions): RotationSchedule;
    /**
     * (experimental) Adds a statement to the IAM resource policy associated with this secret.
     *
     * If this secret was created in this stack, a resource policy will be
     * automatically created upon the first call to `addToResourcePolicy`. If
     * the secret is imported, then this is a no-op.
     *
     * @experimental
     */
    addToResourcePolicy(statement: iam.PolicyStatement): iam.AddToResourcePolicyResult;
    /**
     * (experimental) Denies the `DeleteSecret` action to all principals within the current account.
     *
     * @experimental
     */
    denyAccountRootDelete(): void;
}
/**
 * (experimental) The properties required to create a new secret in AWS Secrets Manager.
 *
 * @experimental
 */
export interface SecretProps {
    /**
     * (experimental) An optional, human-friendly description of the secret.
     *
     * @default - No description.
     * @experimental
     */
    readonly description?: string;
    /**
     * (experimental) The customer-managed encryption key to use for encrypting the secret value.
     *
     * @default - A default KMS key for the account and region is used.
     * @experimental
     */
    readonly encryptionKey?: kms.IKey;
    /**
     * (experimental) Configuration for how to generate a secret value.
     *
     * @default - 32 characters with upper-case letters, lower-case letters, punctuation and numbers (at least one from each
     * category), per the default values of ``SecretStringGenerator``.
     * @experimental
     */
    readonly generateSecretString?: SecretStringGenerator;
    /**
     * (experimental) A name for the secret.
     *
     * Note that deleting secrets from SecretsManager does not happen immediately, but after a 7 to
     * 30 days blackout period. During that period, it is not possible to create another secret that shares the same name.
     *
     * @default - A name is generated by CloudFormation.
     * @experimental
     */
    readonly secretName?: string;
    /**
     * (experimental) Policy to apply when the secret is removed from this stack.
     *
     * @default - Not set.
     * @experimental
     */
    readonly removalPolicy?: RemovalPolicy;
}
/**
 * (experimental) Attributes required to import an existing secret into the Stack.
 *
 * @experimental
 */
export interface SecretAttributes {
    /**
     * (experimental) The encryption key that is used to encrypt the secret, unless the default SecretsManager key is used.
     *
     * @experimental
     */
    readonly encryptionKey?: kms.IKey;
    /**
     * (experimental) The ARN of the secret in SecretsManager.
     *
     * @experimental
     */
    readonly secretArn: string;
}
/**
 * The common behavior of Secrets. Users should not use this class directly, and instead use ``Secret``.
 */
declare abstract class SecretBase extends Resource implements ISecret {
    abstract readonly encryptionKey?: kms.IKey;
    abstract readonly secretArn: string;
    abstract readonly secretName: string;
    protected abstract readonly autoCreatePolicy: boolean;
    private policy?;
    /**
     * (experimental) Grants reading the secret value to some role.
     *
     * @experimental
     */
    grantRead(grantee: iam.IGrantable, versionStages?: string[]): iam.Grant;
    /**
     * (experimental) Grants writing and updating the secret value to some role.
     *
     * @experimental
     */
    grantWrite(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Retrieve the value of the stored secret as a `SecretValue`.
     *
     * @experimental
     */
    get secretValue(): SecretValue;
    /**
     * (experimental) Interpret the secret as a JSON object and return a field's value from it as a `SecretValue`.
     *
     * @experimental
     */
    secretValueFromJson(jsonField: string): SecretValue;
    /**
     * (experimental) Adds a rotation schedule to the secret.
     *
     * @experimental
     */
    addRotationSchedule(id: string, options: RotationScheduleOptions): RotationSchedule;
    /**
     * (experimental) Adds a statement to the IAM resource policy associated with this secret.
     *
     * If this secret was created in this stack, a resource policy will be
     * automatically created upon the first call to `addToResourcePolicy`. If
     * the secret is imported, then this is a no-op.
     *
     * @experimental
     */
    addToResourcePolicy(statement: iam.PolicyStatement): iam.AddToResourcePolicyResult;
    /**
     * (experimental) Validate the current construct.
     *
     * This method can be implemented by derived constructs in order to perform
     * validation logic. It is called on all constructs before synthesis.
     *
     * @experimental
     */
    protected validate(): string[];
    /**
     * (experimental) Denies the `DeleteSecret` action to all principals within the current account.
     *
     * @experimental
     */
    denyAccountRootDelete(): void;
    /**
     * (experimental) Provides an identifier for this secret for use in IAM policies.
     *
     * Typically, this is just the secret ARN.
     * However, secrets imported by name require a different format.
     *
     * @experimental
     */
    protected get arnForPolicies(): string;
}
/**
 * (experimental) Creates a new secret in AWS SecretsManager.
 *
 * @experimental
 */
export declare class Secret extends SecretBase {
    /**
     * @experimental
     */
    static fromSecretArn(scope: Construct, id: string, secretArn: string): ISecret;
    /**
     * (experimental) Imports a secret by secret name;
     *
     * the ARN of the Secret will be set to the secret name.
     * A secret with this name must exist in the same account & region.
     *
     * @experimental
     */
    static fromSecretName(scope: Construct, id: string, secretName: string): ISecret;
    /**
     * (experimental) Import an existing secret into the Stack.
     *
     * @param scope the scope of the import.
     * @param id the ID of the imported Secret in the construct tree.
     * @param attrs the attributes of the imported secret.
     * @experimental
     */
    static fromSecretAttributes(scope: Construct, id: string, attrs: SecretAttributes): ISecret;
    /**
     * (experimental) The customer-managed encryption key that is used to encrypt this secret, if any.
     *
     * When not specified, the default
     * KMS key for the account and region is being used.
     *
     * @experimental
     */
    readonly encryptionKey?: kms.IKey;
    /**
     * (experimental) The ARN of the secret in AWS Secrets Manager.
     *
     * @experimental
     */
    readonly secretArn: string;
    /**
     * (experimental) The name of the secret.
     *
     * @experimental
     */
    readonly secretName: string;
    /**
     * @experimental
     */
    protected readonly autoCreatePolicy = true;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: SecretProps);
    /**
     * (deprecated) Adds a target attachment to the secret.
     *
     * @returns an AttachedSecret
     * @deprecated use `attach()` instead
     */
    addTargetAttachment(id: string, options: AttachedSecretOptions): SecretTargetAttachment;
    /**
     * (experimental) Attach a target to this secret.
     *
     * @param target The target to attach.
     * @returns An attached secret
     * @experimental
     */
    attach(target: ISecretAttachmentTarget): ISecret;
}
/**
 * (experimental) A secret attachment target.
 *
 * @experimental
 */
export interface ISecretAttachmentTarget {
    /**
     * (experimental) Renders the target specifications.
     *
     * @experimental
     */
    asSecretAttachmentTarget(): SecretAttachmentTargetProps;
}
/**
 * (experimental) The type of service or database that's being associated with the secret.
 *
 * @experimental
 */
export declare enum AttachmentTargetType {
    /**
     * (deprecated) A database instance.
     *
     * @deprecated use RDS_DB_INSTANCE instead
     */
    INSTANCE = "AWS::RDS::DBInstance",
    /**
     * (deprecated) A database cluster.
     *
     * @deprecated use RDS_DB_CLUSTER instead
     */
    CLUSTER = "AWS::RDS::DBCluster",
    /**
     * AWS::RDS::DBInstance
     */
    RDS_DB_INSTANCE = "AWS::RDS::DBInstance",
    /**
     * AWS::RDS::DBCluster
     */
    RDS_DB_CLUSTER = "AWS::RDS::DBCluster",
    /**
     * (experimental) AWS::RDS::DBProxy.
     *
     * @experimental
     */
    RDS_DB_PROXY = "AWS::RDS::DBProxy",
    /**
     * (experimental) AWS::Redshift::Cluster.
     *
     * @experimental
     */
    REDSHIFT_CLUSTER = "AWS::Redshift::Cluster",
    /**
     * (experimental) AWS::DocDB::DBInstance.
     *
     * @experimental
     */
    DOCDB_DB_INSTANCE = "AWS::DocDB::DBInstance",
    /**
     * (experimental) AWS::DocDB::DBCluster.
     *
     * @experimental
     */
    DOCDB_DB_CLUSTER = "AWS::DocDB::DBCluster"
}
/**
 * (experimental) Attachment target specifications.
 *
 * @experimental
 */
export interface SecretAttachmentTargetProps {
    /**
     * (experimental) The id of the target to attach the secret to.
     *
     * @experimental
     */
    readonly targetId: string;
    /**
     * (experimental) The type of the target to attach the secret to.
     *
     * @experimental
     */
    readonly targetType: AttachmentTargetType;
}
/**
 * (deprecated) Options to add a secret attachment to a secret.
 *
 * @deprecated use `secret.attach()` instead
 */
export interface AttachedSecretOptions {
    /**
     * (deprecated) The target to attach the secret to.
     *
     * @deprecated
     */
    readonly target: ISecretAttachmentTarget;
}
/**
 * (experimental) Construction properties for an AttachedSecret.
 *
 * @experimental
 */
export interface SecretTargetAttachmentProps extends AttachedSecretOptions {
    /**
     * (experimental) The secret to attach to the target.
     *
     * @experimental
     */
    readonly secret: ISecret;
}
/**
 * @experimental
 */
export interface ISecretTargetAttachment extends ISecret {
    /**
     * (experimental) Same as `secretArn`.
     *
     * @experimental
     * @attribute true
     */
    readonly secretTargetAttachmentSecretArn: string;
}
/**
 * (experimental) An attached secret.
 *
 * @experimental
 */
export declare class SecretTargetAttachment extends SecretBase implements ISecretTargetAttachment {
    /**
     * @experimental
     */
    static fromSecretTargetAttachmentSecretArn(scope: Construct, id: string, secretTargetAttachmentSecretArn: string): ISecretTargetAttachment;
    /**
     * (experimental) The customer-managed encryption key that is used to encrypt this secret, if any.
     *
     * When not specified, the default
     * KMS key for the account and region is being used.
     *
     * @experimental
     */
    readonly encryptionKey?: kms.IKey;
    /**
     * (experimental) The ARN of the secret in AWS Secrets Manager.
     *
     * @experimental
     */
    readonly secretArn: string;
    /**
     * (experimental) The name of the secret.
     *
     * @experimental
     */
    readonly secretName: string;
    /**
     * (experimental) Same as `secretArn`.
     *
     * @experimental
     * @attribute true
     */
    readonly secretTargetAttachmentSecretArn: string;
    /**
     * @experimental
     */
    protected readonly autoCreatePolicy = true;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: SecretTargetAttachmentProps);
}
/**
 * (experimental) Configuration to generate secrets such as passwords automatically.
 *
 * @experimental
 */
export interface SecretStringGenerator {
    /**
     * (experimental) Specifies that the generated password shouldn't include uppercase letters.
     *
     * @default false
     * @experimental
     */
    readonly excludeUppercase?: boolean;
    /**
     * (experimental) Specifies whether the generated password must include at least one of every allowed character type.
     *
     * @default true
     * @experimental
     */
    readonly requireEachIncludedType?: boolean;
    /**
     * (experimental) Specifies that the generated password can include the space character.
     *
     * @default false
     * @experimental
     */
    readonly includeSpace?: boolean;
    /**
     * (experimental) A string that includes characters that shouldn't be included in the generated password.
     *
     * The string can be a minimum
     * of ``0`` and a maximum of ``4096`` characters long.
     *
     * @default no exclusions
     * @experimental
     */
    readonly excludeCharacters?: string;
    /**
     * (experimental) The desired length of the generated password.
     *
     * @default 32
     * @experimental
     */
    readonly passwordLength?: number;
    /**
     * (experimental) Specifies that the generated password shouldn't include punctuation characters.
     *
     * @default false
     * @experimental
     */
    readonly excludePunctuation?: boolean;
    /**
     * (experimental) Specifies that the generated password shouldn't include lowercase letters.
     *
     * @default false
     * @experimental
     */
    readonly excludeLowercase?: boolean;
    /**
     * (experimental) Specifies that the generated password shouldn't include digits.
     *
     * @default false
     * @experimental
     */
    readonly excludeNumbers?: boolean;
    /**
     * (experimental) A properly structured JSON string that the generated password can be added to.
     *
     * The ``generateStringKey`` is
     * combined with the generated random string and inserted into the JSON structure that's specified by this parameter.
     * The merged JSON string is returned as the completed SecretString of the secret. If you specify ``secretStringTemplate``
     * then ``generateStringKey`` must be also be specified.
     *
     * @experimental
     */
    readonly secretStringTemplate?: string;
    /**
     * (experimental) The JSON key name that's used to add the generated password to the JSON structure specified by the ``secretStringTemplate`` parameter.
     *
     * If you specify ``generateStringKey`` then ``secretStringTemplate``
     * must be also be specified.
     *
     * @experimental
     */
    readonly generateStringKey?: string;
}
export {};
