import * as ec2 from "../../aws-ec2";
import { Duration } from "../../core";
import { Construct } from 'constructs';
import { ISecret } from './secret';
import { Construct as CoreConstruct } from "../../core";
/**
 * (experimental) Options for a SecretRotationApplication.
 *
 * @experimental
 */
export interface SecretRotationApplicationOptions {
    /**
     * (experimental) Whether the rotation application uses the mutli user scheme.
     *
     * @default false
     * @experimental
     */
    readonly isMultiUser?: boolean;
}
/**
 * (experimental) A secret rotation serverless application.
 *
 * @experimental
 */
export declare class SecretRotationApplication {
    /**
     * (experimental) Conducts an AWS SecretsManager secret rotation for RDS MariaDB using the single user rotation scheme.
     *
     * @experimental
     */
    static readonly MARIADB_ROTATION_SINGLE_USER: SecretRotationApplication;
    /**
     * (experimental) Conducts an AWS SecretsManager secret rotation for RDS MariaDB using the multi user rotation scheme.
     *
     * @experimental
     */
    static readonly MARIADB_ROTATION_MULTI_USER: SecretRotationApplication;
    /**
     * (experimental) Conducts an AWS SecretsManager secret rotation for RDS MySQL using the single user rotation scheme.
     *
     * @experimental
     */
    static readonly MYSQL_ROTATION_SINGLE_USER: SecretRotationApplication;
    /**
     * (experimental) Conducts an AWS SecretsManager secret rotation for RDS MySQL using the multi user rotation scheme.
     *
     * @experimental
     */
    static readonly MYSQL_ROTATION_MULTI_USER: SecretRotationApplication;
    /**
     * (experimental) Conducts an AWS SecretsManager secret rotation for RDS Oracle using the single user rotation scheme.
     *
     * @experimental
     */
    static readonly ORACLE_ROTATION_SINGLE_USER: SecretRotationApplication;
    /**
     * (experimental) Conducts an AWS SecretsManager secret rotation for RDS Oracle using the multi user rotation scheme.
     *
     * @experimental
     */
    static readonly ORACLE_ROTATION_MULTI_USER: SecretRotationApplication;
    /**
     * (experimental) Conducts an AWS SecretsManager secret rotation for RDS PostgreSQL using the single user rotation scheme.
     *
     * @experimental
     */
    static readonly POSTGRES_ROTATION_SINGLE_USER: SecretRotationApplication;
    /**
     * (experimental) Conducts an AWS SecretsManager secret rotation for RDS PostgreSQL using the multi user rotation scheme.
     *
     * @experimental
     */
    static readonly POSTGRES_ROTATION_MULTI_USER: SecretRotationApplication;
    /**
     * (experimental) Conducts an AWS SecretsManager secret rotation for RDS SQL Server using the single user rotation scheme.
     *
     * @experimental
     */
    static readonly SQLSERVER_ROTATION_SINGLE_USER: SecretRotationApplication;
    /**
     * (experimental) Conducts an AWS SecretsManager secret rotation for RDS SQL Server using the multi user rotation scheme.
     *
     * @experimental
     */
    static readonly SQLSERVER_ROTATION_MULTI_USER: SecretRotationApplication;
    /**
     * (experimental) Conducts an AWS SecretsManager secret rotation for Amazon Redshift using the single user rotation scheme.
     *
     * @experimental
     */
    static readonly REDSHIFT_ROTATION_SINGLE_USER: SecretRotationApplication;
    /**
     * (experimental) Conducts an AWS SecretsManager secret rotation for Amazon Redshift using the multi user rotation scheme.
     *
     * @experimental
     */
    static readonly REDSHIFT_ROTATION_MULTI_USER: SecretRotationApplication;
    /**
     * (experimental) Conducts an AWS SecretsManager secret rotation for MongoDB using the single user rotation scheme.
     *
     * @experimental
     */
    static readonly MONGODB_ROTATION_SINGLE_USER: SecretRotationApplication;
    /**
     * (experimental) Conducts an AWS SecretsManager secret rotation for MongoDB using the multi user rotation scheme.
     *
     * @experimental
     */
    static readonly MONGODB_ROTATION_MULTI_USER: SecretRotationApplication;
    /**
     * (experimental) The application identifier of the rotation application.
     *
     * @experimental
     */
    readonly applicationId: string;
    /**
     * (experimental) The semantic version of the rotation application.
     *
     * @experimental
     */
    readonly semanticVersion: string;
    /**
     * (experimental) Whether the rotation application uses the mutli user scheme.
     *
     * @experimental
     */
    readonly isMultiUser?: boolean;
    /**
     * @experimental
     */
    constructor(applicationId: string, semanticVersion: string, options?: SecretRotationApplicationOptions);
}
/**
 * (experimental) Construction properties for a SecretRotation.
 *
 * @experimental
 */
export interface SecretRotationProps {
    /**
     * (experimental) The secret to rotate.
     *
     * It must be a JSON string with the following format:
     * ```
     * {
     *    "engine": <required: database engine>,
     *    "host": <required: instance host name>,
     *    "username": <required: username>,
     *    "password": <required: password>,
     *    "dbname": <optional: database name>,
     *    "port": <optional: if not specified, default port will be used>,
     *    "masterarn": <required for multi user rotation: the arn of the master secret which will be used to create users/change passwords>
     * }
     * ```
     *
     * This is typically the case for a secret referenced from an
     * AWS::SecretsManager::SecretTargetAttachment or an `ISecret` returned by the `attach()` method of `Secret`.
     *
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-secrettargetattachment.html
     * @experimental
     */
    readonly secret: ISecret;
    /**
     * (experimental) The master secret for a multi user rotation scheme.
     *
     * @default - single user rotation scheme
     * @experimental
     */
    readonly masterSecret?: ISecret;
    /**
     * (experimental) Specifies the number of days after the previous rotation before Secrets Manager triggers the next automatic rotation.
     *
     * @default Duration.days(30)
     * @experimental
     */
    readonly automaticallyAfter?: Duration;
    /**
     * (experimental) The serverless application for the rotation.
     *
     * @experimental
     */
    readonly application: SecretRotationApplication;
    /**
     * (experimental) The VPC where the Lambda rotation function will run.
     *
     * @experimental
     */
    readonly vpc: ec2.IVpc;
    /**
     * (experimental) The type of subnets in the VPC where the Lambda rotation function will run.
     *
     * @default - the Vpc default strategy if not specified.
     * @experimental
     */
    readonly vpcSubnets?: ec2.SubnetSelection;
    /**
     * (experimental) The target service or database.
     *
     * @experimental
     */
    readonly target: ec2.IConnectable;
    /**
     * (experimental) The security group for the Lambda rotation function.
     *
     * @default - a new security group is created
     * @experimental
     */
    readonly securityGroup?: ec2.ISecurityGroup;
    /**
     * (experimental) Characters which should not appear in the generated password.
     *
     * @default - no additional characters are explicitly excluded
     * @experimental
     */
    readonly excludeCharacters?: string;
}
/**
 * (experimental) Secret rotation for a service or database.
 *
 * @experimental
 */
export declare class SecretRotation extends CoreConstruct {
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: SecretRotationProps);
}
