import * as lambda from "../../aws-lambda";
import { Duration, Resource } from "../../core";
import { Construct } from 'constructs';
import { ISecret } from './secret';
/**
 * (experimental) Options to add a rotation schedule to a secret.
 *
 * @experimental
 */
export interface RotationScheduleOptions {
    /**
     * (experimental) The Lambda function that can rotate the secret.
     *
     * @experimental
     */
    readonly rotationLambda: lambda.IFunction;
    /**
     * (experimental) Specifies the number of days after the previous rotation before Secrets Manager triggers the next automatic rotation.
     *
     * @default Duration.days(30)
     * @experimental
     */
    readonly automaticallyAfter?: Duration;
}
/**
 * (experimental) Construction properties for a RotationSchedule.
 *
 * @experimental
 */
export interface RotationScheduleProps extends RotationScheduleOptions {
    /**
     * (experimental) The secret to rotate.
     *
     * @experimental
     */
    readonly secret: ISecret;
}
/**
 * (experimental) A rotation schedule.
 *
 * @experimental
 */
export declare class RotationSchedule extends Resource {
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: RotationScheduleProps);
}
