import * as cdk from "../../core";
/**
 * Properties for defining a `AWS::Serverless::Api`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
 * @external
 */
export interface CfnApiProps {
    /**
     * `AWS::Serverless::Api.StageName`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     * @external
     */
    readonly stageName: string;
    /**
     * `AWS::Serverless::Api.AccessLogSetting`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     * @external
     */
    readonly accessLogSetting?: CfnApi.AccessLogSettingProperty | cdk.IResolvable;
    /**
     * `AWS::Serverless::Api.Auth`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     * @external
     */
    readonly auth?: CfnApi.AuthProperty | cdk.IResolvable;
    /**
     * `AWS::Serverless::Api.BinaryMediaTypes`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     * @external
     */
    readonly binaryMediaTypes?: string[];
    /**
     * `AWS::Serverless::Api.CacheClusterEnabled`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     * @external
     */
    readonly cacheClusterEnabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::Serverless::Api.CacheClusterSize`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     * @external
     */
    readonly cacheClusterSize?: string;
    /**
     * `AWS::Serverless::Api.Cors`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     * @external
     */
    readonly cors?: CfnApi.CorsConfigurationProperty | string | cdk.IResolvable;
    /**
     * `AWS::Serverless::Api.DefinitionBody`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     * @external
     */
    readonly definitionBody?: any | cdk.IResolvable;
    /**
     * `AWS::Serverless::Api.DefinitionUri`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     * @external
     */
    readonly definitionUri?: CfnApi.S3LocationProperty | string | cdk.IResolvable;
    /**
     * `AWS::Serverless::Api.EndpointConfiguration`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     * @external
     */
    readonly endpointConfiguration?: string;
    /**
     * `AWS::Serverless::Api.MethodSettings`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     * @external
     */
    readonly methodSettings?: Array<any | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Serverless::Api.Name`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     * @external
     */
    readonly name?: string;
    /**
     * `AWS::Serverless::Api.OpenApiVersion`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     * @external
     */
    readonly openApiVersion?: string;
    /**
     * `AWS::Serverless::Api.TracingEnabled`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     * @external
     */
    readonly tracingEnabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::Serverless::Api.Variables`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     * @external
     */
    readonly variables?: {
        [key: string]: (string);
    } | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Serverless::Api`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
 * @external
 * @cloudformationResource AWS::Serverless::Api
 */
export declare class CfnApi extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Serverless::Api";
    /**
     * The `Transform` a template must use in order to use this resource.
     *
     * @external
     */
    static readonly REQUIRED_TRANSFORM = "AWS::Serverless-2016-10-31";
    /**
     * `AWS::Serverless::Api.StageName`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     * @external
     */
    stageName: string;
    /**
     * `AWS::Serverless::Api.AccessLogSetting`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     * @external
     */
    accessLogSetting: CfnApi.AccessLogSettingProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::Api.Auth`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     * @external
     */
    auth: CfnApi.AuthProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::Api.BinaryMediaTypes`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     * @external
     */
    binaryMediaTypes: string[] | undefined;
    /**
     * `AWS::Serverless::Api.CacheClusterEnabled`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     * @external
     */
    cacheClusterEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::Api.CacheClusterSize`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     * @external
     */
    cacheClusterSize: string | undefined;
    /**
     * `AWS::Serverless::Api.Cors`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     * @external
     */
    cors: CfnApi.CorsConfigurationProperty | string | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::Api.DefinitionBody`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     * @external
     */
    definitionBody: any | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::Api.DefinitionUri`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     * @external
     */
    definitionUri: CfnApi.S3LocationProperty | string | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::Api.EndpointConfiguration`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     * @external
     */
    endpointConfiguration: string | undefined;
    /**
     * `AWS::Serverless::Api.MethodSettings`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     * @external
     */
    methodSettings: Array<any | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::Api.Name`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     * @external
     */
    name: string | undefined;
    /**
     * `AWS::Serverless::Api.OpenApiVersion`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     * @external
     */
    openApiVersion: string | undefined;
    /**
     * `AWS::Serverless::Api.TracingEnabled`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     * @external
     */
    tracingEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::Api.Variables`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     * @external
     */
    variables: {
        [key: string]: (string);
    } | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Serverless::Api`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnApiProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Serverless::Api`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
 * @external
 * @cloudformationResource AWS::Serverless::Api
 */
export declare namespace CfnApi {
    /**
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-accesslogsetting.html
     * @external
     */
    interface AccessLogSettingProperty {
        /**
         * `CfnApi.AccessLogSettingProperty.DestinationArn`.
         *
         * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-accesslogsetting.html#cfn-apigateway-stage-accesslogsetting-destinationarn
         * @external
         */
        readonly destinationArn?: string;
        /**
         * `CfnApi.AccessLogSettingProperty.Format`.
         *
         * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-accesslogsetting.html#cfn-apigateway-stage-accesslogsetting-format
         * @external
         */
        readonly format?: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Api`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
 * @external
 * @cloudformationResource AWS::Serverless::Api
 */
export declare namespace CfnApi {
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api-auth-object
     * @external
     */
    interface AuthProperty {
        /**
         * `CfnApi.AuthProperty.Authorizers`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api-auth-object
         * @external
         */
        readonly authorizers?: any | cdk.IResolvable;
        /**
         * `CfnApi.AuthProperty.DefaultAuthorizer`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api-auth-object
         * @external
         */
        readonly defaultAuthorizer?: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Api`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
 * @external
 * @cloudformationResource AWS::Serverless::Api
 */
export declare namespace CfnApi {
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#cors-configuration
     * @external
     */
    interface CorsConfigurationProperty {
        /**
         * `CfnApi.CorsConfigurationProperty.AllowCredentials`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#cors-configuration
         * @external
         */
        readonly allowCredentials?: boolean | cdk.IResolvable;
        /**
         * `CfnApi.CorsConfigurationProperty.AllowHeaders`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#cors-configuration
         * @external
         */
        readonly allowHeaders?: string;
        /**
         * `CfnApi.CorsConfigurationProperty.AllowMethods`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#cors-configuration
         * @external
         */
        readonly allowMethods?: string;
        /**
         * `CfnApi.CorsConfigurationProperty.AllowOrigin`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#cors-configuration
         * @external
         */
        readonly allowOrigin: string;
        /**
         * `CfnApi.CorsConfigurationProperty.MaxAge`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#cors-configuration
         * @external
         */
        readonly maxAge?: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Api`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
 * @external
 * @cloudformationResource AWS::Serverless::Api
 */
export declare namespace CfnApi {
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#s3-location-object
     * @external
     */
    interface S3LocationProperty {
        /**
         * `CfnApi.S3LocationProperty.Bucket`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
         * @external
         */
        readonly bucket: string;
        /**
         * `CfnApi.S3LocationProperty.Key`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
         * @external
         */
        readonly key: string;
        /**
         * `CfnApi.S3LocationProperty.Version`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
         * @external
         */
        readonly version: number;
    }
}
/**
 * Properties for defining a `AWS::Serverless::Application`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
 * @external
 */
export interface CfnApplicationProps {
    /**
     * `AWS::Serverless::Application.Location`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
     * @external
     */
    readonly location: CfnApplication.ApplicationLocationProperty | string | cdk.IResolvable;
    /**
     * `AWS::Serverless::Application.NotificationArns`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
     * @external
     */
    readonly notificationArns?: string[];
    /**
     * `AWS::Serverless::Application.Parameters`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
     * @external
     */
    readonly parameters?: {
        [key: string]: (string);
    } | cdk.IResolvable;
    /**
     * `AWS::Serverless::Application.Tags`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
     * @external
     */
    readonly tags?: {
        [key: string]: (string);
    };
    /**
     * `AWS::Serverless::Application.TimeoutInMinutes`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
     * @external
     */
    readonly timeoutInMinutes?: number;
}
/**
 * A CloudFormation `AWS::Serverless::Application`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
 * @external
 * @cloudformationResource AWS::Serverless::Application
 */
export declare class CfnApplication extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Serverless::Application";
    /**
     * The `Transform` a template must use in order to use this resource.
     *
     * @external
     */
    static readonly REQUIRED_TRANSFORM = "AWS::Serverless-2016-10-31";
    /**
     * `AWS::Serverless::Application.Location`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
     * @external
     */
    location: CfnApplication.ApplicationLocationProperty | string | cdk.IResolvable;
    /**
     * `AWS::Serverless::Application.NotificationArns`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
     * @external
     */
    notificationArns: string[] | undefined;
    /**
     * `AWS::Serverless::Application.Parameters`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
     * @external
     */
    parameters: {
        [key: string]: (string);
    } | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::Application.Tags`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::Serverless::Application.TimeoutInMinutes`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
     * @external
     */
    timeoutInMinutes: number | undefined;
    /**
     * Create a new `AWS::Serverless::Application`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnApplicationProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Serverless::Application`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
 * @external
 * @cloudformationResource AWS::Serverless::Application
 */
export declare namespace CfnApplication {
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
     * @external
     */
    interface ApplicationLocationProperty {
        /**
         * `CfnApplication.ApplicationLocationProperty.ApplicationId`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
         * @external
         */
        readonly applicationId: string;
        /**
         * `CfnApplication.ApplicationLocationProperty.SemanticVersion`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
         * @external
         */
        readonly semanticVersion: string;
    }
}
/**
 * Properties for defining a `AWS::Serverless::Function`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 * @external
 */
export interface CfnFunctionProps {
    /**
     * `AWS::Serverless::Function.CodeUri`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     * @external
     */
    readonly codeUri: CfnFunction.S3LocationProperty | string | cdk.IResolvable;
    /**
     * `AWS::Serverless::Function.Handler`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     * @external
     */
    readonly handler: string;
    /**
     * `AWS::Serverless::Function.Runtime`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     * @external
     */
    readonly runtime: string;
    /**
     * `AWS::Serverless::Function.AutoPublishAlias`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     * @external
     */
    readonly autoPublishAlias?: string;
    /**
     * `AWS::Serverless::Function.DeadLetterQueue`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     * @external
     */
    readonly deadLetterQueue?: CfnFunction.DeadLetterQueueProperty | cdk.IResolvable;
    /**
     * `AWS::Serverless::Function.DeploymentPreference`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#deploymentpreference-object
     * @external
     */
    readonly deploymentPreference?: CfnFunction.DeploymentPreferenceProperty | cdk.IResolvable;
    /**
     * `AWS::Serverless::Function.Description`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::Serverless::Function.Environment`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     * @external
     */
    readonly environment?: CfnFunction.FunctionEnvironmentProperty | cdk.IResolvable;
    /**
     * `AWS::Serverless::Function.Events`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     * @external
     */
    readonly events?: {
        [key: string]: (CfnFunction.EventSourceProperty | cdk.IResolvable);
    } | cdk.IResolvable;
    /**
     * `AWS::Serverless::Function.FileSystemConfigs`.
     *
     * @see https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-function.html
     * @external
     */
    readonly fileSystemConfigs?: Array<CfnFunction.FileSystemConfigProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Serverless::Function.FunctionName`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     * @external
     */
    readonly functionName?: string;
    /**
     * `AWS::Serverless::Function.KmsKeyArn`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     * @external
     */
    readonly kmsKeyArn?: string;
    /**
     * `AWS::Serverless::Function.Layers`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     * @external
     */
    readonly layers?: string[];
    /**
     * `AWS::Serverless::Function.MemorySize`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     * @external
     */
    readonly memorySize?: number;
    /**
     * `AWS::Serverless::Function.PermissionsBoundary`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     * @external
     */
    readonly permissionsBoundary?: string;
    /**
     * `AWS::Serverless::Function.Policies`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     * @external
     */
    readonly policies?: Array<CfnFunction.IAMPolicyDocumentProperty | CfnFunction.SAMPolicyTemplateProperty | string | cdk.IResolvable> | CfnFunction.IAMPolicyDocumentProperty | string | cdk.IResolvable;
    /**
     * `AWS::Serverless::Function.ReservedConcurrentExecutions`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     * @external
     */
    readonly reservedConcurrentExecutions?: number;
    /**
     * `AWS::Serverless::Function.Role`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     * @external
     */
    readonly role?: string;
    /**
     * `AWS::Serverless::Function.Tags`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     * @external
     */
    readonly tags?: {
        [key: string]: (string);
    };
    /**
     * `AWS::Serverless::Function.Timeout`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     * @external
     */
    readonly timeout?: number;
    /**
     * `AWS::Serverless::Function.Tracing`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     * @external
     */
    readonly tracing?: string;
    /**
     * `AWS::Serverless::Function.VpcConfig`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     * @external
     */
    readonly vpcConfig?: CfnFunction.VpcConfigProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 * @external
 * @cloudformationResource AWS::Serverless::Function
 */
export declare class CfnFunction extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Serverless::Function";
    /**
     * The `Transform` a template must use in order to use this resource.
     *
     * @external
     */
    static readonly REQUIRED_TRANSFORM = "AWS::Serverless-2016-10-31";
    /**
     * `AWS::Serverless::Function.CodeUri`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     * @external
     */
    codeUri: CfnFunction.S3LocationProperty | string | cdk.IResolvable;
    /**
     * `AWS::Serverless::Function.Handler`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     * @external
     */
    handler: string;
    /**
     * `AWS::Serverless::Function.Runtime`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     * @external
     */
    runtime: string;
    /**
     * `AWS::Serverless::Function.AutoPublishAlias`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     * @external
     */
    autoPublishAlias: string | undefined;
    /**
     * `AWS::Serverless::Function.DeadLetterQueue`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     * @external
     */
    deadLetterQueue: CfnFunction.DeadLetterQueueProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::Function.DeploymentPreference`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#deploymentpreference-object
     * @external
     */
    deploymentPreference: CfnFunction.DeploymentPreferenceProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::Function.Description`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::Serverless::Function.Environment`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     * @external
     */
    environment: CfnFunction.FunctionEnvironmentProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::Function.Events`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     * @external
     */
    events: {
        [key: string]: (CfnFunction.EventSourceProperty | cdk.IResolvable);
    } | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::Function.FileSystemConfigs`.
     *
     * @see https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-function.html
     * @external
     */
    fileSystemConfigs: Array<CfnFunction.FileSystemConfigProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::Function.FunctionName`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     * @external
     */
    functionName: string | undefined;
    /**
     * `AWS::Serverless::Function.KmsKeyArn`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     * @external
     */
    kmsKeyArn: string | undefined;
    /**
     * `AWS::Serverless::Function.Layers`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     * @external
     */
    layers: string[] | undefined;
    /**
     * `AWS::Serverless::Function.MemorySize`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     * @external
     */
    memorySize: number | undefined;
    /**
     * `AWS::Serverless::Function.PermissionsBoundary`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     * @external
     */
    permissionsBoundary: string | undefined;
    /**
     * `AWS::Serverless::Function.Policies`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     * @external
     */
    policies: Array<CfnFunction.IAMPolicyDocumentProperty | CfnFunction.SAMPolicyTemplateProperty | string | cdk.IResolvable> | CfnFunction.IAMPolicyDocumentProperty | string | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::Function.ReservedConcurrentExecutions`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     * @external
     */
    reservedConcurrentExecutions: number | undefined;
    /**
     * `AWS::Serverless::Function.Role`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     * @external
     */
    role: string | undefined;
    /**
     * `AWS::Serverless::Function.Tags`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::Serverless::Function.Timeout`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     * @external
     */
    timeout: number | undefined;
    /**
     * `AWS::Serverless::Function.Tracing`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     * @external
     */
    tracing: string | undefined;
    /**
     * `AWS::Serverless::Function.VpcConfig`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     * @external
     */
    vpcConfig: CfnFunction.VpcConfigProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Serverless::Function`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnFunctionProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 * @external
 * @cloudformationResource AWS::Serverless::Function
 */
export declare namespace CfnFunction {
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#alexaskill
     * @external
     */
    interface AlexaSkillEventProperty {
        /**
         * `CfnFunction.AlexaSkillEventProperty.Variables`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#alexaskill
         * @external
         */
        readonly variables?: {
            [key: string]: (string);
        } | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 * @external
 * @cloudformationResource AWS::Serverless::Function
 */
export declare namespace CfnFunction {
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api
     * @external
     */
    interface ApiEventProperty {
        /**
         * `CfnFunction.ApiEventProperty.Method`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api
         * @external
         */
        readonly method: string;
        /**
         * `CfnFunction.ApiEventProperty.Path`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api
         * @external
         */
        readonly path: string;
        /**
         * `CfnFunction.ApiEventProperty.RestApiId`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api
         * @external
         */
        readonly restApiId?: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 * @external
 * @cloudformationResource AWS::Serverless::Function
 */
export declare namespace CfnFunction {
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     * @external
     */
    interface BucketSAMPTProperty {
        /**
         * `CfnFunction.BucketSAMPTProperty.BucketName`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         * @external
         */
        readonly bucketName: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 * @external
 * @cloudformationResource AWS::Serverless::Function
 */
export declare namespace CfnFunction {
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#cloudwatchevent
     * @external
     */
    interface CloudWatchEventEventProperty {
        /**
         * `CfnFunction.CloudWatchEventEventProperty.Input`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#cloudwatchevent
         * @external
         */
        readonly input?: string;
        /**
         * `CfnFunction.CloudWatchEventEventProperty.InputPath`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#cloudwatchevent
         * @external
         */
        readonly inputPath?: string;
        /**
         * `CfnFunction.CloudWatchEventEventProperty.Pattern`.
         *
         * @see http://docs.aws.amazon.com/AmazonCloudWatch/latest/events/CloudWatchEventsandEventPatterns.html
         * @external
         */
        readonly pattern: any | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 * @external
 * @cloudformationResource AWS::Serverless::Function
 */
export declare namespace CfnFunction {
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#cloudwatchevent
     * @external
     */
    interface CloudWatchLogsEventProperty {
        /**
         * `CfnFunction.CloudWatchLogsEventProperty.FilterPattern`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#cloudwatchlogs
         * @external
         */
        readonly filterPattern: string;
        /**
         * `CfnFunction.CloudWatchLogsEventProperty.LogGroupName`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#cloudwatchlogs
         * @external
         */
        readonly logGroupName: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 * @external
 * @cloudformationResource AWS::Serverless::Function
 */
export declare namespace CfnFunction {
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     * @external
     */
    interface CollectionSAMPTProperty {
        /**
         * `CfnFunction.CollectionSAMPTProperty.CollectionId`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         * @external
         */
        readonly collectionId: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 * @external
 * @cloudformationResource AWS::Serverless::Function
 */
export declare namespace CfnFunction {
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#deadletterqueue-object
     * @external
     */
    interface DeadLetterQueueProperty {
        /**
         * `CfnFunction.DeadLetterQueueProperty.TargetArn`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
         * @external
         */
        readonly targetArn: string;
        /**
         * `CfnFunction.DeadLetterQueueProperty.Type`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
         * @external
         */
        readonly type: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 * @external
 * @cloudformationResource AWS::Serverless::Function
 */
export declare namespace CfnFunction {
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/safe_lambda_deployments.rst
     * @external
     */
    interface DeploymentPreferenceProperty {
        /**
         * `CfnFunction.DeploymentPreferenceProperty.Enabled`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#deploymentpreference-object
         * @external
         */
        readonly enabled: boolean | cdk.IResolvable;
        /**
         * `CfnFunction.DeploymentPreferenceProperty.Type`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#deploymentpreference-object
         * @external
         */
        readonly type: string;
        /**
         * `CfnFunction.DeploymentPreferenceProperty.Alarms`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#deploymentpreference-object
         * @external
         */
        readonly alarms?: string[];
        /**
         * `CfnFunction.DeploymentPreferenceProperty.Hooks`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#deploymentpreference-object
         * @external
         */
        readonly hooks?: string[];
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 * @external
 * @cloudformationResource AWS::Serverless::Function
 */
export declare namespace CfnFunction {
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#destination-config-object
     * @external
     */
    interface DestinationConfigProperty {
        /**
         * `CfnFunction.DestinationConfigProperty.OnFailure`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#destination-config-object
         * @external
         */
        readonly onFailure: CfnFunction.OnFailureProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 * @external
 * @cloudformationResource AWS::Serverless::Function
 */
export declare namespace CfnFunction {
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     * @external
     */
    interface DomainSAMPTProperty {
        /**
         * `CfnFunction.DomainSAMPTProperty.DomainName`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         * @external
         */
        readonly domainName: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 * @external
 * @cloudformationResource AWS::Serverless::Function
 */
export declare namespace CfnFunction {
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#dynamodb
     * @external
     */
    interface DynamoDBEventProperty {
        /**
         * `CfnFunction.DynamoDBEventProperty.BatchSize`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#dynamodb
         * @external
         */
        readonly batchSize?: number;
        /**
         * `CfnFunction.DynamoDBEventProperty.BisectBatchOnFunctionError`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#dynamodb
         * @external
         */
        readonly bisectBatchOnFunctionError?: boolean | cdk.IResolvable;
        /**
         * `CfnFunction.DynamoDBEventProperty.DestinationConfig`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#dynamodb
         * @external
         */
        readonly destinationConfig?: CfnFunction.DestinationConfigProperty | cdk.IResolvable;
        /**
         * `CfnFunction.DynamoDBEventProperty.Enabled`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#dynamodb
         * @external
         */
        readonly enabled?: boolean | cdk.IResolvable;
        /**
         * `CfnFunction.DynamoDBEventProperty.MaximumBatchingWindowInSeconds`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#dynamodb
         * @external
         */
        readonly maximumBatchingWindowInSeconds?: number;
        /**
         * `CfnFunction.DynamoDBEventProperty.MaximumRecordAgeInSeconds`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#dynamodb
         * @external
         */
        readonly maximumRecordAgeInSeconds?: number;
        /**
         * `CfnFunction.DynamoDBEventProperty.MaximumRetryAttempts`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#dynamodb
         * @external
         */
        readonly maximumRetryAttempts?: number;
        /**
         * `CfnFunction.DynamoDBEventProperty.ParallelizationFactor`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#dynamodb
         * @external
         */
        readonly parallelizationFactor?: number;
        /**
         * `CfnFunction.DynamoDBEventProperty.StartingPosition`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#dynamodb
         * @external
         */
        readonly startingPosition: string;
        /**
         * `CfnFunction.DynamoDBEventProperty.Stream`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#dynamodb
         * @external
         */
        readonly stream: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 * @external
 * @cloudformationResource AWS::Serverless::Function
 */
export declare namespace CfnFunction {
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     * @external
     */
    interface EmptySAMPTProperty {
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 * @external
 * @cloudformationResource AWS::Serverless::Function
 */
export declare namespace CfnFunction {
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#eventbridgerule
     * @external
     */
    interface EventBridgeRuleEventProperty {
        /**
         * `CfnFunction.EventBridgeRuleEventProperty.EventBusName`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#eventbridgerule
         * @external
         */
        readonly eventBusName?: string;
        /**
         * `CfnFunction.EventBridgeRuleEventProperty.Input`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#eventbridgerule
         * @external
         */
        readonly input?: string;
        /**
         * `CfnFunction.EventBridgeRuleEventProperty.InputPath`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#eventbridgerule
         * @external
         */
        readonly inputPath?: string;
        /**
         * `CfnFunction.EventBridgeRuleEventProperty.Pattern`.
         *
         * @see https://docs.aws.amazon.com/eventbridge/latest/userguide/filtering-examples-structure.html
         * @external
         */
        readonly pattern: any | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 * @external
 * @cloudformationResource AWS::Serverless::Function
 */
export declare namespace CfnFunction {
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#event-source-object
     * @external
     */
    interface EventSourceProperty {
        /**
         * `CfnFunction.EventSourceProperty.Properties`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#event-source-types
         * @external
         */
        readonly properties: CfnFunction.S3EventProperty | CfnFunction.SNSEventProperty | CfnFunction.SQSEventProperty | CfnFunction.KinesisEventProperty | CfnFunction.DynamoDBEventProperty | CfnFunction.ApiEventProperty | CfnFunction.ScheduleEventProperty | CfnFunction.CloudWatchEventEventProperty | CfnFunction.CloudWatchLogsEventProperty | CfnFunction.IoTRuleEventProperty | CfnFunction.AlexaSkillEventProperty | CfnFunction.EventBridgeRuleEventProperty | cdk.IResolvable;
        /**
         * `CfnFunction.EventSourceProperty.Type`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#event-source-object
         * @external
         */
        readonly type: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 * @external
 * @cloudformationResource AWS::Serverless::Function
 */
export declare namespace CfnFunction {
    /**
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-filesystemconfig.html#cfn-lambda-function-filesystemconfig-localmountpath
     * @external
     */
    interface FileSystemConfigProperty {
        /**
         * `CfnFunction.FileSystemConfigProperty.Arn`.
         *
         * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-filesystemconfig.html#cfn-lambda-function-filesystemconfig-localmountpath
         * @external
         */
        readonly arn?: string;
        /**
         * `CfnFunction.FileSystemConfigProperty.LocalMountPath`.
         *
         * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-filesystemconfig.html#cfn-lambda-function-filesystemconfig-localmountpath
         * @external
         */
        readonly localMountPath?: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 * @external
 * @cloudformationResource AWS::Serverless::Function
 */
export declare namespace CfnFunction {
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#environment-object
     * @external
     */
    interface FunctionEnvironmentProperty {
        /**
         * `CfnFunction.FunctionEnvironmentProperty.Variables`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#environment-object
         * @external
         */
        readonly variables: {
            [key: string]: (string);
        } | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 * @external
 * @cloudformationResource AWS::Serverless::Function
 */
export declare namespace CfnFunction {
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     * @external
     */
    interface FunctionSAMPTProperty {
        /**
         * `CfnFunction.FunctionSAMPTProperty.FunctionName`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         * @external
         */
        readonly functionName: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 * @external
 * @cloudformationResource AWS::Serverless::Function
 */
export declare namespace CfnFunction {
    /**
     * @see http://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html
     * @external
     */
    interface IAMPolicyDocumentProperty {
        /**
         * `CfnFunction.IAMPolicyDocumentProperty.Statement`.
         *
         * @see http://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html
         * @external
         */
        readonly statement: any | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 * @external
 * @cloudformationResource AWS::Serverless::Function
 */
export declare namespace CfnFunction {
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     * @external
     */
    interface IdentitySAMPTProperty {
        /**
         * `CfnFunction.IdentitySAMPTProperty.IdentityName`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         * @external
         */
        readonly identityName: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 * @external
 * @cloudformationResource AWS::Serverless::Function
 */
export declare namespace CfnFunction {
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#iotrule
     * @external
     */
    interface IoTRuleEventProperty {
        /**
         * `CfnFunction.IoTRuleEventProperty.AwsIotSqlVersion`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#iotrule
         * @external
         */
        readonly awsIotSqlVersion?: string;
        /**
         * `CfnFunction.IoTRuleEventProperty.Sql`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#iotrule
         * @external
         */
        readonly sql: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 * @external
 * @cloudformationResource AWS::Serverless::Function
 */
export declare namespace CfnFunction {
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     * @external
     */
    interface KeySAMPTProperty {
        /**
         * `CfnFunction.KeySAMPTProperty.KeyId`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         * @external
         */
        readonly keyId: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 * @external
 * @cloudformationResource AWS::Serverless::Function
 */
export declare namespace CfnFunction {
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#kinesis
     * @external
     */
    interface KinesisEventProperty {
        /**
         * `CfnFunction.KinesisEventProperty.BatchSize`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#kinesis
         * @external
         */
        readonly batchSize?: number;
        /**
         * `CfnFunction.KinesisEventProperty.Enabled`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#kinesis
         * @external
         */
        readonly enabled?: boolean | cdk.IResolvable;
        /**
         * `CfnFunction.KinesisEventProperty.StartingPosition`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#kinesis
         * @external
         */
        readonly startingPosition: string;
        /**
         * `CfnFunction.KinesisEventProperty.Stream`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#kinesis
         * @external
         */
        readonly stream: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 * @external
 * @cloudformationResource AWS::Serverless::Function
 */
export declare namespace CfnFunction {
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     * @external
     */
    interface LogGroupSAMPTProperty {
        /**
         * `CfnFunction.LogGroupSAMPTProperty.LogGroupName`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         * @external
         */
        readonly logGroupName: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 * @external
 * @cloudformationResource AWS::Serverless::Function
 */
export declare namespace CfnFunction {
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#destination-config-object
     * @external
     */
    interface OnFailureProperty {
        /**
         * `CfnFunction.OnFailureProperty.Destination`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#destination-config-object
         * @external
         */
        readonly destination: string;
        /**
         * `CfnFunction.OnFailureProperty.Type`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#destination-config-object
         * @external
         */
        readonly type?: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 * @external
 * @cloudformationResource AWS::Serverless::Function
 */
export declare namespace CfnFunction {
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     * @external
     */
    interface QueueSAMPTProperty {
        /**
         * `CfnFunction.QueueSAMPTProperty.QueueName`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         * @external
         */
        readonly queueName: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 * @external
 * @cloudformationResource AWS::Serverless::Function
 */
export declare namespace CfnFunction {
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#s3
     * @external
     */
    interface S3EventProperty {
        /**
         * `CfnFunction.S3EventProperty.Bucket`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#s3
         * @external
         */
        readonly bucket: string;
        /**
         * `CfnFunction.S3EventProperty.Events`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#s3
         * @external
         */
        readonly events: string[] | string | cdk.IResolvable;
        /**
         * `CfnFunction.S3EventProperty.Filter`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#s3
         * @external
         */
        readonly filter?: CfnFunction.S3NotificationFilterProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 * @external
 * @cloudformationResource AWS::Serverless::Function
 */
export declare namespace CfnFunction {
    /**
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html
     * @external
     */
    interface S3KeyFilterProperty {
        /**
         * `CfnFunction.S3KeyFilterProperty.Rules`.
         *
         * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html
         * @external
         */
        readonly rules: Array<CfnFunction.S3KeyFilterRuleProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 * @external
 * @cloudformationResource AWS::Serverless::Function
 */
export declare namespace CfnFunction {
    /**
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html
     * @external
     */
    interface S3KeyFilterRuleProperty {
        /**
         * `CfnFunction.S3KeyFilterRuleProperty.Name`.
         *
         * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html
         * @external
         */
        readonly name: string;
        /**
         * `CfnFunction.S3KeyFilterRuleProperty.Value`.
         *
         * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html
         * @external
         */
        readonly value: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 * @external
 * @cloudformationResource AWS::Serverless::Function
 */
export declare namespace CfnFunction {
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#s3-location-object
     * @external
     */
    interface S3LocationProperty {
        /**
         * `CfnFunction.S3LocationProperty.Bucket`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
         * @external
         */
        readonly bucket: string;
        /**
         * `CfnFunction.S3LocationProperty.Key`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
         * @external
         */
        readonly key: string;
        /**
         * `CfnFunction.S3LocationProperty.Version`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
         * @external
         */
        readonly version?: number;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 * @external
 * @cloudformationResource AWS::Serverless::Function
 */
export declare namespace CfnFunction {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html
     * @external
     */
    interface S3NotificationFilterProperty {
        /**
         * `CfnFunction.S3NotificationFilterProperty.S3Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html
         * @external
         */
        readonly s3Key: CfnFunction.S3KeyFilterProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 * @external
 * @cloudformationResource AWS::Serverless::Function
 */
export declare namespace CfnFunction {
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     * @external
     */
    interface SAMPolicyTemplateProperty {
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.AMIDescribePolicy`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         * @external
         */
        readonly amiDescribePolicy?: CfnFunction.EmptySAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.CloudFormationDescribeStacksPolicy`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         * @external
         */
        readonly cloudFormationDescribeStacksPolicy?: CfnFunction.EmptySAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.CloudWatchPutMetricPolicy`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         * @external
         */
        readonly cloudWatchPutMetricPolicy?: CfnFunction.EmptySAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.DynamoDBCrudPolicy`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         * @external
         */
        readonly dynamoDbCrudPolicy?: CfnFunction.TableSAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.DynamoDBReadPolicy`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         * @external
         */
        readonly dynamoDbReadPolicy?: CfnFunction.TableSAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.DynamoDBStreamReadPolicy`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         * @external
         */
        readonly dynamoDbStreamReadPolicy?: CfnFunction.TableStreamSAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.EC2DescribePolicy`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         * @external
         */
        readonly ec2DescribePolicy?: CfnFunction.EmptySAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.ElasticsearchHttpPostPolicy`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         * @external
         */
        readonly elasticsearchHttpPostPolicy?: CfnFunction.DomainSAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.FilterLogEventsPolicy`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         * @external
         */
        readonly filterLogEventsPolicy?: CfnFunction.LogGroupSAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.KMSDecryptPolicy`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         * @external
         */
        readonly kmsDecryptPolicy?: CfnFunction.KeySAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.KinesisCrudPolicy`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         * @external
         */
        readonly kinesisCrudPolicy?: CfnFunction.StreamSAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.KinesisStreamReadPolicy`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         * @external
         */
        readonly kinesisStreamReadPolicy?: CfnFunction.StreamSAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.LambdaInvokePolicy`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         * @external
         */
        readonly lambdaInvokePolicy?: CfnFunction.FunctionSAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.RekognitionDetectOnlyPolicy`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         * @external
         */
        readonly rekognitionDetectOnlyPolicy?: CfnFunction.EmptySAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.RekognitionLabelsPolicy`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         * @external
         */
        readonly rekognitionLabelsPolicy?: CfnFunction.EmptySAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.RekognitionNoDataAccessPolicy`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         * @external
         */
        readonly rekognitionNoDataAccessPolicy?: CfnFunction.CollectionSAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.RekognitionReadPolicy`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         * @external
         */
        readonly rekognitionReadPolicy?: CfnFunction.CollectionSAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.RekognitionWriteOnlyAccessPolicy`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         * @external
         */
        readonly rekognitionWriteOnlyAccessPolicy?: CfnFunction.CollectionSAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.S3CrudPolicy`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         * @external
         */
        readonly s3CrudPolicy?: CfnFunction.BucketSAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.S3ReadPolicy`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         * @external
         */
        readonly s3ReadPolicy?: CfnFunction.BucketSAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.SESBulkTemplatedCrudPolicy`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         * @external
         */
        readonly sesBulkTemplatedCrudPolicy?: CfnFunction.IdentitySAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.SESCrudPolicy`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         * @external
         */
        readonly sesCrudPolicy?: CfnFunction.IdentitySAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.SESEmailTemplateCrudPolicy`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         * @external
         */
        readonly sesEmailTemplateCrudPolicy?: CfnFunction.EmptySAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.SESSendBouncePolicy`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         * @external
         */
        readonly sesSendBouncePolicy?: CfnFunction.IdentitySAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.SNSCrudPolicy`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         * @external
         */
        readonly snsCrudPolicy?: CfnFunction.TopicSAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.SNSPublishMessagePolicy`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         * @external
         */
        readonly snsPublishMessagePolicy?: CfnFunction.TopicSAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.SQSPollerPolicy`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         * @external
         */
        readonly sqsPollerPolicy?: CfnFunction.QueueSAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.SQSSendMessagePolicy`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         * @external
         */
        readonly sqsSendMessagePolicy?: CfnFunction.QueueSAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.StepFunctionsExecutionPolicy`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         * @external
         */
        readonly stepFunctionsExecutionPolicy?: CfnFunction.StateMachineSAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.VPCAccessPolicy`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         * @external
         */
        readonly vpcAccessPolicy?: CfnFunction.EmptySAMPTProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 * @external
 * @cloudformationResource AWS::Serverless::Function
 */
export declare namespace CfnFunction {
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#sns
     * @external
     */
    interface SNSEventProperty {
        /**
         * `CfnFunction.SNSEventProperty.Topic`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#sns
         * @external
         */
        readonly topic: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 * @external
 * @cloudformationResource AWS::Serverless::Function
 */
export declare namespace CfnFunction {
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#sqs
     * @external
     */
    interface SQSEventProperty {
        /**
         * `CfnFunction.SQSEventProperty.BatchSize`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#sqs
         * @external
         */
        readonly batchSize?: number;
        /**
         * `CfnFunction.SQSEventProperty.Enabled`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#sqs
         * @external
         */
        readonly enabled?: boolean | cdk.IResolvable;
        /**
         * `CfnFunction.SQSEventProperty.Queue`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#sqs
         * @external
         */
        readonly queue: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 * @external
 * @cloudformationResource AWS::Serverless::Function
 */
export declare namespace CfnFunction {
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#schedule
     * @external
     */
    interface ScheduleEventProperty {
        /**
         * `CfnFunction.ScheduleEventProperty.Input`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#schedule
         * @external
         */
        readonly input?: string;
        /**
         * `CfnFunction.ScheduleEventProperty.Schedule`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#schedule
         * @external
         */
        readonly schedule: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 * @external
 * @cloudformationResource AWS::Serverless::Function
 */
export declare namespace CfnFunction {
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     * @external
     */
    interface StateMachineSAMPTProperty {
        /**
         * `CfnFunction.StateMachineSAMPTProperty.StateMachineName`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         * @external
         */
        readonly stateMachineName: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 * @external
 * @cloudformationResource AWS::Serverless::Function
 */
export declare namespace CfnFunction {
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     * @external
     */
    interface StreamSAMPTProperty {
        /**
         * `CfnFunction.StreamSAMPTProperty.StreamName`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         * @external
         */
        readonly streamName: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 * @external
 * @cloudformationResource AWS::Serverless::Function
 */
export declare namespace CfnFunction {
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     * @external
     */
    interface TableSAMPTProperty {
        /**
         * `CfnFunction.TableSAMPTProperty.TableName`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         * @external
         */
        readonly tableName: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 * @external
 * @cloudformationResource AWS::Serverless::Function
 */
export declare namespace CfnFunction {
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     * @external
     */
    interface TableStreamSAMPTProperty {
        /**
         * `CfnFunction.TableStreamSAMPTProperty.StreamName`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         * @external
         */
        readonly streamName: string;
        /**
         * `CfnFunction.TableStreamSAMPTProperty.TableName`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         * @external
         */
        readonly tableName: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 * @external
 * @cloudformationResource AWS::Serverless::Function
 */
export declare namespace CfnFunction {
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     * @external
     */
    interface TopicSAMPTProperty {
        /**
         * `CfnFunction.TopicSAMPTProperty.TopicName`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         * @external
         */
        readonly topicName: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 * @external
 * @cloudformationResource AWS::Serverless::Function
 */
export declare namespace CfnFunction {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-vpcconfig.html
     * @external
     */
    interface VpcConfigProperty {
        /**
         * `CfnFunction.VpcConfigProperty.SecurityGroupIds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-vpcconfig.html
         * @external
         */
        readonly securityGroupIds: string[];
        /**
         * `CfnFunction.VpcConfigProperty.SubnetIds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-vpcconfig.html
         * @external
         */
        readonly subnetIds: string[];
    }
}
/**
 * Properties for defining a `AWS::Serverless::LayerVersion`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesslayerversion
 * @external
 */
export interface CfnLayerVersionProps {
    /**
     * `AWS::Serverless::LayerVersion.CompatibleRuntimes`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesslayerversion
     * @external
     */
    readonly compatibleRuntimes?: string[];
    /**
     * `AWS::Serverless::LayerVersion.ContentUri`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesslayerversion
     * @external
     */
    readonly contentUri?: string;
    /**
     * `AWS::Serverless::LayerVersion.Description`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesslayerversion
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::Serverless::LayerVersion.LayerName`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesslayerversion
     * @external
     */
    readonly layerName?: string;
    /**
     * `AWS::Serverless::LayerVersion.LicenseInfo`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesslayerversion
     * @external
     */
    readonly licenseInfo?: string;
    /**
     * `AWS::Serverless::LayerVersion.RetentionPolicy`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesslayerversion
     * @external
     */
    readonly retentionPolicy?: string;
}
/**
 * A CloudFormation `AWS::Serverless::LayerVersion`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesslayerversion
 * @external
 * @cloudformationResource AWS::Serverless::LayerVersion
 */
export declare class CfnLayerVersion extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Serverless::LayerVersion";
    /**
     * The `Transform` a template must use in order to use this resource.
     *
     * @external
     */
    static readonly REQUIRED_TRANSFORM = "AWS::Serverless-2016-10-31";
    /**
     * `AWS::Serverless::LayerVersion.CompatibleRuntimes`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesslayerversion
     * @external
     */
    compatibleRuntimes: string[] | undefined;
    /**
     * `AWS::Serverless::LayerVersion.ContentUri`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesslayerversion
     * @external
     */
    contentUri: string | undefined;
    /**
     * `AWS::Serverless::LayerVersion.Description`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesslayerversion
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::Serverless::LayerVersion.LayerName`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesslayerversion
     * @external
     */
    layerName: string | undefined;
    /**
     * `AWS::Serverless::LayerVersion.LicenseInfo`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesslayerversion
     * @external
     */
    licenseInfo: string | undefined;
    /**
     * `AWS::Serverless::LayerVersion.RetentionPolicy`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesslayerversion
     * @external
     */
    retentionPolicy: string | undefined;
    /**
     * Create a new `AWS::Serverless::LayerVersion`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnLayerVersionProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Serverless::SimpleTable`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesssimpletable
 * @external
 */
export interface CfnSimpleTableProps {
    /**
     * `AWS::Serverless::SimpleTable.PrimaryKey`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#primary-key-object
     * @external
     */
    readonly primaryKey?: CfnSimpleTable.PrimaryKeyProperty | cdk.IResolvable;
    /**
     * `AWS::Serverless::SimpleTable.ProvisionedThroughput`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html
     * @external
     */
    readonly provisionedThroughput?: CfnSimpleTable.ProvisionedThroughputProperty | cdk.IResolvable;
    /**
     * `AWS::Serverless::SimpleTable.SSESpecification`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesssimpletable
     * @external
     */
    readonly sseSpecification?: CfnSimpleTable.SSESpecificationProperty | cdk.IResolvable;
    /**
     * `AWS::Serverless::SimpleTable.TableName`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesssimpletable
     * @external
     */
    readonly tableName?: string;
    /**
     * `AWS::Serverless::SimpleTable.Tags`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesssimpletable
     * @external
     */
    readonly tags?: {
        [key: string]: (string);
    };
}
/**
 * A CloudFormation `AWS::Serverless::SimpleTable`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesssimpletable
 * @external
 * @cloudformationResource AWS::Serverless::SimpleTable
 */
export declare class CfnSimpleTable extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Serverless::SimpleTable";
    /**
     * The `Transform` a template must use in order to use this resource.
     *
     * @external
     */
    static readonly REQUIRED_TRANSFORM = "AWS::Serverless-2016-10-31";
    /**
     * `AWS::Serverless::SimpleTable.PrimaryKey`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#primary-key-object
     * @external
     */
    primaryKey: CfnSimpleTable.PrimaryKeyProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::SimpleTable.ProvisionedThroughput`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html
     * @external
     */
    provisionedThroughput: CfnSimpleTable.ProvisionedThroughputProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::SimpleTable.SSESpecification`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesssimpletable
     * @external
     */
    sseSpecification: CfnSimpleTable.SSESpecificationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::SimpleTable.TableName`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesssimpletable
     * @external
     */
    tableName: string | undefined;
    /**
     * `AWS::Serverless::SimpleTable.Tags`.
     *
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesssimpletable
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Serverless::SimpleTable`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnSimpleTableProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Serverless::SimpleTable`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesssimpletable
 * @external
 * @cloudformationResource AWS::Serverless::SimpleTable
 */
export declare namespace CfnSimpleTable {
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#primary-key-object
     * @external
     */
    interface PrimaryKeyProperty {
        /**
         * `CfnSimpleTable.PrimaryKeyProperty.Name`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#primary-key-object
         * @external
         */
        readonly name?: string;
        /**
         * `CfnSimpleTable.PrimaryKeyProperty.Type`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#primary-key-object
         * @external
         */
        readonly type: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::SimpleTable`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesssimpletable
 * @external
 * @cloudformationResource AWS::Serverless::SimpleTable
 */
export declare namespace CfnSimpleTable {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html
     * @external
     */
    interface ProvisionedThroughputProperty {
        /**
         * `CfnSimpleTable.ProvisionedThroughputProperty.ReadCapacityUnits`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html
         * @external
         */
        readonly readCapacityUnits?: number;
        /**
         * `CfnSimpleTable.ProvisionedThroughputProperty.WriteCapacityUnits`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html
         * @external
         */
        readonly writeCapacityUnits: number;
    }
}
/**
 * A CloudFormation `AWS::Serverless::SimpleTable`.
 *
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesssimpletable
 * @external
 * @cloudformationResource AWS::Serverless::SimpleTable
 */
export declare namespace CfnSimpleTable {
    /**
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html
     * @external
     */
    interface SSESpecificationProperty {
        /**
         * `CfnSimpleTable.SSESpecificationProperty.SSEEnabled`.
         *
         * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html
         * @external
         */
        readonly sseEnabled?: boolean | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::Serverless::StateMachine`.
 *
 * @see https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
 * @external
 */
export interface CfnStateMachineProps {
    /**
     * `AWS::Serverless::StateMachine.Definition`.
     *
     * @see https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
     * @external
     */
    readonly definition?: any | cdk.IResolvable;
    /**
     * `AWS::Serverless::StateMachine.DefinitionSubstitutions`.
     *
     * @see https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
     * @external
     */
    readonly definitionSubstitutions?: {
        [key: string]: (string);
    } | cdk.IResolvable;
    /**
     * `AWS::Serverless::StateMachine.DefinitionUri`.
     *
     * @see https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
     * @external
     */
    readonly definitionUri?: CfnStateMachine.S3LocationProperty | string | cdk.IResolvable;
    /**
     * `AWS::Serverless::StateMachine.Events`.
     *
     * @see https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
     * @external
     */
    readonly events?: {
        [key: string]: (CfnStateMachine.EventSourceProperty | cdk.IResolvable);
    } | cdk.IResolvable;
    /**
     * `AWS::Serverless::StateMachine.Logging`.
     *
     * @see https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
     * @external
     */
    readonly logging?: CfnStateMachine.LoggingConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::Serverless::StateMachine.Name`.
     *
     * @see https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
     * @external
     */
    readonly name?: string;
    /**
     * `AWS::Serverless::StateMachine.Policies`.
     *
     * @see https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
     * @external
     */
    readonly policies?: Array<CfnStateMachine.IAMPolicyDocumentProperty | CfnStateMachine.SAMPolicyTemplateProperty | string | cdk.IResolvable> | CfnStateMachine.IAMPolicyDocumentProperty | string | cdk.IResolvable;
    /**
     * `AWS::Serverless::StateMachine.Role`.
     *
     * @see https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
     * @external
     */
    readonly role?: string;
    /**
     * `AWS::Serverless::StateMachine.Tags`.
     *
     * @see https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
     * @external
     */
    readonly tags?: {
        [key: string]: (string);
    };
    /**
     * `AWS::Serverless::StateMachine.Type`.
     *
     * @see https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
     * @external
     */
    readonly type?: string;
}
/**
 * A CloudFormation `AWS::Serverless::StateMachine`.
 *
 * @see https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
 * @external
 * @cloudformationResource AWS::Serverless::StateMachine
 */
export declare class CfnStateMachine extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Serverless::StateMachine";
    /**
     * The `Transform` a template must use in order to use this resource.
     *
     * @external
     */
    static readonly REQUIRED_TRANSFORM = "AWS::Serverless-2016-10-31";
    /**
     * `AWS::Serverless::StateMachine.Definition`.
     *
     * @see https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
     * @external
     */
    definition: any | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::StateMachine.DefinitionSubstitutions`.
     *
     * @see https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
     * @external
     */
    definitionSubstitutions: {
        [key: string]: (string);
    } | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::StateMachine.DefinitionUri`.
     *
     * @see https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
     * @external
     */
    definitionUri: CfnStateMachine.S3LocationProperty | string | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::StateMachine.Events`.
     *
     * @see https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
     * @external
     */
    events: {
        [key: string]: (CfnStateMachine.EventSourceProperty | cdk.IResolvable);
    } | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::StateMachine.Logging`.
     *
     * @see https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
     * @external
     */
    logging: CfnStateMachine.LoggingConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::StateMachine.Name`.
     *
     * @see https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
     * @external
     */
    name: string | undefined;
    /**
     * `AWS::Serverless::StateMachine.Policies`.
     *
     * @see https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
     * @external
     */
    policies: Array<CfnStateMachine.IAMPolicyDocumentProperty | CfnStateMachine.SAMPolicyTemplateProperty | string | cdk.IResolvable> | CfnStateMachine.IAMPolicyDocumentProperty | string | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::StateMachine.Role`.
     *
     * @see https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
     * @external
     */
    role: string | undefined;
    /**
     * `AWS::Serverless::StateMachine.Tags`.
     *
     * @see https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::Serverless::StateMachine.Type`.
     *
     * @see https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
     * @external
     */
    type: string | undefined;
    /**
     * Create a new `AWS::Serverless::StateMachine`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnStateMachineProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Serverless::StateMachine`.
 *
 * @see https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
 * @external
 * @cloudformationResource AWS::Serverless::StateMachine
 */
export declare namespace CfnStateMachine {
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api
     * @external
     */
    interface ApiEventProperty {
        /**
         * `CfnStateMachine.ApiEventProperty.Method`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api
         * @external
         */
        readonly method: string;
        /**
         * `CfnStateMachine.ApiEventProperty.Path`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api
         * @external
         */
        readonly path: string;
        /**
         * `CfnStateMachine.ApiEventProperty.RestApiId`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api
         * @external
         */
        readonly restApiId?: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::StateMachine`.
 *
 * @see https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
 * @external
 * @cloudformationResource AWS::Serverless::StateMachine
 */
export declare namespace CfnStateMachine {
    /**
     * @see https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-property-statemachine-cloudwatchevent.html
     * @external
     */
    interface CloudWatchEventEventProperty {
        /**
         * `CfnStateMachine.CloudWatchEventEventProperty.EventBusName`.
         *
         * @see https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-property-statemachine-cloudwatchevent.html
         * @external
         */
        readonly eventBusName?: string;
        /**
         * `CfnStateMachine.CloudWatchEventEventProperty.Input`.
         *
         * @see https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-property-statemachine-cloudwatchevent.html
         * @external
         */
        readonly input?: string;
        /**
         * `CfnStateMachine.CloudWatchEventEventProperty.InputPath`.
         *
         * @see https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-property-statemachine-cloudwatchevent.html
         * @external
         */
        readonly inputPath?: string;
        /**
         * `CfnStateMachine.CloudWatchEventEventProperty.Pattern`.
         *
         * @see http://docs.aws.amazon.com/AmazonCloudWatch/latest/events/CloudWatchEventsandEventPatterns.html
         * @external
         */
        readonly pattern: any | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Serverless::StateMachine`.
 *
 * @see https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
 * @external
 * @cloudformationResource AWS::Serverless::StateMachine
 */
export declare namespace CfnStateMachine {
    /**
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachine-logdestination-cloudwatchlogsloggroup.html
     * @external
     */
    interface CloudWatchLogsLogGroupProperty {
        /**
         * `CfnStateMachine.CloudWatchLogsLogGroupProperty.LogGroupArn`.
         *
         * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachine-logdestination-cloudwatchlogsloggroup.html
         * @external
         */
        readonly logGroupArn: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::StateMachine`.
 *
 * @see https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
 * @external
 * @cloudformationResource AWS::Serverless::StateMachine
 */
export declare namespace CfnStateMachine {
    /**
     * @see https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-property-statemachine-cloudwatchevent.html
     * @external
     */
    interface EventBridgeRuleEventProperty {
        /**
         * `CfnStateMachine.EventBridgeRuleEventProperty.EventBusName`.
         *
         * @see https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-property-statemachine-cloudwatchevent.html
         * @external
         */
        readonly eventBusName?: string;
        /**
         * `CfnStateMachine.EventBridgeRuleEventProperty.Input`.
         *
         * @see https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-property-statemachine-cloudwatchevent.html
         * @external
         */
        readonly input?: string;
        /**
         * `CfnStateMachine.EventBridgeRuleEventProperty.InputPath`.
         *
         * @see https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-property-statemachine-cloudwatchevent.html
         * @external
         */
        readonly inputPath?: string;
        /**
         * `CfnStateMachine.EventBridgeRuleEventProperty.Pattern`.
         *
         * @see http://docs.aws.amazon.com/AmazonCloudWatch/latest/events/CloudWatchEventsandEventPatterns.html
         * @external
         */
        readonly pattern: any | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Serverless::StateMachine`.
 *
 * @see https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
 * @external
 * @cloudformationResource AWS::Serverless::StateMachine
 */
export declare namespace CfnStateMachine {
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#event-source-object
     * @external
     */
    interface EventSourceProperty {
        /**
         * `CfnStateMachine.EventSourceProperty.Properties`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#event-source-types
         * @external
         */
        readonly properties: CfnStateMachine.CloudWatchEventEventProperty | CfnStateMachine.EventBridgeRuleEventProperty | CfnStateMachine.ScheduleEventProperty | CfnStateMachine.ApiEventProperty | cdk.IResolvable;
        /**
         * `CfnStateMachine.EventSourceProperty.Type`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#event-source-object
         * @external
         */
        readonly type: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::StateMachine`.
 *
 * @see https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
 * @external
 * @cloudformationResource AWS::Serverless::StateMachine
 */
export declare namespace CfnStateMachine {
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     * @external
     */
    interface FunctionSAMPTProperty {
        /**
         * `CfnStateMachine.FunctionSAMPTProperty.FunctionName`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         * @external
         */
        readonly functionName: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::StateMachine`.
 *
 * @see https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
 * @external
 * @cloudformationResource AWS::Serverless::StateMachine
 */
export declare namespace CfnStateMachine {
    /**
     * @see http://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html
     * @external
     */
    interface IAMPolicyDocumentProperty {
        /**
         * `CfnStateMachine.IAMPolicyDocumentProperty.Statement`.
         *
         * @see http://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html
         * @external
         */
        readonly statement: any | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Serverless::StateMachine`.
 *
 * @see https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
 * @external
 * @cloudformationResource AWS::Serverless::StateMachine
 */
export declare namespace CfnStateMachine {
    /**
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachine-logdestination.html#cfn-stepfunctions-statemachine-logdestination-cloudwatchlogsloggroup
     * @external
     */
    interface LogDestinationProperty {
        /**
         * `CfnStateMachine.LogDestinationProperty.CloudWatchLogsLogGroup`.
         *
         * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachine-logdestination.html#cfn-stepfunctions-statemachine-logdestination-cloudwatchlogsloggroup
         * @external
         */
        readonly cloudWatchLogsLogGroup: CfnStateMachine.CloudWatchLogsLogGroupProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Serverless::StateMachine`.
 *
 * @see https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
 * @external
 * @cloudformationResource AWS::Serverless::StateMachine
 */
export declare namespace CfnStateMachine {
    /**
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachine-loggingconfiguration.html
     * @external
     */
    interface LoggingConfigurationProperty {
        /**
         * `CfnStateMachine.LoggingConfigurationProperty.Destinations`.
         *
         * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachine-loggingconfiguration.html
         * @external
         */
        readonly destinations: Array<CfnStateMachine.LogDestinationProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnStateMachine.LoggingConfigurationProperty.IncludeExecutionData`.
         *
         * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachine-loggingconfiguration.html
         * @external
         */
        readonly includeExecutionData: boolean | cdk.IResolvable;
        /**
         * `CfnStateMachine.LoggingConfigurationProperty.Level`.
         *
         * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachine-loggingconfiguration.html
         * @external
         */
        readonly level: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::StateMachine`.
 *
 * @see https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
 * @external
 * @cloudformationResource AWS::Serverless::StateMachine
 */
export declare namespace CfnStateMachine {
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#s3-location-object
     * @external
     */
    interface S3LocationProperty {
        /**
         * `CfnStateMachine.S3LocationProperty.Bucket`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
         * @external
         */
        readonly bucket: string;
        /**
         * `CfnStateMachine.S3LocationProperty.Key`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
         * @external
         */
        readonly key: string;
        /**
         * `CfnStateMachine.S3LocationProperty.Version`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
         * @external
         */
        readonly version?: number;
    }
}
/**
 * A CloudFormation `AWS::Serverless::StateMachine`.
 *
 * @see https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
 * @external
 * @cloudformationResource AWS::Serverless::StateMachine
 */
export declare namespace CfnStateMachine {
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     * @external
     */
    interface SAMPolicyTemplateProperty {
        /**
         * `CfnStateMachine.SAMPolicyTemplateProperty.LambdaInvokePolicy`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         * @external
         */
        readonly lambdaInvokePolicy?: CfnStateMachine.FunctionSAMPTProperty | cdk.IResolvable;
        /**
         * `CfnStateMachine.SAMPolicyTemplateProperty.StepFunctionsExecutionPolicy`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         * @external
         */
        readonly stepFunctionsExecutionPolicy?: CfnStateMachine.StateMachineSAMPTProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Serverless::StateMachine`.
 *
 * @see https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
 * @external
 * @cloudformationResource AWS::Serverless::StateMachine
 */
export declare namespace CfnStateMachine {
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#schedule
     * @external
     */
    interface ScheduleEventProperty {
        /**
         * `CfnStateMachine.ScheduleEventProperty.Input`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#schedule
         * @external
         */
        readonly input?: string;
        /**
         * `CfnStateMachine.ScheduleEventProperty.Schedule`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#schedule
         * @external
         */
        readonly schedule: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::StateMachine`.
 *
 * @see https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
 * @external
 * @cloudformationResource AWS::Serverless::StateMachine
 */
export declare namespace CfnStateMachine {
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     * @external
     */
    interface StateMachineSAMPTProperty {
        /**
         * `CfnStateMachine.StateMachineSAMPTProperty.StateMachineName`.
         *
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         * @external
         */
        readonly stateMachineName: string;
    }
}
