"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseBucketName = exports.parseBucketArn = void 0;
const cdk = require("../../core"); // Automatically re-written from '@aws-cdk/core'
function parseBucketArn(construct, props) {
    // if we have an explicit bucket ARN, use it.
    if (props.bucketArn) {
        return props.bucketArn;
    }
    if (props.bucketName) {
        return cdk.Stack.of(construct).formatArn({
            // S3 Bucket names are globally unique in a partition,
            // and so their ARNs have empty region and account components
            region: '',
            account: '',
            service: 's3',
            resource: props.bucketName,
        });
    }
    throw new Error('Cannot determine bucket ARN. At least `bucketArn` or `bucketName` is needed');
}
exports.parseBucketArn = parseBucketArn;
function parseBucketName(construct, props) {
    // if we have an explicit bucket name, use it.
    if (props.bucketName) {
        return props.bucketName;
    }
    // extract bucket name from bucket arn
    if (props.bucketArn) {
        return cdk.Stack.of(construct).parseArn(props.bucketArn).resource;
    }
    // no bucket name is okay since it's optional.
    return undefined;
}
exports.parseBucketName = parseBucketName;
//# sourceMappingURL=data:application/json;base64,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