import * as cdk from "../../core";
import { IBucket } from './bucket';
/**
 * (experimental) Implemented by constructs that can be used as bucket notification destinations.
 *
 * @experimental
 */
export interface IBucketNotificationDestination {
    /**
     * (experimental) Registers this resource to receive notifications for the specified bucket.
     *
     * This method will only be called once for each destination/bucket
     * pair and the result will be cached, so there is no need to implement
     * idempotency in each destination.
     *
     * @param bucket The bucket object to bind to.
     * @experimental
     */
    bind(scope: cdk.Construct, bucket: IBucket): BucketNotificationDestinationConfig;
}
/**
 * (experimental) Represents the properties of a notification destination.
 *
 * @experimental
 */
export interface BucketNotificationDestinationConfig {
    /**
     * (experimental) The notification type.
     *
     * @experimental
     */
    readonly type: BucketNotificationDestinationType;
    /**
     * (experimental) The ARN of the destination (i.e. Lambda, SNS, SQS).
     *
     * @experimental
     */
    readonly arn: string;
    /**
     * (experimental) Any additional dependencies that should be resolved before the bucket notification can be configured (for example, the SNS Topic Policy resource).
     *
     * @experimental
     */
    readonly dependencies?: cdk.IDependable[];
}
/**
 * (experimental) Supported types of notification destinations.
 *
 * @experimental
 */
export declare enum BucketNotificationDestinationType {
    /**
     * @experimental
     */
    LAMBDA = 0,
    /**
     * @experimental
     */
    QUEUE = 1,
    /**
     * @experimental
     */
    TOPIC = 2
}
