"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnsDestination = void 0;
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const s3 = require("../../aws-s3"); // Automatically re-written from '@aws-cdk/aws-s3'
/**
 * (experimental) Use an SNS topic as a bucket notification destination.
 *
 * @experimental
 */
class SnsDestination {
    /**
     * @experimental
     */
    constructor(topic) {
        this.topic = topic;
    }
    /**
     * (experimental) Registers this resource to receive notifications for the specified bucket.
     *
     * This method will only be called once for each destination/bucket
     * pair and the result will be cached, so there is no need to implement
     * idempotency in each destination.
     *
     * @experimental
     */
    bind(_scope, bucket) {
        this.topic.addToResourcePolicy(new iam.PolicyStatement({
            principals: [new iam.ServicePrincipal('s3.amazonaws.com')],
            actions: ['sns:Publish'],
            resources: [this.topic.topicArn],
            conditions: {
                ArnLike: { 'aws:SourceArn': bucket.bucketArn },
            },
        }));
        return {
            arn: this.topic.topicArn,
            type: s3.BucketNotificationDestinationType.TOPIC,
            dependencies: [this.topic],
        };
    }
}
exports.SnsDestination = SnsDestination;
//# sourceMappingURL=data:application/json;base64,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