"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaDestination = void 0;
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const s3 = require("../../aws-s3"); // Automatically re-written from '@aws-cdk/aws-s3'
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * (experimental) Use a Lambda function as a bucket notification destination.
 *
 * @experimental
 */
class LambdaDestination {
    /**
     * @experimental
     */
    constructor(fn) {
        this.fn = fn;
    }
    /**
     * (experimental) Registers this resource to receive notifications for the specified bucket.
     *
     * This method will only be called once for each destination/bucket
     * pair and the result will be cached, so there is no need to implement
     * idempotency in each destination.
     *
     * @experimental
     */
    bind(_scope, bucket) {
        const permissionId = `AllowBucketNotificationsTo${this.fn.permissionsNode.uniqueId}`;
        if (!core_1.Construct.isConstruct(bucket)) {
            throw new Error(`LambdaDestination for function ${this.fn.permissionsNode.uniqueId} can only be configured on a
        bucket construct (Bucket ${bucket.bucketName})`);
        }
        if (bucket.node.tryFindChild(permissionId) === undefined) {
            this.fn.addPermission(permissionId, {
                sourceAccount: core_1.Stack.of(bucket).account,
                principal: new iam.ServicePrincipal('s3.amazonaws.com'),
                sourceArn: bucket.bucketArn,
                // Placing the permissions node in the same scope as the s3 bucket.
                // Otherwise, there is a circular dependency when the s3 bucket
                // and lambda functions declared in different stacks.
                scope: bucket,
            });
        }
        // if we have a permission resource for this relationship, add it as a dependency
        // to the bucket notifications resource, so it will be created first.
        const permission = bucket.node.tryFindChild(permissionId);
        return {
            type: s3.BucketNotificationDestinationType.LAMBDA,
            arn: this.fn.functionArn,
            dependencies: permission ? [permission] : undefined,
        };
    }
}
exports.LambdaDestination = LambdaDestination;
//# sourceMappingURL=data:application/json;base64,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