import { IResource } from "../../core";
/**
 * (experimental) Imported or created hosted zone.
 *
 * @experimental
 */
export interface IHostedZone extends IResource {
    /**
     * (experimental) ID of this hosted zone, such as "Z23ABC4XYZL05B".
     *
     * @experimental
     * @attribute true
     */
    readonly hostedZoneId: string;
    /**
     * (experimental) FQDN of this hosted zone.
     *
     * @experimental
     */
    readonly zoneName: string;
    /**
     * (experimental) ARN of this hosted zone, such as arn:${Partition}:route53:::hostedzone/${Id}.
     *
     * @experimental
     * @attribute true
     */
    readonly hostedZoneArn: string;
    /**
     * (experimental) Returns the set of name servers for the specific hosted zone. For example: ns1.example.com.
     *
     * This attribute will be undefined for private hosted zones or hosted zones imported from another stack.
     *
     * @experimental
     * @attribute true
     */
    readonly hostedZoneNameServers?: string[];
}
/**
 * (experimental) Reference to a hosted zone.
 *
 * @experimental
 */
export interface HostedZoneAttributes {
    /**
     * (experimental) Identifier of the hosted zone.
     *
     * @experimental
     */
    readonly hostedZoneId: string;
    /**
     * (experimental) Name of the hosted zone.
     *
     * @experimental
     */
    readonly zoneName: string;
}
