"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserPoolDomainTarget = void 0;
const cloudfront_target_1 = require("./cloudfront-target");
/**
 * (experimental) Use a user pool domain as an alias record target.
 *
 * @experimental
 */
class UserPoolDomainTarget {
    /**
     * @experimental
     */
    constructor(domain) {
        this.domain = domain;
    }
    /**
     * (experimental) Return hosted zone ID and DNS name, usable for Route53 alias targets.
     *
     * @experimental
     */
    bind(_record) {
        return {
            dnsName: this.domain.cloudFrontDomainName,
            hostedZoneId: cloudfront_target_1.CloudFrontTarget.getHostedZoneId(this.domain),
        };
    }
}
exports.UserPoolDomainTarget = UserPoolDomainTarget;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXNlcnBvb2wtZG9tYWluLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsidXNlcnBvb2wtZG9tYWluLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUVBLDJEQUF1RDs7Ozs7O0FBSXZELE1BQWEsb0JBQW9COzs7O0lBQzdCLFlBQTZCLE1BQXNCO1FBQXRCLFdBQU0sR0FBTixNQUFNLENBQWdCO0lBQ25ELENBQUM7Ozs7OztJQUNNLElBQUksQ0FBQyxPQUFtQjtRQUMzQixPQUFPO1lBQ0gsT0FBTyxFQUFFLElBQUksQ0FBQyxNQUFNLENBQUMsb0JBQW9CO1lBQ3pDLFlBQVksRUFBRSxvQ0FBZ0IsQ0FBQyxlQUFlLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQztTQUM5RCxDQUFDO0lBQ04sQ0FBQztDQUNKO0FBVEQsb0RBU0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBVc2VyUG9vbERvbWFpbiB9IGZyb20gXCIuLi8uLi9hd3MtY29nbml0b1wiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvYXdzLWNvZ25pdG8nXG5pbXBvcnQgeyBBbGlhc1JlY29yZFRhcmdldENvbmZpZywgSUFsaWFzUmVjb3JkVGFyZ2V0LCBJUmVjb3JkU2V0IH0gZnJvbSBcIi4uLy4uL2F3cy1yb3V0ZTUzXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9hd3Mtcm91dGU1MydcbmltcG9ydCB7IENsb3VkRnJvbnRUYXJnZXQgfSBmcm9tICcuL2Nsb3VkZnJvbnQtdGFyZ2V0JztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgVXNlclBvb2xEb21haW5UYXJnZXQgaW1wbGVtZW50cyBJQWxpYXNSZWNvcmRUYXJnZXQge1xuICAgIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgZG9tYWluOiBVc2VyUG9vbERvbWFpbikge1xuICAgIH1cbiAgICBwdWJsaWMgYmluZChfcmVjb3JkOiBJUmVjb3JkU2V0KTogQWxpYXNSZWNvcmRUYXJnZXRDb25maWcge1xuICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgZG5zTmFtZTogdGhpcy5kb21haW4uY2xvdWRGcm9udERvbWFpbk5hbWUsXG4gICAgICAgICAgICBob3N0ZWRab25lSWQ6IENsb3VkRnJvbnRUYXJnZXQuZ2V0SG9zdGVkWm9uZUlkKHRoaXMuZG9tYWluKSxcbiAgICAgICAgfTtcbiAgICB9XG59XG4iXX0=