import * as cloudfront from "../../aws-cloudfront";
import * as route53 from "../../aws-route53";
import { IConstruct } from "../../core";
/**
 * (experimental) Use a CloudFront Distribution as an alias record target.
 *
 * @experimental
 */
export declare class CloudFrontTarget implements route53.IAliasRecordTarget {
    private readonly distribution;
    /**
     * (experimental) The hosted zone Id if using an alias record in Route53.
     *
     * This value never changes.
     *
     * @experimental
     */
    static readonly CLOUDFRONT_ZONE_ID = "Z2FDTNDATAQYW2";
    /**
     * (experimental) Get the hosted zone id for the current scope.
     *
     * @param scope - scope in which this resource is defined.
     * @experimental
     */
    static getHostedZoneId(scope: IConstruct): string;
    /**
     * @experimental
     */
    constructor(distribution: cloudfront.IDistribution);
    /**
     * (experimental) Return hosted zone ID and DNS name, usable for Route53 alias targets.
     *
     * @experimental
     */
    bind(_record: route53.IRecordSet): route53.AliasRecordTargetConfig;
}
