"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BucketWebsiteTarget = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const region_info_1 = require("../../region-info"); // Automatically re-written from '@aws-cdk/region-info'
/**
 * (experimental) Use a S3 as an alias record target.
 *
 * @experimental
 */
class BucketWebsiteTarget {
    /**
     * @experimental
     */
    constructor(bucket) {
        this.bucket = bucket;
    }
    /**
     * (experimental) Return hosted zone ID and DNS name, usable for Route53 alias targets.
     *
     * @experimental
     */
    bind(_record) {
        const { region } = core_1.Stack.of(this.bucket.stack);
        if (core_1.Token.isUnresolved(region)) {
            throw new Error([
                'Cannot use an S3 record alias in region-agnostic stacks.',
                'You must specify a specific region when you define the stack',
                '(see https://docs.aws.amazon.com/cdk/latest/guide/environments.html)',
            ].join(' '));
        }
        const { s3StaticWebsiteHostedZoneId: hostedZoneId, s3StaticWebsiteEndpoint: dnsName } = region_info_1.RegionInfo.get(region);
        if (!hostedZoneId || !dnsName) {
            throw new Error(`Bucket website target is not supported for the "${region}" region`);
        }
        return { hostedZoneId, dnsName };
    }
}
exports.BucketWebsiteTarget = BucketWebsiteTarget;
//# sourceMappingURL=data:application/json;base64,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