"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiGateway = exports.ApiGatewayDomain = void 0;
/**
 * (experimental) Defines an API Gateway domain name as the alias target.
 *
 * Use the `ApiGateway` class if you wish to map the alias to an REST API with a
 * domain name defined throug the `RestApiProps.domainName` prop.
 *
 * @experimental
 */
class ApiGatewayDomain {
    /**
     * @experimental
     */
    constructor(domainName) {
        this.domainName = domainName;
    }
    /**
     * (experimental) Return hosted zone ID and DNS name, usable for Route53 alias targets.
     *
     * @experimental
     */
    bind(_record) {
        return {
            dnsName: this.domainName.domainNameAliasDomainName,
            hostedZoneId: this.domainName.domainNameAliasHostedZoneId,
        };
    }
}
exports.ApiGatewayDomain = ApiGatewayDomain;
/**
 * (experimental) Defines an API Gateway REST API as the alias target. Requires that the domain name will be defined through `RestApiProps.domainName`.
 *
 * You can direct the alias to any `apigateway.DomainName` resource through the
 * `ApiGatewayDomain` class.
 *
 * @experimental
 */
class ApiGateway extends ApiGatewayDomain {
    /**
     * @experimental
     */
    constructor(api) {
        if (!api.domainName) {
            throw new Error('API does not define a default domain name');
        }
        super(api.domainName);
    }
}
exports.ApiGateway = ApiGateway;
//# sourceMappingURL=data:application/json;base64,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