import * as cdk from "../../core";
/**
 * Properties for defining a `AWS::RoboMaker::Fleet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-fleet.html
 * @external
 */
export interface CfnFleetProps {
    /**
     * `AWS::RoboMaker::Fleet.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-fleet.html#cfn-robomaker-fleet-name
     * @external
     */
    readonly name?: string;
    /**
     * `AWS::RoboMaker::Fleet.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-fleet.html#cfn-robomaker-fleet-tags
     * @external
     */
    readonly tags?: any;
}
/**
 * A CloudFormation `AWS::RoboMaker::Fleet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-fleet.html
 * @external
 * @cloudformationResource AWS::RoboMaker::Fleet
 */
export declare class CfnFleet extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::RoboMaker::Fleet";
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::RoboMaker::Fleet.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-fleet.html#cfn-robomaker-fleet-name
     * @external
     */
    name: string | undefined;
    /**
     * `AWS::RoboMaker::Fleet.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-fleet.html#cfn-robomaker-fleet-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::RoboMaker::Fleet`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnFleetProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::RoboMaker::Robot`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robot.html
 * @external
 */
export interface CfnRobotProps {
    /**
     * `AWS::RoboMaker::Robot.Architecture`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robot.html#cfn-robomaker-robot-architecture
     * @external
     */
    readonly architecture: string;
    /**
     * `AWS::RoboMaker::Robot.GreengrassGroupId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robot.html#cfn-robomaker-robot-greengrassgroupid
     * @external
     */
    readonly greengrassGroupId: string;
    /**
     * `AWS::RoboMaker::Robot.Fleet`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robot.html#cfn-robomaker-robot-fleet
     * @external
     */
    readonly fleet?: string;
    /**
     * `AWS::RoboMaker::Robot.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robot.html#cfn-robomaker-robot-name
     * @external
     */
    readonly name?: string;
    /**
     * `AWS::RoboMaker::Robot.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robot.html#cfn-robomaker-robot-tags
     * @external
     */
    readonly tags?: any;
}
/**
 * A CloudFormation `AWS::RoboMaker::Robot`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robot.html
 * @external
 * @cloudformationResource AWS::RoboMaker::Robot
 */
export declare class CfnRobot extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::RoboMaker::Robot";
    /**
     * `AWS::RoboMaker::Robot.Architecture`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robot.html#cfn-robomaker-robot-architecture
     * @external
     */
    architecture: string;
    /**
     * `AWS::RoboMaker::Robot.GreengrassGroupId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robot.html#cfn-robomaker-robot-greengrassgroupid
     * @external
     */
    greengrassGroupId: string;
    /**
     * `AWS::RoboMaker::Robot.Fleet`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robot.html#cfn-robomaker-robot-fleet
     * @external
     */
    fleet: string | undefined;
    /**
     * `AWS::RoboMaker::Robot.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robot.html#cfn-robomaker-robot-name
     * @external
     */
    name: string | undefined;
    /**
     * `AWS::RoboMaker::Robot.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robot.html#cfn-robomaker-robot-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::RoboMaker::Robot`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnRobotProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::RoboMaker::RobotApplication`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robotapplication.html
 * @external
 */
export interface CfnRobotApplicationProps {
    /**
     * `AWS::RoboMaker::RobotApplication.RobotSoftwareSuite`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robotapplication.html#cfn-robomaker-robotapplication-robotsoftwaresuite
     * @external
     */
    readonly robotSoftwareSuite: CfnRobotApplication.RobotSoftwareSuiteProperty | cdk.IResolvable;
    /**
     * `AWS::RoboMaker::RobotApplication.Sources`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robotapplication.html#cfn-robomaker-robotapplication-sources
     * @external
     */
    readonly sources: Array<CfnRobotApplication.SourceConfigProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::RoboMaker::RobotApplication.CurrentRevisionId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robotapplication.html#cfn-robomaker-robotapplication-currentrevisionid
     * @external
     */
    readonly currentRevisionId?: string;
    /**
     * `AWS::RoboMaker::RobotApplication.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robotapplication.html#cfn-robomaker-robotapplication-name
     * @external
     */
    readonly name?: string;
    /**
     * `AWS::RoboMaker::RobotApplication.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robotapplication.html#cfn-robomaker-robotapplication-tags
     * @external
     */
    readonly tags?: any;
}
/**
 * A CloudFormation `AWS::RoboMaker::RobotApplication`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robotapplication.html
 * @external
 * @cloudformationResource AWS::RoboMaker::RobotApplication
 */
export declare class CfnRobotApplication extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::RoboMaker::RobotApplication";
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute CurrentRevisionId
     */
    readonly attrCurrentRevisionId: string;
    /**
     * `AWS::RoboMaker::RobotApplication.RobotSoftwareSuite`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robotapplication.html#cfn-robomaker-robotapplication-robotsoftwaresuite
     * @external
     */
    robotSoftwareSuite: CfnRobotApplication.RobotSoftwareSuiteProperty | cdk.IResolvable;
    /**
     * `AWS::RoboMaker::RobotApplication.Sources`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robotapplication.html#cfn-robomaker-robotapplication-sources
     * @external
     */
    sources: Array<CfnRobotApplication.SourceConfigProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::RoboMaker::RobotApplication.CurrentRevisionId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robotapplication.html#cfn-robomaker-robotapplication-currentrevisionid
     * @external
     */
    currentRevisionId: string | undefined;
    /**
     * `AWS::RoboMaker::RobotApplication.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robotapplication.html#cfn-robomaker-robotapplication-name
     * @external
     */
    name: string | undefined;
    /**
     * `AWS::RoboMaker::RobotApplication.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robotapplication.html#cfn-robomaker-robotapplication-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::RoboMaker::RobotApplication`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnRobotApplicationProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::RoboMaker::RobotApplication`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robotapplication.html
 * @external
 * @cloudformationResource AWS::RoboMaker::RobotApplication
 */
export declare namespace CfnRobotApplication {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-robotapplication-robotsoftwaresuite.html
     * @external
     */
    interface RobotSoftwareSuiteProperty {
        /**
         * `CfnRobotApplication.RobotSoftwareSuiteProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-robotapplication-robotsoftwaresuite.html#cfn-robomaker-robotapplication-robotsoftwaresuite-name
         * @external
         */
        readonly name: string;
        /**
         * `CfnRobotApplication.RobotSoftwareSuiteProperty.Version`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-robotapplication-robotsoftwaresuite.html#cfn-robomaker-robotapplication-robotsoftwaresuite-version
         * @external
         */
        readonly version: string;
    }
}
/**
 * A CloudFormation `AWS::RoboMaker::RobotApplication`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robotapplication.html
 * @external
 * @cloudformationResource AWS::RoboMaker::RobotApplication
 */
export declare namespace CfnRobotApplication {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-robotapplication-sourceconfig.html
     * @external
     */
    interface SourceConfigProperty {
        /**
         * `CfnRobotApplication.SourceConfigProperty.Architecture`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-robotapplication-sourceconfig.html#cfn-robomaker-robotapplication-sourceconfig-architecture
         * @external
         */
        readonly architecture: string;
        /**
         * `CfnRobotApplication.SourceConfigProperty.S3Bucket`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-robotapplication-sourceconfig.html#cfn-robomaker-robotapplication-sourceconfig-s3bucket
         * @external
         */
        readonly s3Bucket: string;
        /**
         * `CfnRobotApplication.SourceConfigProperty.S3Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-robotapplication-sourceconfig.html#cfn-robomaker-robotapplication-sourceconfig-s3key
         * @external
         */
        readonly s3Key: string;
    }
}
/**
 * Properties for defining a `AWS::RoboMaker::RobotApplicationVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robotapplicationversion.html
 * @external
 */
export interface CfnRobotApplicationVersionProps {
    /**
     * `AWS::RoboMaker::RobotApplicationVersion.Application`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robotapplicationversion.html#cfn-robomaker-robotapplicationversion-application
     * @external
     */
    readonly application: string;
    /**
     * `AWS::RoboMaker::RobotApplicationVersion.CurrentRevisionId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robotapplicationversion.html#cfn-robomaker-robotapplicationversion-currentrevisionid
     * @external
     */
    readonly currentRevisionId?: string;
}
/**
 * A CloudFormation `AWS::RoboMaker::RobotApplicationVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robotapplicationversion.html
 * @external
 * @cloudformationResource AWS::RoboMaker::RobotApplicationVersion
 */
export declare class CfnRobotApplicationVersion extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::RoboMaker::RobotApplicationVersion";
    /**
     * `AWS::RoboMaker::RobotApplicationVersion.Application`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robotapplicationversion.html#cfn-robomaker-robotapplicationversion-application
     * @external
     */
    application: string;
    /**
     * `AWS::RoboMaker::RobotApplicationVersion.CurrentRevisionId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robotapplicationversion.html#cfn-robomaker-robotapplicationversion-currentrevisionid
     * @external
     */
    currentRevisionId: string | undefined;
    /**
     * Create a new `AWS::RoboMaker::RobotApplicationVersion`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnRobotApplicationVersionProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::RoboMaker::SimulationApplication`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html
 * @external
 */
export interface CfnSimulationApplicationProps {
    /**
     * `AWS::RoboMaker::SimulationApplication.RenderingEngine`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-renderingengine
     * @external
     */
    readonly renderingEngine: CfnSimulationApplication.RenderingEngineProperty | cdk.IResolvable;
    /**
     * `AWS::RoboMaker::SimulationApplication.RobotSoftwareSuite`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-robotsoftwaresuite
     * @external
     */
    readonly robotSoftwareSuite: CfnSimulationApplication.RobotSoftwareSuiteProperty | cdk.IResolvable;
    /**
     * `AWS::RoboMaker::SimulationApplication.SimulationSoftwareSuite`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-simulationsoftwaresuite
     * @external
     */
    readonly simulationSoftwareSuite: CfnSimulationApplication.SimulationSoftwareSuiteProperty | cdk.IResolvable;
    /**
     * `AWS::RoboMaker::SimulationApplication.Sources`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-sources
     * @external
     */
    readonly sources: Array<CfnSimulationApplication.SourceConfigProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::RoboMaker::SimulationApplication.CurrentRevisionId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-currentrevisionid
     * @external
     */
    readonly currentRevisionId?: string;
    /**
     * `AWS::RoboMaker::SimulationApplication.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-name
     * @external
     */
    readonly name?: string;
    /**
     * `AWS::RoboMaker::SimulationApplication.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-tags
     * @external
     */
    readonly tags?: any;
}
/**
 * A CloudFormation `AWS::RoboMaker::SimulationApplication`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html
 * @external
 * @cloudformationResource AWS::RoboMaker::SimulationApplication
 */
export declare class CfnSimulationApplication extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::RoboMaker::SimulationApplication";
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute CurrentRevisionId
     */
    readonly attrCurrentRevisionId: string;
    /**
     * `AWS::RoboMaker::SimulationApplication.RenderingEngine`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-renderingengine
     * @external
     */
    renderingEngine: CfnSimulationApplication.RenderingEngineProperty | cdk.IResolvable;
    /**
     * `AWS::RoboMaker::SimulationApplication.RobotSoftwareSuite`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-robotsoftwaresuite
     * @external
     */
    robotSoftwareSuite: CfnSimulationApplication.RobotSoftwareSuiteProperty | cdk.IResolvable;
    /**
     * `AWS::RoboMaker::SimulationApplication.SimulationSoftwareSuite`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-simulationsoftwaresuite
     * @external
     */
    simulationSoftwareSuite: CfnSimulationApplication.SimulationSoftwareSuiteProperty | cdk.IResolvable;
    /**
     * `AWS::RoboMaker::SimulationApplication.Sources`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-sources
     * @external
     */
    sources: Array<CfnSimulationApplication.SourceConfigProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::RoboMaker::SimulationApplication.CurrentRevisionId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-currentrevisionid
     * @external
     */
    currentRevisionId: string | undefined;
    /**
     * `AWS::RoboMaker::SimulationApplication.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-name
     * @external
     */
    name: string | undefined;
    /**
     * `AWS::RoboMaker::SimulationApplication.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::RoboMaker::SimulationApplication`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSimulationApplicationProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::RoboMaker::SimulationApplication`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html
 * @external
 * @cloudformationResource AWS::RoboMaker::SimulationApplication
 */
export declare namespace CfnSimulationApplication {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-simulationapplication-renderingengine.html
     * @external
     */
    interface RenderingEngineProperty {
        /**
         * `CfnSimulationApplication.RenderingEngineProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-simulationapplication-renderingengine.html#cfn-robomaker-simulationapplication-renderingengine-name
         * @external
         */
        readonly name: string;
        /**
         * `CfnSimulationApplication.RenderingEngineProperty.Version`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-simulationapplication-renderingengine.html#cfn-robomaker-simulationapplication-renderingengine-version
         * @external
         */
        readonly version: string;
    }
}
/**
 * A CloudFormation `AWS::RoboMaker::SimulationApplication`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html
 * @external
 * @cloudformationResource AWS::RoboMaker::SimulationApplication
 */
export declare namespace CfnSimulationApplication {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-simulationapplication-robotsoftwaresuite.html
     * @external
     */
    interface RobotSoftwareSuiteProperty {
        /**
         * `CfnSimulationApplication.RobotSoftwareSuiteProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-simulationapplication-robotsoftwaresuite.html#cfn-robomaker-simulationapplication-robotsoftwaresuite-name
         * @external
         */
        readonly name: string;
        /**
         * `CfnSimulationApplication.RobotSoftwareSuiteProperty.Version`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-simulationapplication-robotsoftwaresuite.html#cfn-robomaker-simulationapplication-robotsoftwaresuite-version
         * @external
         */
        readonly version: string;
    }
}
/**
 * A CloudFormation `AWS::RoboMaker::SimulationApplication`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html
 * @external
 * @cloudformationResource AWS::RoboMaker::SimulationApplication
 */
export declare namespace CfnSimulationApplication {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-simulationapplication-simulationsoftwaresuite.html
     * @external
     */
    interface SimulationSoftwareSuiteProperty {
        /**
         * `CfnSimulationApplication.SimulationSoftwareSuiteProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-simulationapplication-simulationsoftwaresuite.html#cfn-robomaker-simulationapplication-simulationsoftwaresuite-name
         * @external
         */
        readonly name: string;
        /**
         * `CfnSimulationApplication.SimulationSoftwareSuiteProperty.Version`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-simulationapplication-simulationsoftwaresuite.html#cfn-robomaker-simulationapplication-simulationsoftwaresuite-version
         * @external
         */
        readonly version: string;
    }
}
/**
 * A CloudFormation `AWS::RoboMaker::SimulationApplication`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html
 * @external
 * @cloudformationResource AWS::RoboMaker::SimulationApplication
 */
export declare namespace CfnSimulationApplication {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-simulationapplication-sourceconfig.html
     * @external
     */
    interface SourceConfigProperty {
        /**
         * `CfnSimulationApplication.SourceConfigProperty.Architecture`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-simulationapplication-sourceconfig.html#cfn-robomaker-simulationapplication-sourceconfig-architecture
         * @external
         */
        readonly architecture: string;
        /**
         * `CfnSimulationApplication.SourceConfigProperty.S3Bucket`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-simulationapplication-sourceconfig.html#cfn-robomaker-simulationapplication-sourceconfig-s3bucket
         * @external
         */
        readonly s3Bucket: string;
        /**
         * `CfnSimulationApplication.SourceConfigProperty.S3Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-simulationapplication-sourceconfig.html#cfn-robomaker-simulationapplication-sourceconfig-s3key
         * @external
         */
        readonly s3Key: string;
    }
}
/**
 * Properties for defining a `AWS::RoboMaker::SimulationApplicationVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplicationversion.html
 * @external
 */
export interface CfnSimulationApplicationVersionProps {
    /**
     * `AWS::RoboMaker::SimulationApplicationVersion.Application`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplicationversion.html#cfn-robomaker-simulationapplicationversion-application
     * @external
     */
    readonly application: string;
    /**
     * `AWS::RoboMaker::SimulationApplicationVersion.CurrentRevisionId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplicationversion.html#cfn-robomaker-simulationapplicationversion-currentrevisionid
     * @external
     */
    readonly currentRevisionId?: string;
}
/**
 * A CloudFormation `AWS::RoboMaker::SimulationApplicationVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplicationversion.html
 * @external
 * @cloudformationResource AWS::RoboMaker::SimulationApplicationVersion
 */
export declare class CfnSimulationApplicationVersion extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::RoboMaker::SimulationApplicationVersion";
    /**
     * `AWS::RoboMaker::SimulationApplicationVersion.Application`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplicationversion.html#cfn-robomaker-simulationapplicationversion-application
     * @external
     */
    application: string;
    /**
     * `AWS::RoboMaker::SimulationApplicationVersion.CurrentRevisionId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplicationversion.html#cfn-robomaker-simulationapplicationversion-currentrevisionid
     * @external
     */
    currentRevisionId: string | undefined;
    /**
     * Create a new `AWS::RoboMaker::SimulationApplicationVersion`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSimulationApplicationVersionProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
