import * as kms from "../../aws-kms";
import * as secretsmanager from "../../aws-secretsmanager";
import { Construct } from 'constructs';
/**
 * (experimental) Construction properties for a DatabaseSecret.
 *
 * @experimental
 */
export interface DatabaseSecretProps {
    /**
     * (experimental) The username.
     *
     * @experimental
     */
    readonly username: string;
    /**
     * (experimental) The KMS key to use to encrypt the secret.
     *
     * @default default master key
     * @experimental
     */
    readonly encryptionKey?: kms.IKey;
}
/**
 * (experimental) A database secret.
 *
 * @experimental
 * @resource AWS::SecretsManager::Secret
 */
export declare class DatabaseSecret extends secretsmanager.Secret {
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: DatabaseSecretProps);
}
