import * as cloudwatch from "../../aws-cloudwatch";
declare module "./cluster-ref" {
    /**
     * (experimental) Create a clustered database with a given number of instances.
     *
     * @experimental
     */
    interface IDatabaseCluster {
        /**
         * (experimental) Return the given named metric for this DBCluster.
         *
         * @experimental
         */
        metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The percentage of CPU utilization.
         *
         * Average over 5 minutes
         *
         * @experimental
         */
        metricCPUUtilization(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The number of database connections in use.
         *
         * Average over 5 minutes
         *
         * @experimental
         */
        metricDatabaseConnections(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The average number of deadlocks in the database per second.
         *
         * Average over 5 minutes
         *
         * @experimental
         */
        metricDeadlocks(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The amount of time that the instance has been running, in seconds.
         *
         * Average over 5 minutes
         *
         * @experimental
         */
        metricEngineUptime(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The amount of available random access memory, in bytes.
         *
         * Average over 5 minutes
         *
         * @experimental
         */
        metricFreeableMemory(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The amount of local storage available, in bytes.
         *
         * Average over 5 minutes
         *
         * @experimental
         */
        metricFreeLocalStorage(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The amount of network throughput received from clients by each instance, in bytes per second.
         *
         * Average over 5 minutes
         *
         * @experimental
         */
        metricNetworkReceiveThroughput(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The amount of network throughput both received from and transmitted to clients by each instance, in bytes per second.
         *
         * Average over 5 minutes
         *
         * @experimental
         */
        metricNetworkThroughput(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The amount of network throughput sent to clients by each instance, in bytes per second.
         *
         * Average over 5 minutes
         *
         * @experimental
         */
        metricNetworkTransmitThroughput(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The total amount of backup storage in bytes consumed by all Aurora snapshots outside its backup retention window.
         *
         * Average over 5 minutes
         *
         * @experimental
         */
        metricSnapshotStorageUsed(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The total amount of backup storage in bytes for which you are billed.
         *
         * Average over 5 minutes
         *
         * @experimental
         */
        metricTotalBackupStorageBilled(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The amount of storage used by your Aurora DB instance, in bytes.
         *
         * Average over 5 minutes
         *
         * @experimental
         */
        metricVolumeBytesUsed(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The number of billed read I/O operations from a cluster volume, reported at 5-minute intervals.
         *
         * Average over 5 minutes
         *
         * @experimental
         */
        metricVolumeReadIOPs(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The number of write disk I/O operations to the cluster volume, reported at 5-minute intervals.
         *
         * Average over 5 minutes
         *
         * @experimental
         */
        metricVolumeWriteIOPs(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    }
}
declare module "./cluster" {
    /**
     * (experimental) A new or imported clustered database.
     *
     * @experimental
     */
    interface DatabaseClusterBase {
        /**
         * (experimental) Return the given named metric for this DBCluster.
         *
         * @experimental
         */
        metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The percentage of CPU utilization.
         *
         * Average over 5 minutes
         *
         * @experimental
         */
        metricCPUUtilization(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The number of database connections in use.
         *
         * Average over 5 minutes
         *
         * @experimental
         */
        metricDatabaseConnections(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The average number of deadlocks in the database per second.
         *
         * Average over 5 minutes
         *
         * @experimental
         */
        metricDeadlocks(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The amount of time that the instance has been running, in seconds.
         *
         * Average over 5 minutes
         *
         * @experimental
         */
        metricEngineUptime(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The amount of available random access memory, in bytes.
         *
         * Average over 5 minutes
         *
         * @experimental
         */
        metricFreeableMemory(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The amount of local storage available, in bytes.
         *
         * Average over 5 minutes
         *
         * @experimental
         */
        metricFreeLocalStorage(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The amount of network throughput received from clients by each instance, in bytes per second.
         *
         * Average over 5 minutes
         *
         * @experimental
         */
        metricNetworkReceiveThroughput(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The amount of network throughput both received from and transmitted to clients by each instance, in bytes per second.
         *
         * Average over 5 minutes
         *
         * @experimental
         */
        metricNetworkThroughput(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The amount of network throughput sent to clients by each instance, in bytes per second.
         *
         * Average over 5 minutes
         *
         * @experimental
         */
        metricNetworkTransmitThroughput(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The total amount of backup storage in bytes consumed by all Aurora snapshots outside its backup retention window.
         *
         * Average over 5 minutes
         *
         * @experimental
         */
        metricSnapshotStorageUsed(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The total amount of backup storage in bytes for which you are billed.
         *
         * Average over 5 minutes
         *
         * @experimental
         */
        metricTotalBackupStorageBilled(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The amount of storage used by your Aurora DB instance, in bytes.
         *
         * Average over 5 minutes
         *
         * @experimental
         */
        metricVolumeBytesUsed(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The number of billed read I/O operations from a cluster volume, reported at 5-minute intervals.
         *
         * Average over 5 minutes
         *
         * @experimental
         */
        metricVolumeReadIOPs(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The number of write disk I/O operations to the cluster volume, reported at 5-minute intervals.
         *
         * Average over 5 minutes
         *
         * @experimental
         */
        metricVolumeWriteIOPs(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    }
}
declare module "./instance" {
    /**
     * (experimental) A database instance.
     *
     * @experimental
     */
    interface IDatabaseInstance {
        /**
         * (experimental) Return the given named metric for this DBInstance.
         *
         * @experimental
         */
        metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The percentage of CPU utilization.
         *
         * Average over 5 minutes
         *
         * @experimental
         */
        metricCPUUtilization(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The number of database connections in use.
         *
         * Average over 5 minutes
         *
         * @experimental
         */
        metricDatabaseConnections(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The amount of available storage space.
         *
         * Average over 5 minutes
         *
         * @experimental
         */
        metricFreeStorageSpace(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The amount of available random access memory.
         *
         * Average over 5 minutes
         *
         * @experimental
         */
        metricFreeableMemory(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The average number of disk read I/O operations per second.
         *
         * Average over 5 minutes
         *
         * @experimental
         */
        metricWriteIOPS(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The average number of disk write I/O operations per second.
         *
         * Average over 5 minutes
         *
         * @experimental
         */
        metricReadIOPS(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    }
    /**
     * (experimental) A new or imported database instance.
     *
     * @experimental
     */
    interface DatabaseInstanceBase {
        /**
         * (experimental) Return the given named metric for this DBInstance.
         *
         * @experimental
         */
        metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The percentage of CPU utilization.
         *
         * Average over 5 minutes
         *
         * @experimental
         */
        metricCPUUtilization(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The number of database connections in use.
         *
         * Average over 5 minutes
         *
         * @experimental
         */
        metricDatabaseConnections(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The amount of available storage space.
         *
         * Average over 5 minutes
         *
         * @experimental
         */
        metricFreeStorageSpace(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The amount of available random access memory.
         *
         * Average over 5 minutes
         *
         * @experimental
         */
        metricFreeableMemory(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The average number of disk read I/O operations per second.
         *
         * Average over 5 minutes
         *
         * @experimental
         */
        metricWriteIOPS(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The average number of disk write I/O operations per second.
         *
         * Average over 5 minutes
         *
         * @experimental
         */
        metricReadIOPS(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    }
}
