import * as ec2 from "../../aws-ec2";
import * as secretsmanager from "../../aws-secretsmanager";
import { IResource } from "../../core";
import { IClusterEngine } from './cluster-engine';
import { Endpoint } from './endpoint';
import { DatabaseProxy, DatabaseProxyOptions } from './proxy';
/**
 * (experimental) Create a clustered database with a given number of instances.
 *
 * @experimental
 */
export interface IDatabaseCluster extends IResource, ec2.IConnectable, secretsmanager.ISecretAttachmentTarget {
    /**
     * (experimental) Identifier of the cluster.
     *
     * @experimental
     */
    readonly clusterIdentifier: string;
    /**
     * (experimental) Identifiers of the replicas.
     *
     * @experimental
     */
    readonly instanceIdentifiers: string[];
    /**
     * (experimental) The endpoint to use for read/write operations.
     *
     * @experimental
     * @attribute EndpointAddress,EndpointPort
     */
    readonly clusterEndpoint: Endpoint;
    /**
     * (experimental) Endpoint to use for load-balanced read-only operations.
     *
     * @experimental
     * @attribute ReadEndpointAddress
     */
    readonly clusterReadEndpoint: Endpoint;
    /**
     * (experimental) Endpoints which address each individual replica.
     *
     * @experimental
     */
    readonly instanceEndpoints: Endpoint[];
    /**
     * (experimental) The engine of this Cluster.
     *
     * May be not known for imported Clusters if it wasn't provided explicitly.
     *
     * @experimental
     */
    readonly engine?: IClusterEngine;
    /**
     * (experimental) Add a new db proxy to this cluster.
     *
     * @experimental
     */
    addProxy(id: string, options: DatabaseProxyOptions): DatabaseProxy;
}
/**
 * (experimental) Properties that describe an existing cluster instance.
 *
 * @experimental
 */
export interface DatabaseClusterAttributes {
    /**
     * (experimental) Identifier for the cluster.
     *
     * @experimental
     */
    readonly clusterIdentifier: string;
    /**
     * (experimental) The database port.
     *
     * @default - none
     * @experimental
     */
    readonly port?: number;
    /**
     * (experimental) The security groups of the database cluster.
     *
     * @default - no security groups
     * @experimental
     */
    readonly securityGroups?: ec2.ISecurityGroup[];
    /**
     * (experimental) Identifier for the instances.
     *
     * @default - no instance identifiers
     * @experimental
     */
    readonly instanceIdentifiers?: string[];
    /**
     * (experimental) Cluster endpoint address.
     *
     * @default - no endpoint address
     * @experimental
     */
    readonly clusterEndpointAddress?: string;
    /**
     * (experimental) Reader endpoint address.
     *
     * @default - no reader address
     * @experimental
     */
    readonly readerEndpointAddress?: string;
    /**
     * (experimental) Endpoint addresses of individual instances.
     *
     * @default - no instance endpoints
     * @experimental
     */
    readonly instanceEndpointAddresses?: string[];
    /**
     * (experimental) The engine of the existing Cluster.
     *
     * @default - the imported Cluster's engine is unknown
     * @experimental
     */
    readonly engine?: IClusterEngine;
}
