import * as iam from "../../aws-iam";
import * as secretsmanager from "../../aws-secretsmanager";
import * as core from "../../core";
import { IEngine } from './engine';
import { IParameterGroup } from './parameter-group';
/**
 * (experimental) The extra options passed to the {@link IClusterEngine.bindToCluster} method.
 *
 * @experimental
 */
export interface ClusterEngineBindOptions {
    /**
     * (experimental) The role used for S3 importing.
     *
     * @default - none
     * @experimental
     */
    readonly s3ImportRole?: iam.IRole;
    /**
     * (experimental) The role used for S3 exporting.
     *
     * @default - none
     * @experimental
     */
    readonly s3ExportRole?: iam.IRole;
    /**
     * (experimental) The customer-provided ParameterGroup.
     *
     * @default - none
     * @experimental
     */
    readonly parameterGroup?: IParameterGroup;
}
/**
 * (experimental) The type returned from the {@link IClusterEngine.bindToCluster} method.
 *
 * @experimental
 */
export interface ClusterEngineConfig {
    /**
     * (experimental) The ParameterGroup to use for the cluster.
     *
     * @default - no ParameterGroup will be used
     * @experimental
     */
    readonly parameterGroup?: IParameterGroup;
    /**
     * (experimental) The port to use for this cluster, unless the customer specified the port directly.
     *
     * @default - use the default port for clusters (3306)
     * @experimental
     */
    readonly port?: number;
    /**
     * (experimental) Features supported by the database engine.
     *
     * @default - no features
     * @see https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DBEngineVersion.html
     * @experimental
     */
    readonly features?: ClusterEngineFeatures;
}
/**
 * (experimental) Represents Database Engine features.
 *
 * @experimental
 */
export interface ClusterEngineFeatures {
    /**
     * (experimental) Feature name for the DB instance that the IAM role to access the S3 bucket for import is to be associated with.
     *
     * @default - no s3Import feature name
     * @experimental
     */
    readonly s3Import?: string;
    /**
     * (experimental) Feature name for the DB instance that the IAM role to export to S3 bucket is to be associated with.
     *
     * @default - no s3Export feature name
     * @experimental
     */
    readonly s3Export?: string;
}
/**
 * (experimental) The interface representing a database cluster (as opposed to instance) engine.
 *
 * @experimental
 */
export interface IClusterEngine extends IEngine {
    /**
     * (experimental) The application used by this engine to perform rotation for a single-user scenario.
     *
     * @experimental
     */
    readonly singleUserRotationApplication: secretsmanager.SecretRotationApplication;
    /**
     * (experimental) The application used by this engine to perform rotation for a multi-user scenario.
     *
     * @experimental
     */
    readonly multiUserRotationApplication: secretsmanager.SecretRotationApplication;
    /**
     * (experimental) The log types that are available with this engine type.
     *
     * @experimental
     */
    readonly supportedLogTypes: string[];
    /**
     * (experimental) Method called when the engine is used to create a new cluster.
     *
     * @experimental
     */
    bindToCluster(scope: core.Construct, options: ClusterEngineBindOptions): ClusterEngineConfig;
}
/**
 * (experimental) The versions for the Aurora cluster engine (those returned by {@link DatabaseClusterEngine.aurora}).
 *
 * @experimental
 */
export declare class AuroraEngineVersion {
    /**
     * (experimental) Version "5.6.10a".
     *
     * @experimental
     */
    static readonly VER_10A: AuroraEngineVersion;
    /**
     * (experimental) Version "5.6.mysql_aurora.1.17.9".
     *
     * @experimental
     */
    static readonly VER_1_17_9: AuroraEngineVersion;
    /**
     * (experimental) Version "5.6.mysql_aurora.1.19.0".
     *
     * @experimental
     */
    static readonly VER_1_19_0: AuroraEngineVersion;
    /**
     * (experimental) Version "5.6.mysql_aurora.1.19.1".
     *
     * @experimental
     */
    static readonly VER_1_19_1: AuroraEngineVersion;
    /**
     * (experimental) Version "5.6.mysql_aurora.1.19.2".
     *
     * @experimental
     */
    static readonly VER_1_19_2: AuroraEngineVersion;
    /**
     * (experimental) Version "5.6.mysql_aurora.1.19.5".
     *
     * @experimental
     */
    static readonly VER_1_19_5: AuroraEngineVersion;
    /**
     * (experimental) Version "5.6.mysql_aurora.1.19.6".
     *
     * @experimental
     */
    static readonly VER_1_19_6: AuroraEngineVersion;
    /**
     * (experimental) Version "5.6.mysql_aurora.1.20.0".
     *
     * @experimental
     */
    static readonly VER_1_20_0: AuroraEngineVersion;
    /**
     * (experimental) Version "5.6.mysql_aurora.1.20.1".
     *
     * @experimental
     */
    static readonly VER_1_20_1: AuroraEngineVersion;
    /**
     * (experimental) Version "5.6.mysql_aurora.1.21.0".
     *
     * @experimental
     */
    static readonly VER_1_21_0: AuroraEngineVersion;
    /**
     * (experimental) Version "5.6.mysql_aurora.1.22.0".
     *
     * @experimental
     */
    static readonly VER_1_22_0: AuroraEngineVersion;
    /**
     * (experimental) Version "5.6.mysql_aurora.1.22.1".
     *
     * @experimental
     */
    static readonly VER_1_22_1: AuroraEngineVersion;
    /**
     * (experimental) Version "5.6.mysql_aurora.1.22.1.3".
     *
     * @experimental
     */
    static readonly VER_1_22_1_3: AuroraEngineVersion;
    /**
     * (experimental) Version "5.6.mysql_aurora.1.22.2".
     *
     * @experimental
     */
    static readonly VER_1_22_2: AuroraEngineVersion;
    /**
     * (experimental) Create a new AuroraEngineVersion with an arbitrary version.
     *
     * @param auroraFullVersion the full version string, for example "5.6.mysql_aurora.1.78.3.6".
     * @param auroraMajorVersion the major version of the engine, defaults to "5.6".
     * @experimental
     */
    static of(auroraFullVersion: string, auroraMajorVersion?: string): AuroraEngineVersion;
    private static builtIn_5_6;
    /**
     * (experimental) The full version string, for example, "5.6.mysql_aurora.1.78.3.6".
     *
     * @experimental
     */
    readonly auroraFullVersion: string;
    /**
     * (experimental) The major version of the engine.
     *
     * Currently, it's always "5.6".
     *
     * @experimental
     */
    readonly auroraMajorVersion: string;
    private constructor();
}
/**
 * (experimental) Creation properties of the plain Aurora database cluster engine.
 *
 * Used in {@link DatabaseClusterEngine.aurora}.
 *
 * @experimental
 */
export interface AuroraClusterEngineProps {
    /**
     * (experimental) The version of the Aurora cluster engine.
     *
     * @experimental
     */
    readonly version: AuroraEngineVersion;
}
/**
 * (experimental) The versions for the Aurora MySQL cluster engine (those returned by {@link DatabaseClusterEngine.auroraMysql}).
 *
 * @experimental
 */
export declare class AuroraMysqlEngineVersion {
    /**
     * (experimental) Version "5.7.12".
     *
     * @experimental
     */
    static readonly VER_5_7_12: AuroraMysqlEngineVersion;
    /**
     * (experimental) Version "5.7.mysql_aurora.2.03.2".
     *
     * @experimental
     */
    static readonly VER_2_03_2: AuroraMysqlEngineVersion;
    /**
     * (experimental) Version "5.7.mysql_aurora.2.03.3".
     *
     * @experimental
     */
    static readonly VER_2_03_3: AuroraMysqlEngineVersion;
    /**
     * (experimental) Version "5.7.mysql_aurora.2.03.4".
     *
     * @experimental
     */
    static readonly VER_2_03_4: AuroraMysqlEngineVersion;
    /**
     * (experimental) Version "5.7.mysql_aurora.2.04.0".
     *
     * @experimental
     */
    static readonly VER_2_04_0: AuroraMysqlEngineVersion;
    /**
     * (experimental) Version "5.7.mysql_aurora.2.04.1".
     *
     * @experimental
     */
    static readonly VER_2_04_1: AuroraMysqlEngineVersion;
    /**
     * (experimental) Version "5.7.mysql_aurora.2.04.2".
     *
     * @experimental
     */
    static readonly VER_2_04_2: AuroraMysqlEngineVersion;
    /**
     * (experimental) Version "5.7.mysql_aurora.2.04.3".
     *
     * @experimental
     */
    static readonly VER_2_04_3: AuroraMysqlEngineVersion;
    /**
     * (experimental) Version "5.7.mysql_aurora.2.04.4".
     *
     * @experimental
     */
    static readonly VER_2_04_4: AuroraMysqlEngineVersion;
    /**
     * (experimental) Version "5.7.mysql_aurora.2.04.5".
     *
     * @experimental
     */
    static readonly VER_2_04_5: AuroraMysqlEngineVersion;
    /**
     * (experimental) Version "5.7.mysql_aurora.2.04.6".
     *
     * @experimental
     */
    static readonly VER_2_04_6: AuroraMysqlEngineVersion;
    /**
     * (experimental) Version "5.7.mysql_aurora.2.04.7".
     *
     * @experimental
     */
    static readonly VER_2_04_7: AuroraMysqlEngineVersion;
    /**
     * (experimental) Version "5.7.mysql_aurora.2.04.8".
     *
     * @experimental
     */
    static readonly VER_2_04_8: AuroraMysqlEngineVersion;
    /**
     * (experimental) Version "5.7.mysql_aurora.2.05.0".
     *
     * @experimental
     */
    static readonly VER_2_05_0: AuroraMysqlEngineVersion;
    /**
     * (experimental) Version "5.7.mysql_aurora.2.06.0".
     *
     * @experimental
     */
    static readonly VER_2_06_0: AuroraMysqlEngineVersion;
    /**
     * (experimental) Version "5.7.mysql_aurora.2.07.0".
     *
     * @experimental
     */
    static readonly VER_2_07_0: AuroraMysqlEngineVersion;
    /**
     * (experimental) Version "5.7.mysql_aurora.2.07.1".
     *
     * @experimental
     */
    static readonly VER_2_07_1: AuroraMysqlEngineVersion;
    /**
     * (experimental) Version "5.7.mysql_aurora.2.07.2".
     *
     * @experimental
     */
    static readonly VER_2_07_2: AuroraMysqlEngineVersion;
    /**
     * (experimental) Version "5.7.mysql_aurora.2.08.0".
     *
     * @experimental
     */
    static readonly VER_2_08_0: AuroraMysqlEngineVersion;
    /**
     * (experimental) Version "5.7.mysql_aurora.2.08.1".
     *
     * @experimental
     */
    static readonly VER_2_08_1: AuroraMysqlEngineVersion;
    /**
     * (experimental) Version "5.7.mysql_aurora.2.08.2".
     *
     * @experimental
     */
    static readonly VER_2_08_2: AuroraMysqlEngineVersion;
    /**
     * (experimental) Version "5.7.mysql_aurora.2.09.0".
     *
     * @experimental
     */
    static readonly VER_2_09_0: AuroraMysqlEngineVersion;
    /**
     * (experimental) Create a new AuroraMysqlEngineVersion with an arbitrary version.
     *
     * @param auroraMysqlFullVersion the full version string, for example "5.7.mysql_aurora.2.78.3.6".
     * @param auroraMysqlMajorVersion the major version of the engine, defaults to "5.7".
     * @experimental
     */
    static of(auroraMysqlFullVersion: string, auroraMysqlMajorVersion?: string): AuroraMysqlEngineVersion;
    private static builtIn_5_7;
    /**
     * (experimental) The full version string, for example, "5.7.mysql_aurora.1.78.3.6".
     *
     * @experimental
     */
    readonly auroraMysqlFullVersion: string;
    /**
     * (experimental) The major version of the engine.
     *
     * Currently, it's always "5.7".
     *
     * @experimental
     */
    readonly auroraMysqlMajorVersion: string;
    private constructor();
}
/**
 * (experimental) Creation properties of the Aurora MySQL database cluster engine.
 *
 * Used in {@link DatabaseClusterEngine.auroraMysql}.
 *
 * @experimental
 */
export interface AuroraMysqlClusterEngineProps {
    /**
     * (experimental) The version of the Aurora MySQL cluster engine.
     *
     * @experimental
     */
    readonly version: AuroraMysqlEngineVersion;
}
/**
 * (experimental) Features supported by this version of the Aurora Postgres cluster engine.
 *
 * @experimental
 */
export interface AuroraPostgresEngineFeatures {
    /**
     * (experimental) Whether this version of the Aurora Postgres cluster engine supports the S3 data import feature.
     *
     * @default false
     * @experimental
     */
    readonly s3Import?: boolean;
    /**
     * (experimental) Whether this version of the Aurora Postgres cluster engine supports the S3 data import feature.
     *
     * @default false
     * @experimental
     */
    readonly s3Export?: boolean;
}
/**
 * (experimental) The versions for the Aurora PostgreSQL cluster engine (those returned by {@link DatabaseClusterEngine.auroraPostgres}).
 *
 * @experimental
 */
export declare class AuroraPostgresEngineVersion {
    /**
     * (experimental) Version "9.6.8".
     *
     * @experimental
     */
    static readonly VER_9_6_8: AuroraPostgresEngineVersion;
    /**
     * (experimental) Version "9.6.9".
     *
     * @experimental
     */
    static readonly VER_9_6_9: AuroraPostgresEngineVersion;
    /**
     * (experimental) Version "9.6.11".
     *
     * @experimental
     */
    static readonly VER_9_6_11: AuroraPostgresEngineVersion;
    /**
     * (experimental) Version "9.6.12".
     *
     * @experimental
     */
    static readonly VER_9_6_12: AuroraPostgresEngineVersion;
    /**
     * (experimental) Version "9.6.16".
     *
     * @experimental
     */
    static readonly VER_9_6_16: AuroraPostgresEngineVersion;
    /**
     * (experimental) Version "9.6.17".
     *
     * @experimental
     */
    static readonly VER_9_6_17: AuroraPostgresEngineVersion;
    /**
     * (experimental) Version "10.4".
     *
     * @experimental
     */
    static readonly VER_10_4: AuroraPostgresEngineVersion;
    /**
     * (experimental) Version "10.5".
     *
     * @experimental
     */
    static readonly VER_10_5: AuroraPostgresEngineVersion;
    /**
     * (experimental) Version "10.6".
     *
     * @experimental
     */
    static readonly VER_10_6: AuroraPostgresEngineVersion;
    /**
     * (experimental) Version "10.7".
     *
     * @experimental
     */
    static readonly VER_10_7: AuroraPostgresEngineVersion;
    /**
     * (experimental) Version "10.11".
     *
     * @experimental
     */
    static readonly VER_10_11: AuroraPostgresEngineVersion;
    /**
     * (experimental) Version "10.12".
     *
     * @experimental
     */
    static readonly VER_10_12: AuroraPostgresEngineVersion;
    /**
     * (experimental) Version "11.4".
     *
     * @experimental
     */
    static readonly VER_11_4: AuroraPostgresEngineVersion;
    /**
     * (experimental) Version "11.6".
     *
     * @experimental
     */
    static readonly VER_11_6: AuroraPostgresEngineVersion;
    /**
     * (experimental) Version "11.7".
     *
     * @experimental
     */
    static readonly VER_11_7: AuroraPostgresEngineVersion;
    /**
     * (experimental) Create a new AuroraPostgresEngineVersion with an arbitrary version.
     *
     * @param auroraPostgresFullVersion the full version string, for example "9.6.25.1".
     * @param auroraPostgresMajorVersion the major version of the engine, for example "9.6".
     * @experimental
     */
    static of(auroraPostgresFullVersion: string, auroraPostgresMajorVersion: string, auroraPostgresFeatures?: AuroraPostgresEngineFeatures): AuroraPostgresEngineVersion;
    /**
     * (experimental) The full version string, for example, "9.6.25.1".
     *
     * @experimental
     */
    readonly auroraPostgresFullVersion: string;
    /**
     * (experimental) The major version of the engine, for example, "9.6".
     *
     * @experimental
     */
    readonly auroraPostgresMajorVersion: string;
    private constructor();
}
/**
 * (experimental) Creation properties of the Aurora PostgreSQL database cluster engine.
 *
 * Used in {@link DatabaseClusterEngine.auroraPostgres}.
 *
 * @experimental
 */
export interface AuroraPostgresClusterEngineProps {
    /**
     * (experimental) The version of the Aurora PostgreSQL cluster engine.
     *
     * @experimental
     */
    readonly version: AuroraPostgresEngineVersion;
}
/**
 * (experimental) A database cluster engine.
 *
 * Provides mapping to the serverless application
 * used for secret rotation.
 *
 * @experimental
 */
export declare class DatabaseClusterEngine {
    /**
     * (experimental) The unversioned 'aurora' cluster engine.
     *
     * **Note**: we do not recommend using unversioned engines for non-serverless Clusters,
     *    as that can pose an availability risk.
     *    We recommend using versioned engines created using the {@link aurora()} method
     *
     * @experimental
     */
    static readonly AURORA: IClusterEngine;
    /**
     * (experimental) The unversioned 'aurora-msql' cluster engine.
     *
     * **Note**: we do not recommend using unversioned engines for non-serverless Clusters,
     *    as that can pose an availability risk.
     *    We recommend using versioned engines created using the {@link auroraMysql()} method
     *
     * @experimental
     */
    static readonly AURORA_MYSQL: IClusterEngine;
    /**
     * (experimental) The unversioned 'aurora-postgresql' cluster engine.
     *
     * **Note**: we do not recommend using unversioned engines for non-serverless Clusters,
     *    as that can pose an availability risk.
     *    We recommend using versioned engines created using the {@link auroraPostgres()} method
     *
     * @experimental
     */
    static readonly AURORA_POSTGRESQL: IClusterEngine;
    /**
     * (experimental) Creates a new plain Aurora database cluster engine.
     *
     * @experimental
     */
    static aurora(props: AuroraClusterEngineProps): IClusterEngine;
    /**
     * (experimental) Creates a new Aurora MySQL database cluster engine.
     *
     * @experimental
     */
    static auroraMysql(props: AuroraMysqlClusterEngineProps): IClusterEngine;
    /**
     * (experimental) Creates a new Aurora PostgreSQL database cluster engine.
     *
     * @experimental
     */
    static auroraPostgres(props: AuroraPostgresClusterEngineProps): IClusterEngine;
}
