import * as cdk from "../../core";
/**
 * Properties for defining a `AWS::Pinpoint::ADMChannel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-admchannel.html
 * @external
 */
export interface CfnADMChannelProps {
    /**
     * `AWS::Pinpoint::ADMChannel.ApplicationId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-admchannel.html#cfn-pinpoint-admchannel-applicationid
     * @external
     */
    readonly applicationId: string;
    /**
     * `AWS::Pinpoint::ADMChannel.ClientId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-admchannel.html#cfn-pinpoint-admchannel-clientid
     * @external
     */
    readonly clientId: string;
    /**
     * `AWS::Pinpoint::ADMChannel.ClientSecret`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-admchannel.html#cfn-pinpoint-admchannel-clientsecret
     * @external
     */
    readonly clientSecret: string;
    /**
     * `AWS::Pinpoint::ADMChannel.Enabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-admchannel.html#cfn-pinpoint-admchannel-enabled
     * @external
     */
    readonly enabled?: boolean | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Pinpoint::ADMChannel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-admchannel.html
 * @external
 * @cloudformationResource AWS::Pinpoint::ADMChannel
 */
export declare class CfnADMChannel extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Pinpoint::ADMChannel";
    /**
     * `AWS::Pinpoint::ADMChannel.ApplicationId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-admchannel.html#cfn-pinpoint-admchannel-applicationid
     * @external
     */
    applicationId: string;
    /**
     * `AWS::Pinpoint::ADMChannel.ClientId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-admchannel.html#cfn-pinpoint-admchannel-clientid
     * @external
     */
    clientId: string;
    /**
     * `AWS::Pinpoint::ADMChannel.ClientSecret`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-admchannel.html#cfn-pinpoint-admchannel-clientsecret
     * @external
     */
    clientSecret: string;
    /**
     * `AWS::Pinpoint::ADMChannel.Enabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-admchannel.html#cfn-pinpoint-admchannel-enabled
     * @external
     */
    enabled: boolean | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Pinpoint::ADMChannel`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnADMChannelProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Pinpoint::APNSChannel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html
 * @external
 */
export interface CfnAPNSChannelProps {
    /**
     * `AWS::Pinpoint::APNSChannel.ApplicationId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-applicationid
     * @external
     */
    readonly applicationId: string;
    /**
     * `AWS::Pinpoint::APNSChannel.BundleId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-bundleid
     * @external
     */
    readonly bundleId?: string;
    /**
     * `AWS::Pinpoint::APNSChannel.Certificate`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-certificate
     * @external
     */
    readonly certificate?: string;
    /**
     * `AWS::Pinpoint::APNSChannel.DefaultAuthenticationMethod`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-defaultauthenticationmethod
     * @external
     */
    readonly defaultAuthenticationMethod?: string;
    /**
     * `AWS::Pinpoint::APNSChannel.Enabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-enabled
     * @external
     */
    readonly enabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::APNSChannel.PrivateKey`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-privatekey
     * @external
     */
    readonly privateKey?: string;
    /**
     * `AWS::Pinpoint::APNSChannel.TeamId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-teamid
     * @external
     */
    readonly teamId?: string;
    /**
     * `AWS::Pinpoint::APNSChannel.TokenKey`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-tokenkey
     * @external
     */
    readonly tokenKey?: string;
    /**
     * `AWS::Pinpoint::APNSChannel.TokenKeyId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-tokenkeyid
     * @external
     */
    readonly tokenKeyId?: string;
}
/**
 * A CloudFormation `AWS::Pinpoint::APNSChannel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html
 * @external
 * @cloudformationResource AWS::Pinpoint::APNSChannel
 */
export declare class CfnAPNSChannel extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Pinpoint::APNSChannel";
    /**
     * `AWS::Pinpoint::APNSChannel.ApplicationId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-applicationid
     * @external
     */
    applicationId: string;
    /**
     * `AWS::Pinpoint::APNSChannel.BundleId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-bundleid
     * @external
     */
    bundleId: string | undefined;
    /**
     * `AWS::Pinpoint::APNSChannel.Certificate`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-certificate
     * @external
     */
    certificate: string | undefined;
    /**
     * `AWS::Pinpoint::APNSChannel.DefaultAuthenticationMethod`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-defaultauthenticationmethod
     * @external
     */
    defaultAuthenticationMethod: string | undefined;
    /**
     * `AWS::Pinpoint::APNSChannel.Enabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-enabled
     * @external
     */
    enabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::APNSChannel.PrivateKey`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-privatekey
     * @external
     */
    privateKey: string | undefined;
    /**
     * `AWS::Pinpoint::APNSChannel.TeamId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-teamid
     * @external
     */
    teamId: string | undefined;
    /**
     * `AWS::Pinpoint::APNSChannel.TokenKey`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-tokenkey
     * @external
     */
    tokenKey: string | undefined;
    /**
     * `AWS::Pinpoint::APNSChannel.TokenKeyId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-tokenkeyid
     * @external
     */
    tokenKeyId: string | undefined;
    /**
     * Create a new `AWS::Pinpoint::APNSChannel`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAPNSChannelProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Pinpoint::APNSSandboxChannel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html
 * @external
 */
export interface CfnAPNSSandboxChannelProps {
    /**
     * `AWS::Pinpoint::APNSSandboxChannel.ApplicationId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html#cfn-pinpoint-apnssandboxchannel-applicationid
     * @external
     */
    readonly applicationId: string;
    /**
     * `AWS::Pinpoint::APNSSandboxChannel.BundleId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html#cfn-pinpoint-apnssandboxchannel-bundleid
     * @external
     */
    readonly bundleId?: string;
    /**
     * `AWS::Pinpoint::APNSSandboxChannel.Certificate`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html#cfn-pinpoint-apnssandboxchannel-certificate
     * @external
     */
    readonly certificate?: string;
    /**
     * `AWS::Pinpoint::APNSSandboxChannel.DefaultAuthenticationMethod`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html#cfn-pinpoint-apnssandboxchannel-defaultauthenticationmethod
     * @external
     */
    readonly defaultAuthenticationMethod?: string;
    /**
     * `AWS::Pinpoint::APNSSandboxChannel.Enabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html#cfn-pinpoint-apnssandboxchannel-enabled
     * @external
     */
    readonly enabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::APNSSandboxChannel.PrivateKey`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html#cfn-pinpoint-apnssandboxchannel-privatekey
     * @external
     */
    readonly privateKey?: string;
    /**
     * `AWS::Pinpoint::APNSSandboxChannel.TeamId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html#cfn-pinpoint-apnssandboxchannel-teamid
     * @external
     */
    readonly teamId?: string;
    /**
     * `AWS::Pinpoint::APNSSandboxChannel.TokenKey`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html#cfn-pinpoint-apnssandboxchannel-tokenkey
     * @external
     */
    readonly tokenKey?: string;
    /**
     * `AWS::Pinpoint::APNSSandboxChannel.TokenKeyId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html#cfn-pinpoint-apnssandboxchannel-tokenkeyid
     * @external
     */
    readonly tokenKeyId?: string;
}
/**
 * A CloudFormation `AWS::Pinpoint::APNSSandboxChannel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html
 * @external
 * @cloudformationResource AWS::Pinpoint::APNSSandboxChannel
 */
export declare class CfnAPNSSandboxChannel extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Pinpoint::APNSSandboxChannel";
    /**
     * `AWS::Pinpoint::APNSSandboxChannel.ApplicationId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html#cfn-pinpoint-apnssandboxchannel-applicationid
     * @external
     */
    applicationId: string;
    /**
     * `AWS::Pinpoint::APNSSandboxChannel.BundleId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html#cfn-pinpoint-apnssandboxchannel-bundleid
     * @external
     */
    bundleId: string | undefined;
    /**
     * `AWS::Pinpoint::APNSSandboxChannel.Certificate`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html#cfn-pinpoint-apnssandboxchannel-certificate
     * @external
     */
    certificate: string | undefined;
    /**
     * `AWS::Pinpoint::APNSSandboxChannel.DefaultAuthenticationMethod`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html#cfn-pinpoint-apnssandboxchannel-defaultauthenticationmethod
     * @external
     */
    defaultAuthenticationMethod: string | undefined;
    /**
     * `AWS::Pinpoint::APNSSandboxChannel.Enabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html#cfn-pinpoint-apnssandboxchannel-enabled
     * @external
     */
    enabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::APNSSandboxChannel.PrivateKey`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html#cfn-pinpoint-apnssandboxchannel-privatekey
     * @external
     */
    privateKey: string | undefined;
    /**
     * `AWS::Pinpoint::APNSSandboxChannel.TeamId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html#cfn-pinpoint-apnssandboxchannel-teamid
     * @external
     */
    teamId: string | undefined;
    /**
     * `AWS::Pinpoint::APNSSandboxChannel.TokenKey`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html#cfn-pinpoint-apnssandboxchannel-tokenkey
     * @external
     */
    tokenKey: string | undefined;
    /**
     * `AWS::Pinpoint::APNSSandboxChannel.TokenKeyId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html#cfn-pinpoint-apnssandboxchannel-tokenkeyid
     * @external
     */
    tokenKeyId: string | undefined;
    /**
     * Create a new `AWS::Pinpoint::APNSSandboxChannel`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAPNSSandboxChannelProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Pinpoint::APNSVoipChannel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html
 * @external
 */
export interface CfnAPNSVoipChannelProps {
    /**
     * `AWS::Pinpoint::APNSVoipChannel.ApplicationId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html#cfn-pinpoint-apnsvoipchannel-applicationid
     * @external
     */
    readonly applicationId: string;
    /**
     * `AWS::Pinpoint::APNSVoipChannel.BundleId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html#cfn-pinpoint-apnsvoipchannel-bundleid
     * @external
     */
    readonly bundleId?: string;
    /**
     * `AWS::Pinpoint::APNSVoipChannel.Certificate`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html#cfn-pinpoint-apnsvoipchannel-certificate
     * @external
     */
    readonly certificate?: string;
    /**
     * `AWS::Pinpoint::APNSVoipChannel.DefaultAuthenticationMethod`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html#cfn-pinpoint-apnsvoipchannel-defaultauthenticationmethod
     * @external
     */
    readonly defaultAuthenticationMethod?: string;
    /**
     * `AWS::Pinpoint::APNSVoipChannel.Enabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html#cfn-pinpoint-apnsvoipchannel-enabled
     * @external
     */
    readonly enabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::APNSVoipChannel.PrivateKey`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html#cfn-pinpoint-apnsvoipchannel-privatekey
     * @external
     */
    readonly privateKey?: string;
    /**
     * `AWS::Pinpoint::APNSVoipChannel.TeamId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html#cfn-pinpoint-apnsvoipchannel-teamid
     * @external
     */
    readonly teamId?: string;
    /**
     * `AWS::Pinpoint::APNSVoipChannel.TokenKey`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html#cfn-pinpoint-apnsvoipchannel-tokenkey
     * @external
     */
    readonly tokenKey?: string;
    /**
     * `AWS::Pinpoint::APNSVoipChannel.TokenKeyId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html#cfn-pinpoint-apnsvoipchannel-tokenkeyid
     * @external
     */
    readonly tokenKeyId?: string;
}
/**
 * A CloudFormation `AWS::Pinpoint::APNSVoipChannel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html
 * @external
 * @cloudformationResource AWS::Pinpoint::APNSVoipChannel
 */
export declare class CfnAPNSVoipChannel extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Pinpoint::APNSVoipChannel";
    /**
     * `AWS::Pinpoint::APNSVoipChannel.ApplicationId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html#cfn-pinpoint-apnsvoipchannel-applicationid
     * @external
     */
    applicationId: string;
    /**
     * `AWS::Pinpoint::APNSVoipChannel.BundleId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html#cfn-pinpoint-apnsvoipchannel-bundleid
     * @external
     */
    bundleId: string | undefined;
    /**
     * `AWS::Pinpoint::APNSVoipChannel.Certificate`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html#cfn-pinpoint-apnsvoipchannel-certificate
     * @external
     */
    certificate: string | undefined;
    /**
     * `AWS::Pinpoint::APNSVoipChannel.DefaultAuthenticationMethod`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html#cfn-pinpoint-apnsvoipchannel-defaultauthenticationmethod
     * @external
     */
    defaultAuthenticationMethod: string | undefined;
    /**
     * `AWS::Pinpoint::APNSVoipChannel.Enabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html#cfn-pinpoint-apnsvoipchannel-enabled
     * @external
     */
    enabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::APNSVoipChannel.PrivateKey`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html#cfn-pinpoint-apnsvoipchannel-privatekey
     * @external
     */
    privateKey: string | undefined;
    /**
     * `AWS::Pinpoint::APNSVoipChannel.TeamId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html#cfn-pinpoint-apnsvoipchannel-teamid
     * @external
     */
    teamId: string | undefined;
    /**
     * `AWS::Pinpoint::APNSVoipChannel.TokenKey`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html#cfn-pinpoint-apnsvoipchannel-tokenkey
     * @external
     */
    tokenKey: string | undefined;
    /**
     * `AWS::Pinpoint::APNSVoipChannel.TokenKeyId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html#cfn-pinpoint-apnsvoipchannel-tokenkeyid
     * @external
     */
    tokenKeyId: string | undefined;
    /**
     * Create a new `AWS::Pinpoint::APNSVoipChannel`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAPNSVoipChannelProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Pinpoint::APNSVoipSandboxChannel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html
 * @external
 */
export interface CfnAPNSVoipSandboxChannelProps {
    /**
     * `AWS::Pinpoint::APNSVoipSandboxChannel.ApplicationId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html#cfn-pinpoint-apnsvoipsandboxchannel-applicationid
     * @external
     */
    readonly applicationId: string;
    /**
     * `AWS::Pinpoint::APNSVoipSandboxChannel.BundleId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html#cfn-pinpoint-apnsvoipsandboxchannel-bundleid
     * @external
     */
    readonly bundleId?: string;
    /**
     * `AWS::Pinpoint::APNSVoipSandboxChannel.Certificate`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html#cfn-pinpoint-apnsvoipsandboxchannel-certificate
     * @external
     */
    readonly certificate?: string;
    /**
     * `AWS::Pinpoint::APNSVoipSandboxChannel.DefaultAuthenticationMethod`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html#cfn-pinpoint-apnsvoipsandboxchannel-defaultauthenticationmethod
     * @external
     */
    readonly defaultAuthenticationMethod?: string;
    /**
     * `AWS::Pinpoint::APNSVoipSandboxChannel.Enabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html#cfn-pinpoint-apnsvoipsandboxchannel-enabled
     * @external
     */
    readonly enabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::APNSVoipSandboxChannel.PrivateKey`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html#cfn-pinpoint-apnsvoipsandboxchannel-privatekey
     * @external
     */
    readonly privateKey?: string;
    /**
     * `AWS::Pinpoint::APNSVoipSandboxChannel.TeamId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html#cfn-pinpoint-apnsvoipsandboxchannel-teamid
     * @external
     */
    readonly teamId?: string;
    /**
     * `AWS::Pinpoint::APNSVoipSandboxChannel.TokenKey`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html#cfn-pinpoint-apnsvoipsandboxchannel-tokenkey
     * @external
     */
    readonly tokenKey?: string;
    /**
     * `AWS::Pinpoint::APNSVoipSandboxChannel.TokenKeyId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html#cfn-pinpoint-apnsvoipsandboxchannel-tokenkeyid
     * @external
     */
    readonly tokenKeyId?: string;
}
/**
 * A CloudFormation `AWS::Pinpoint::APNSVoipSandboxChannel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html
 * @external
 * @cloudformationResource AWS::Pinpoint::APNSVoipSandboxChannel
 */
export declare class CfnAPNSVoipSandboxChannel extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Pinpoint::APNSVoipSandboxChannel";
    /**
     * `AWS::Pinpoint::APNSVoipSandboxChannel.ApplicationId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html#cfn-pinpoint-apnsvoipsandboxchannel-applicationid
     * @external
     */
    applicationId: string;
    /**
     * `AWS::Pinpoint::APNSVoipSandboxChannel.BundleId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html#cfn-pinpoint-apnsvoipsandboxchannel-bundleid
     * @external
     */
    bundleId: string | undefined;
    /**
     * `AWS::Pinpoint::APNSVoipSandboxChannel.Certificate`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html#cfn-pinpoint-apnsvoipsandboxchannel-certificate
     * @external
     */
    certificate: string | undefined;
    /**
     * `AWS::Pinpoint::APNSVoipSandboxChannel.DefaultAuthenticationMethod`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html#cfn-pinpoint-apnsvoipsandboxchannel-defaultauthenticationmethod
     * @external
     */
    defaultAuthenticationMethod: string | undefined;
    /**
     * `AWS::Pinpoint::APNSVoipSandboxChannel.Enabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html#cfn-pinpoint-apnsvoipsandboxchannel-enabled
     * @external
     */
    enabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::APNSVoipSandboxChannel.PrivateKey`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html#cfn-pinpoint-apnsvoipsandboxchannel-privatekey
     * @external
     */
    privateKey: string | undefined;
    /**
     * `AWS::Pinpoint::APNSVoipSandboxChannel.TeamId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html#cfn-pinpoint-apnsvoipsandboxchannel-teamid
     * @external
     */
    teamId: string | undefined;
    /**
     * `AWS::Pinpoint::APNSVoipSandboxChannel.TokenKey`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html#cfn-pinpoint-apnsvoipsandboxchannel-tokenkey
     * @external
     */
    tokenKey: string | undefined;
    /**
     * `AWS::Pinpoint::APNSVoipSandboxChannel.TokenKeyId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html#cfn-pinpoint-apnsvoipsandboxchannel-tokenkeyid
     * @external
     */
    tokenKeyId: string | undefined;
    /**
     * Create a new `AWS::Pinpoint::APNSVoipSandboxChannel`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAPNSVoipSandboxChannelProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Pinpoint::App`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-app.html
 * @external
 */
export interface CfnAppProps {
    /**
     * `AWS::Pinpoint::App.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-app.html#cfn-pinpoint-app-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::Pinpoint::App.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-app.html#cfn-pinpoint-app-tags
     * @external
     */
    readonly tags?: any;
}
/**
 * A CloudFormation `AWS::Pinpoint::App`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-app.html
 * @external
 * @cloudformationResource AWS::Pinpoint::App
 */
export declare class CfnApp extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Pinpoint::App";
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::Pinpoint::App.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-app.html#cfn-pinpoint-app-name
     * @external
     */
    name: string;
    /**
     * `AWS::Pinpoint::App.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-app.html#cfn-pinpoint-app-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Pinpoint::App`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAppProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Pinpoint::ApplicationSettings`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-applicationsettings.html
 * @external
 */
export interface CfnApplicationSettingsProps {
    /**
     * `AWS::Pinpoint::ApplicationSettings.ApplicationId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-applicationsettings.html#cfn-pinpoint-applicationsettings-applicationid
     * @external
     */
    readonly applicationId: string;
    /**
     * `AWS::Pinpoint::ApplicationSettings.CampaignHook`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-applicationsettings.html#cfn-pinpoint-applicationsettings-campaignhook
     * @external
     */
    readonly campaignHook?: CfnApplicationSettings.CampaignHookProperty | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::ApplicationSettings.CloudWatchMetricsEnabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-applicationsettings.html#cfn-pinpoint-applicationsettings-cloudwatchmetricsenabled
     * @external
     */
    readonly cloudWatchMetricsEnabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::ApplicationSettings.Limits`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-applicationsettings.html#cfn-pinpoint-applicationsettings-limits
     * @external
     */
    readonly limits?: CfnApplicationSettings.LimitsProperty | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::ApplicationSettings.QuietTime`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-applicationsettings.html#cfn-pinpoint-applicationsettings-quiettime
     * @external
     */
    readonly quietTime?: CfnApplicationSettings.QuietTimeProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Pinpoint::ApplicationSettings`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-applicationsettings.html
 * @external
 * @cloudformationResource AWS::Pinpoint::ApplicationSettings
 */
export declare class CfnApplicationSettings extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Pinpoint::ApplicationSettings";
    /**
     * `AWS::Pinpoint::ApplicationSettings.ApplicationId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-applicationsettings.html#cfn-pinpoint-applicationsettings-applicationid
     * @external
     */
    applicationId: string;
    /**
     * `AWS::Pinpoint::ApplicationSettings.CampaignHook`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-applicationsettings.html#cfn-pinpoint-applicationsettings-campaignhook
     * @external
     */
    campaignHook: CfnApplicationSettings.CampaignHookProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::ApplicationSettings.CloudWatchMetricsEnabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-applicationsettings.html#cfn-pinpoint-applicationsettings-cloudwatchmetricsenabled
     * @external
     */
    cloudWatchMetricsEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::ApplicationSettings.Limits`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-applicationsettings.html#cfn-pinpoint-applicationsettings-limits
     * @external
     */
    limits: CfnApplicationSettings.LimitsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::ApplicationSettings.QuietTime`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-applicationsettings.html#cfn-pinpoint-applicationsettings-quiettime
     * @external
     */
    quietTime: CfnApplicationSettings.QuietTimeProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Pinpoint::ApplicationSettings`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnApplicationSettingsProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Pinpoint::ApplicationSettings`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-applicationsettings.html
 * @external
 * @cloudformationResource AWS::Pinpoint::ApplicationSettings
 */
export declare namespace CfnApplicationSettings {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-applicationsettings-campaignhook.html
     * @external
     */
    interface CampaignHookProperty {
        /**
         * `CfnApplicationSettings.CampaignHookProperty.LambdaFunctionName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-applicationsettings-campaignhook.html#cfn-pinpoint-applicationsettings-campaignhook-lambdafunctionname
         * @external
         */
        readonly lambdaFunctionName?: string;
        /**
         * `CfnApplicationSettings.CampaignHookProperty.Mode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-applicationsettings-campaignhook.html#cfn-pinpoint-applicationsettings-campaignhook-mode
         * @external
         */
        readonly mode?: string;
        /**
         * `CfnApplicationSettings.CampaignHookProperty.WebUrl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-applicationsettings-campaignhook.html#cfn-pinpoint-applicationsettings-campaignhook-weburl
         * @external
         */
        readonly webUrl?: string;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::ApplicationSettings`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-applicationsettings.html
 * @external
 * @cloudformationResource AWS::Pinpoint::ApplicationSettings
 */
export declare namespace CfnApplicationSettings {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-applicationsettings-limits.html
     * @external
     */
    interface LimitsProperty {
        /**
         * `CfnApplicationSettings.LimitsProperty.Daily`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-applicationsettings-limits.html#cfn-pinpoint-applicationsettings-limits-daily
         * @external
         */
        readonly daily?: number;
        /**
         * `CfnApplicationSettings.LimitsProperty.MaximumDuration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-applicationsettings-limits.html#cfn-pinpoint-applicationsettings-limits-maximumduration
         * @external
         */
        readonly maximumDuration?: number;
        /**
         * `CfnApplicationSettings.LimitsProperty.MessagesPerSecond`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-applicationsettings-limits.html#cfn-pinpoint-applicationsettings-limits-messagespersecond
         * @external
         */
        readonly messagesPerSecond?: number;
        /**
         * `CfnApplicationSettings.LimitsProperty.Total`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-applicationsettings-limits.html#cfn-pinpoint-applicationsettings-limits-total
         * @external
         */
        readonly total?: number;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::ApplicationSettings`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-applicationsettings.html
 * @external
 * @cloudformationResource AWS::Pinpoint::ApplicationSettings
 */
export declare namespace CfnApplicationSettings {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-applicationsettings-quiettime.html
     * @external
     */
    interface QuietTimeProperty {
        /**
         * `CfnApplicationSettings.QuietTimeProperty.End`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-applicationsettings-quiettime.html#cfn-pinpoint-applicationsettings-quiettime-end
         * @external
         */
        readonly end: string;
        /**
         * `CfnApplicationSettings.QuietTimeProperty.Start`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-applicationsettings-quiettime.html#cfn-pinpoint-applicationsettings-quiettime-start
         * @external
         */
        readonly start: string;
    }
}
/**
 * Properties for defining a `AWS::Pinpoint::BaiduChannel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-baiduchannel.html
 * @external
 */
export interface CfnBaiduChannelProps {
    /**
     * `AWS::Pinpoint::BaiduChannel.ApiKey`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-baiduchannel.html#cfn-pinpoint-baiduchannel-apikey
     * @external
     */
    readonly apiKey: string;
    /**
     * `AWS::Pinpoint::BaiduChannel.ApplicationId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-baiduchannel.html#cfn-pinpoint-baiduchannel-applicationid
     * @external
     */
    readonly applicationId: string;
    /**
     * `AWS::Pinpoint::BaiduChannel.SecretKey`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-baiduchannel.html#cfn-pinpoint-baiduchannel-secretkey
     * @external
     */
    readonly secretKey: string;
    /**
     * `AWS::Pinpoint::BaiduChannel.Enabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-baiduchannel.html#cfn-pinpoint-baiduchannel-enabled
     * @external
     */
    readonly enabled?: boolean | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Pinpoint::BaiduChannel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-baiduchannel.html
 * @external
 * @cloudformationResource AWS::Pinpoint::BaiduChannel
 */
export declare class CfnBaiduChannel extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Pinpoint::BaiduChannel";
    /**
     * `AWS::Pinpoint::BaiduChannel.ApiKey`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-baiduchannel.html#cfn-pinpoint-baiduchannel-apikey
     * @external
     */
    apiKey: string;
    /**
     * `AWS::Pinpoint::BaiduChannel.ApplicationId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-baiduchannel.html#cfn-pinpoint-baiduchannel-applicationid
     * @external
     */
    applicationId: string;
    /**
     * `AWS::Pinpoint::BaiduChannel.SecretKey`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-baiduchannel.html#cfn-pinpoint-baiduchannel-secretkey
     * @external
     */
    secretKey: string;
    /**
     * `AWS::Pinpoint::BaiduChannel.Enabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-baiduchannel.html#cfn-pinpoint-baiduchannel-enabled
     * @external
     */
    enabled: boolean | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Pinpoint::BaiduChannel`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnBaiduChannelProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Pinpoint::Campaign`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html
 * @external
 */
export interface CfnCampaignProps {
    /**
     * `AWS::Pinpoint::Campaign.ApplicationId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-applicationid
     * @external
     */
    readonly applicationId: string;
    /**
     * `AWS::Pinpoint::Campaign.MessageConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-messageconfiguration
     * @external
     */
    readonly messageConfiguration: CfnCampaign.MessageConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::Campaign.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::Pinpoint::Campaign.Schedule`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-schedule
     * @external
     */
    readonly schedule: CfnCampaign.ScheduleProperty | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::Campaign.SegmentId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-segmentid
     * @external
     */
    readonly segmentId: string;
    /**
     * `AWS::Pinpoint::Campaign.AdditionalTreatments`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-additionaltreatments
     * @external
     */
    readonly additionalTreatments?: Array<CfnCampaign.WriteTreatmentResourceProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::Campaign.CampaignHook`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-campaignhook
     * @external
     */
    readonly campaignHook?: CfnCampaign.CampaignHookProperty | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::Campaign.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::Pinpoint::Campaign.HoldoutPercent`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-holdoutpercent
     * @external
     */
    readonly holdoutPercent?: number;
    /**
     * `AWS::Pinpoint::Campaign.IsPaused`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-ispaused
     * @external
     */
    readonly isPaused?: boolean | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::Campaign.Limits`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-limits
     * @external
     */
    readonly limits?: CfnCampaign.LimitsProperty | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::Campaign.SegmentVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-segmentversion
     * @external
     */
    readonly segmentVersion?: number;
    /**
     * `AWS::Pinpoint::Campaign.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-tags
     * @external
     */
    readonly tags?: any;
    /**
     * `AWS::Pinpoint::Campaign.TreatmentDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-treatmentdescription
     * @external
     */
    readonly treatmentDescription?: string;
    /**
     * `AWS::Pinpoint::Campaign.TreatmentName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-treatmentname
     * @external
     */
    readonly treatmentName?: string;
}
/**
 * A CloudFormation `AWS::Pinpoint::Campaign`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html
 * @external
 * @cloudformationResource AWS::Pinpoint::Campaign
 */
export declare class CfnCampaign extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Pinpoint::Campaign";
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute CampaignId
     */
    readonly attrCampaignId: string;
    /**
     * `AWS::Pinpoint::Campaign.ApplicationId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-applicationid
     * @external
     */
    applicationId: string;
    /**
     * `AWS::Pinpoint::Campaign.MessageConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-messageconfiguration
     * @external
     */
    messageConfiguration: CfnCampaign.MessageConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::Campaign.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-name
     * @external
     */
    name: string;
    /**
     * `AWS::Pinpoint::Campaign.Schedule`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-schedule
     * @external
     */
    schedule: CfnCampaign.ScheduleProperty | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::Campaign.SegmentId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-segmentid
     * @external
     */
    segmentId: string;
    /**
     * `AWS::Pinpoint::Campaign.AdditionalTreatments`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-additionaltreatments
     * @external
     */
    additionalTreatments: Array<CfnCampaign.WriteTreatmentResourceProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::Campaign.CampaignHook`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-campaignhook
     * @external
     */
    campaignHook: CfnCampaign.CampaignHookProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::Campaign.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::Pinpoint::Campaign.HoldoutPercent`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-holdoutpercent
     * @external
     */
    holdoutPercent: number | undefined;
    /**
     * `AWS::Pinpoint::Campaign.IsPaused`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-ispaused
     * @external
     */
    isPaused: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::Campaign.Limits`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-limits
     * @external
     */
    limits: CfnCampaign.LimitsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::Campaign.SegmentVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-segmentversion
     * @external
     */
    segmentVersion: number | undefined;
    /**
     * `AWS::Pinpoint::Campaign.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::Pinpoint::Campaign.TreatmentDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-treatmentdescription
     * @external
     */
    treatmentDescription: string | undefined;
    /**
     * `AWS::Pinpoint::Campaign.TreatmentName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-treatmentname
     * @external
     */
    treatmentName: string | undefined;
    /**
     * Create a new `AWS::Pinpoint::Campaign`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnCampaignProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Pinpoint::Campaign`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html
 * @external
 * @cloudformationResource AWS::Pinpoint::Campaign
 */
export declare namespace CfnCampaign {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-attributedimension.html
     * @external
     */
    interface AttributeDimensionProperty {
        /**
         * `CfnCampaign.AttributeDimensionProperty.AttributeType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-attributedimension.html#cfn-pinpoint-campaign-attributedimension-attributetype
         * @external
         */
        readonly attributeType?: string;
        /**
         * `CfnCampaign.AttributeDimensionProperty.Values`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-attributedimension.html#cfn-pinpoint-campaign-attributedimension-values
         * @external
         */
        readonly values?: string[];
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::Campaign`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html
 * @external
 * @cloudformationResource AWS::Pinpoint::Campaign
 */
export declare namespace CfnCampaign {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-campaignemailmessage.html
     * @external
     */
    interface CampaignEmailMessageProperty {
        /**
         * `CfnCampaign.CampaignEmailMessageProperty.Body`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-campaignemailmessage.html#cfn-pinpoint-campaign-campaignemailmessage-body
         * @external
         */
        readonly body?: string;
        /**
         * `CfnCampaign.CampaignEmailMessageProperty.FromAddress`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-campaignemailmessage.html#cfn-pinpoint-campaign-campaignemailmessage-fromaddress
         * @external
         */
        readonly fromAddress?: string;
        /**
         * `CfnCampaign.CampaignEmailMessageProperty.HtmlBody`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-campaignemailmessage.html#cfn-pinpoint-campaign-campaignemailmessage-htmlbody
         * @external
         */
        readonly htmlBody?: string;
        /**
         * `CfnCampaign.CampaignEmailMessageProperty.Title`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-campaignemailmessage.html#cfn-pinpoint-campaign-campaignemailmessage-title
         * @external
         */
        readonly title?: string;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::Campaign`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html
 * @external
 * @cloudformationResource AWS::Pinpoint::Campaign
 */
export declare namespace CfnCampaign {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-campaigneventfilter.html
     * @external
     */
    interface CampaignEventFilterProperty {
        /**
         * `CfnCampaign.CampaignEventFilterProperty.Dimensions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-campaigneventfilter.html#cfn-pinpoint-campaign-campaigneventfilter-dimensions
         * @external
         */
        readonly dimensions?: CfnCampaign.EventDimensionsProperty | cdk.IResolvable;
        /**
         * `CfnCampaign.CampaignEventFilterProperty.FilterType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-campaigneventfilter.html#cfn-pinpoint-campaign-campaigneventfilter-filtertype
         * @external
         */
        readonly filterType?: string;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::Campaign`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html
 * @external
 * @cloudformationResource AWS::Pinpoint::Campaign
 */
export declare namespace CfnCampaign {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-campaignhook.html
     * @external
     */
    interface CampaignHookProperty {
        /**
         * `CfnCampaign.CampaignHookProperty.LambdaFunctionName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-campaignhook.html#cfn-pinpoint-campaign-campaignhook-lambdafunctionname
         * @external
         */
        readonly lambdaFunctionName?: string;
        /**
         * `CfnCampaign.CampaignHookProperty.Mode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-campaignhook.html#cfn-pinpoint-campaign-campaignhook-mode
         * @external
         */
        readonly mode?: string;
        /**
         * `CfnCampaign.CampaignHookProperty.WebUrl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-campaignhook.html#cfn-pinpoint-campaign-campaignhook-weburl
         * @external
         */
        readonly webUrl?: string;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::Campaign`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html
 * @external
 * @cloudformationResource AWS::Pinpoint::Campaign
 */
export declare namespace CfnCampaign {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-campaignsmsmessage.html
     * @external
     */
    interface CampaignSmsMessageProperty {
        /**
         * `CfnCampaign.CampaignSmsMessageProperty.Body`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-campaignsmsmessage.html#cfn-pinpoint-campaign-campaignsmsmessage-body
         * @external
         */
        readonly body?: string;
        /**
         * `CfnCampaign.CampaignSmsMessageProperty.MessageType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-campaignsmsmessage.html#cfn-pinpoint-campaign-campaignsmsmessage-messagetype
         * @external
         */
        readonly messageType?: string;
        /**
         * `CfnCampaign.CampaignSmsMessageProperty.SenderId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-campaignsmsmessage.html#cfn-pinpoint-campaign-campaignsmsmessage-senderid
         * @external
         */
        readonly senderId?: string;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::Campaign`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html
 * @external
 * @cloudformationResource AWS::Pinpoint::Campaign
 */
export declare namespace CfnCampaign {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-eventdimensions.html
     * @external
     */
    interface EventDimensionsProperty {
        /**
         * `CfnCampaign.EventDimensionsProperty.Attributes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-eventdimensions.html#cfn-pinpoint-campaign-eventdimensions-attributes
         * @external
         */
        readonly attributes?: any | cdk.IResolvable;
        /**
         * `CfnCampaign.EventDimensionsProperty.EventType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-eventdimensions.html#cfn-pinpoint-campaign-eventdimensions-eventtype
         * @external
         */
        readonly eventType?: CfnCampaign.SetDimensionProperty | cdk.IResolvable;
        /**
         * `CfnCampaign.EventDimensionsProperty.Metrics`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-eventdimensions.html#cfn-pinpoint-campaign-eventdimensions-metrics
         * @external
         */
        readonly metrics?: any | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::Campaign`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html
 * @external
 * @cloudformationResource AWS::Pinpoint::Campaign
 */
export declare namespace CfnCampaign {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-limits.html
     * @external
     */
    interface LimitsProperty {
        /**
         * `CfnCampaign.LimitsProperty.Daily`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-limits.html#cfn-pinpoint-campaign-limits-daily
         * @external
         */
        readonly daily?: number;
        /**
         * `CfnCampaign.LimitsProperty.MaximumDuration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-limits.html#cfn-pinpoint-campaign-limits-maximumduration
         * @external
         */
        readonly maximumDuration?: number;
        /**
         * `CfnCampaign.LimitsProperty.MessagesPerSecond`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-limits.html#cfn-pinpoint-campaign-limits-messagespersecond
         * @external
         */
        readonly messagesPerSecond?: number;
        /**
         * `CfnCampaign.LimitsProperty.Total`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-limits.html#cfn-pinpoint-campaign-limits-total
         * @external
         */
        readonly total?: number;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::Campaign`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html
 * @external
 * @cloudformationResource AWS::Pinpoint::Campaign
 */
export declare namespace CfnCampaign {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-message.html
     * @external
     */
    interface MessageProperty {
        /**
         * `CfnCampaign.MessageProperty.Action`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-message.html#cfn-pinpoint-campaign-message-action
         * @external
         */
        readonly action?: string;
        /**
         * `CfnCampaign.MessageProperty.Body`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-message.html#cfn-pinpoint-campaign-message-body
         * @external
         */
        readonly body?: string;
        /**
         * `CfnCampaign.MessageProperty.ImageIconUrl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-message.html#cfn-pinpoint-campaign-message-imageiconurl
         * @external
         */
        readonly imageIconUrl?: string;
        /**
         * `CfnCampaign.MessageProperty.ImageSmallIconUrl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-message.html#cfn-pinpoint-campaign-message-imagesmalliconurl
         * @external
         */
        readonly imageSmallIconUrl?: string;
        /**
         * `CfnCampaign.MessageProperty.ImageUrl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-message.html#cfn-pinpoint-campaign-message-imageurl
         * @external
         */
        readonly imageUrl?: string;
        /**
         * `CfnCampaign.MessageProperty.JsonBody`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-message.html#cfn-pinpoint-campaign-message-jsonbody
         * @external
         */
        readonly jsonBody?: string;
        /**
         * `CfnCampaign.MessageProperty.MediaUrl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-message.html#cfn-pinpoint-campaign-message-mediaurl
         * @external
         */
        readonly mediaUrl?: string;
        /**
         * `CfnCampaign.MessageProperty.RawContent`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-message.html#cfn-pinpoint-campaign-message-rawcontent
         * @external
         */
        readonly rawContent?: string;
        /**
         * `CfnCampaign.MessageProperty.SilentPush`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-message.html#cfn-pinpoint-campaign-message-silentpush
         * @external
         */
        readonly silentPush?: boolean | cdk.IResolvable;
        /**
         * `CfnCampaign.MessageProperty.TimeToLive`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-message.html#cfn-pinpoint-campaign-message-timetolive
         * @external
         */
        readonly timeToLive?: number;
        /**
         * `CfnCampaign.MessageProperty.Title`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-message.html#cfn-pinpoint-campaign-message-title
         * @external
         */
        readonly title?: string;
        /**
         * `CfnCampaign.MessageProperty.Url`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-message.html#cfn-pinpoint-campaign-message-url
         * @external
         */
        readonly url?: string;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::Campaign`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html
 * @external
 * @cloudformationResource AWS::Pinpoint::Campaign
 */
export declare namespace CfnCampaign {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-messageconfiguration.html
     * @external
     */
    interface MessageConfigurationProperty {
        /**
         * `CfnCampaign.MessageConfigurationProperty.ADMMessage`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-messageconfiguration.html#cfn-pinpoint-campaign-messageconfiguration-admmessage
         * @external
         */
        readonly admMessage?: CfnCampaign.MessageProperty | cdk.IResolvable;
        /**
         * `CfnCampaign.MessageConfigurationProperty.APNSMessage`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-messageconfiguration.html#cfn-pinpoint-campaign-messageconfiguration-apnsmessage
         * @external
         */
        readonly apnsMessage?: CfnCampaign.MessageProperty | cdk.IResolvable;
        /**
         * `CfnCampaign.MessageConfigurationProperty.BaiduMessage`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-messageconfiguration.html#cfn-pinpoint-campaign-messageconfiguration-baidumessage
         * @external
         */
        readonly baiduMessage?: CfnCampaign.MessageProperty | cdk.IResolvable;
        /**
         * `CfnCampaign.MessageConfigurationProperty.DefaultMessage`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-messageconfiguration.html#cfn-pinpoint-campaign-messageconfiguration-defaultmessage
         * @external
         */
        readonly defaultMessage?: CfnCampaign.MessageProperty | cdk.IResolvable;
        /**
         * `CfnCampaign.MessageConfigurationProperty.EmailMessage`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-messageconfiguration.html#cfn-pinpoint-campaign-messageconfiguration-emailmessage
         * @external
         */
        readonly emailMessage?: CfnCampaign.CampaignEmailMessageProperty | cdk.IResolvable;
        /**
         * `CfnCampaign.MessageConfigurationProperty.GCMMessage`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-messageconfiguration.html#cfn-pinpoint-campaign-messageconfiguration-gcmmessage
         * @external
         */
        readonly gcmMessage?: CfnCampaign.MessageProperty | cdk.IResolvable;
        /**
         * `CfnCampaign.MessageConfigurationProperty.SMSMessage`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-messageconfiguration.html#cfn-pinpoint-campaign-messageconfiguration-smsmessage
         * @external
         */
        readonly smsMessage?: CfnCampaign.CampaignSmsMessageProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::Campaign`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html
 * @external
 * @cloudformationResource AWS::Pinpoint::Campaign
 */
export declare namespace CfnCampaign {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-metricdimension.html
     * @external
     */
    interface MetricDimensionProperty {
        /**
         * `CfnCampaign.MetricDimensionProperty.ComparisonOperator`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-metricdimension.html#cfn-pinpoint-campaign-metricdimension-comparisonoperator
         * @external
         */
        readonly comparisonOperator?: string;
        /**
         * `CfnCampaign.MetricDimensionProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-metricdimension.html#cfn-pinpoint-campaign-metricdimension-value
         * @external
         */
        readonly value?: number;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::Campaign`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html
 * @external
 * @cloudformationResource AWS::Pinpoint::Campaign
 */
export declare namespace CfnCampaign {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-schedule-quiettime.html
     * @external
     */
    interface QuietTimeProperty {
        /**
         * `CfnCampaign.QuietTimeProperty.End`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-schedule-quiettime.html#cfn-pinpoint-campaign-schedule-quiettime-end
         * @external
         */
        readonly end: string;
        /**
         * `CfnCampaign.QuietTimeProperty.Start`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-schedule-quiettime.html#cfn-pinpoint-campaign-schedule-quiettime-start
         * @external
         */
        readonly start: string;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::Campaign`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html
 * @external
 * @cloudformationResource AWS::Pinpoint::Campaign
 */
export declare namespace CfnCampaign {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-schedule.html
     * @external
     */
    interface ScheduleProperty {
        /**
         * `CfnCampaign.ScheduleProperty.EndTime`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-schedule.html#cfn-pinpoint-campaign-schedule-endtime
         * @external
         */
        readonly endTime?: string;
        /**
         * `CfnCampaign.ScheduleProperty.EventFilter`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-schedule.html#cfn-pinpoint-campaign-schedule-eventfilter
         * @external
         */
        readonly eventFilter?: CfnCampaign.CampaignEventFilterProperty | cdk.IResolvable;
        /**
         * `CfnCampaign.ScheduleProperty.Frequency`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-schedule.html#cfn-pinpoint-campaign-schedule-frequency
         * @external
         */
        readonly frequency?: string;
        /**
         * `CfnCampaign.ScheduleProperty.IsLocalTime`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-schedule.html#cfn-pinpoint-campaign-schedule-islocaltime
         * @external
         */
        readonly isLocalTime?: boolean | cdk.IResolvable;
        /**
         * `CfnCampaign.ScheduleProperty.QuietTime`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-schedule.html#cfn-pinpoint-campaign-schedule-quiettime
         * @external
         */
        readonly quietTime?: CfnCampaign.QuietTimeProperty | cdk.IResolvable;
        /**
         * `CfnCampaign.ScheduleProperty.StartTime`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-schedule.html#cfn-pinpoint-campaign-schedule-starttime
         * @external
         */
        readonly startTime?: string;
        /**
         * `CfnCampaign.ScheduleProperty.TimeZone`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-schedule.html#cfn-pinpoint-campaign-schedule-timezone
         * @external
         */
        readonly timeZone?: string;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::Campaign`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html
 * @external
 * @cloudformationResource AWS::Pinpoint::Campaign
 */
export declare namespace CfnCampaign {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-setdimension.html
     * @external
     */
    interface SetDimensionProperty {
        /**
         * `CfnCampaign.SetDimensionProperty.DimensionType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-setdimension.html#cfn-pinpoint-campaign-setdimension-dimensiontype
         * @external
         */
        readonly dimensionType?: string;
        /**
         * `CfnCampaign.SetDimensionProperty.Values`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-setdimension.html#cfn-pinpoint-campaign-setdimension-values
         * @external
         */
        readonly values?: string[];
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::Campaign`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html
 * @external
 * @cloudformationResource AWS::Pinpoint::Campaign
 */
export declare namespace CfnCampaign {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-writetreatmentresource.html
     * @external
     */
    interface WriteTreatmentResourceProperty {
        /**
         * `CfnCampaign.WriteTreatmentResourceProperty.MessageConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-writetreatmentresource.html#cfn-pinpoint-campaign-writetreatmentresource-messageconfiguration
         * @external
         */
        readonly messageConfiguration?: CfnCampaign.MessageConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnCampaign.WriteTreatmentResourceProperty.Schedule`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-writetreatmentresource.html#cfn-pinpoint-campaign-writetreatmentresource-schedule
         * @external
         */
        readonly schedule?: CfnCampaign.ScheduleProperty | cdk.IResolvable;
        /**
         * `CfnCampaign.WriteTreatmentResourceProperty.SizePercent`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-writetreatmentresource.html#cfn-pinpoint-campaign-writetreatmentresource-sizepercent
         * @external
         */
        readonly sizePercent?: number;
        /**
         * `CfnCampaign.WriteTreatmentResourceProperty.TreatmentDescription`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-writetreatmentresource.html#cfn-pinpoint-campaign-writetreatmentresource-treatmentdescription
         * @external
         */
        readonly treatmentDescription?: string;
        /**
         * `CfnCampaign.WriteTreatmentResourceProperty.TreatmentName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-writetreatmentresource.html#cfn-pinpoint-campaign-writetreatmentresource-treatmentname
         * @external
         */
        readonly treatmentName?: string;
    }
}
/**
 * Properties for defining a `AWS::Pinpoint::EmailChannel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailchannel.html
 * @external
 */
export interface CfnEmailChannelProps {
    /**
     * `AWS::Pinpoint::EmailChannel.ApplicationId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailchannel.html#cfn-pinpoint-emailchannel-applicationid
     * @external
     */
    readonly applicationId: string;
    /**
     * `AWS::Pinpoint::EmailChannel.FromAddress`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailchannel.html#cfn-pinpoint-emailchannel-fromaddress
     * @external
     */
    readonly fromAddress: string;
    /**
     * `AWS::Pinpoint::EmailChannel.Identity`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailchannel.html#cfn-pinpoint-emailchannel-identity
     * @external
     */
    readonly identity: string;
    /**
     * `AWS::Pinpoint::EmailChannel.ConfigurationSet`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailchannel.html#cfn-pinpoint-emailchannel-configurationset
     * @external
     */
    readonly configurationSet?: string;
    /**
     * `AWS::Pinpoint::EmailChannel.Enabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailchannel.html#cfn-pinpoint-emailchannel-enabled
     * @external
     */
    readonly enabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::EmailChannel.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailchannel.html#cfn-pinpoint-emailchannel-rolearn
     * @external
     */
    readonly roleArn?: string;
}
/**
 * A CloudFormation `AWS::Pinpoint::EmailChannel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailchannel.html
 * @external
 * @cloudformationResource AWS::Pinpoint::EmailChannel
 */
export declare class CfnEmailChannel extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Pinpoint::EmailChannel";
    /**
     * `AWS::Pinpoint::EmailChannel.ApplicationId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailchannel.html#cfn-pinpoint-emailchannel-applicationid
     * @external
     */
    applicationId: string;
    /**
     * `AWS::Pinpoint::EmailChannel.FromAddress`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailchannel.html#cfn-pinpoint-emailchannel-fromaddress
     * @external
     */
    fromAddress: string;
    /**
     * `AWS::Pinpoint::EmailChannel.Identity`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailchannel.html#cfn-pinpoint-emailchannel-identity
     * @external
     */
    identity: string;
    /**
     * `AWS::Pinpoint::EmailChannel.ConfigurationSet`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailchannel.html#cfn-pinpoint-emailchannel-configurationset
     * @external
     */
    configurationSet: string | undefined;
    /**
     * `AWS::Pinpoint::EmailChannel.Enabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailchannel.html#cfn-pinpoint-emailchannel-enabled
     * @external
     */
    enabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::EmailChannel.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailchannel.html#cfn-pinpoint-emailchannel-rolearn
     * @external
     */
    roleArn: string | undefined;
    /**
     * Create a new `AWS::Pinpoint::EmailChannel`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnEmailChannelProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Pinpoint::EmailTemplate`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html
 * @external
 */
export interface CfnEmailTemplateProps {
    /**
     * `AWS::Pinpoint::EmailTemplate.Subject`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html#cfn-pinpoint-emailtemplate-subject
     * @external
     */
    readonly subject: string;
    /**
     * `AWS::Pinpoint::EmailTemplate.TemplateName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html#cfn-pinpoint-emailtemplate-templatename
     * @external
     */
    readonly templateName: string;
    /**
     * `AWS::Pinpoint::EmailTemplate.DefaultSubstitutions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html#cfn-pinpoint-emailtemplate-defaultsubstitutions
     * @external
     */
    readonly defaultSubstitutions?: string;
    /**
     * `AWS::Pinpoint::EmailTemplate.HtmlPart`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html#cfn-pinpoint-emailtemplate-htmlpart
     * @external
     */
    readonly htmlPart?: string;
    /**
     * `AWS::Pinpoint::EmailTemplate.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html#cfn-pinpoint-emailtemplate-tags
     * @external
     */
    readonly tags?: any;
    /**
     * `AWS::Pinpoint::EmailTemplate.TemplateDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html#cfn-pinpoint-emailtemplate-templatedescription
     * @external
     */
    readonly templateDescription?: string;
    /**
     * `AWS::Pinpoint::EmailTemplate.TextPart`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html#cfn-pinpoint-emailtemplate-textpart
     * @external
     */
    readonly textPart?: string;
}
/**
 * A CloudFormation `AWS::Pinpoint::EmailTemplate`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html
 * @external
 * @cloudformationResource AWS::Pinpoint::EmailTemplate
 */
export declare class CfnEmailTemplate extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Pinpoint::EmailTemplate";
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::Pinpoint::EmailTemplate.Subject`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html#cfn-pinpoint-emailtemplate-subject
     * @external
     */
    subject: string;
    /**
     * `AWS::Pinpoint::EmailTemplate.TemplateName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html#cfn-pinpoint-emailtemplate-templatename
     * @external
     */
    templateName: string;
    /**
     * `AWS::Pinpoint::EmailTemplate.DefaultSubstitutions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html#cfn-pinpoint-emailtemplate-defaultsubstitutions
     * @external
     */
    defaultSubstitutions: string | undefined;
    /**
     * `AWS::Pinpoint::EmailTemplate.HtmlPart`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html#cfn-pinpoint-emailtemplate-htmlpart
     * @external
     */
    htmlPart: string | undefined;
    /**
     * `AWS::Pinpoint::EmailTemplate.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html#cfn-pinpoint-emailtemplate-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::Pinpoint::EmailTemplate.TemplateDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html#cfn-pinpoint-emailtemplate-templatedescription
     * @external
     */
    templateDescription: string | undefined;
    /**
     * `AWS::Pinpoint::EmailTemplate.TextPart`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html#cfn-pinpoint-emailtemplate-textpart
     * @external
     */
    textPart: string | undefined;
    /**
     * Create a new `AWS::Pinpoint::EmailTemplate`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnEmailTemplateProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Pinpoint::EventStream`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-eventstream.html
 * @external
 */
export interface CfnEventStreamProps {
    /**
     * `AWS::Pinpoint::EventStream.ApplicationId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-eventstream.html#cfn-pinpoint-eventstream-applicationid
     * @external
     */
    readonly applicationId: string;
    /**
     * `AWS::Pinpoint::EventStream.DestinationStreamArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-eventstream.html#cfn-pinpoint-eventstream-destinationstreamarn
     * @external
     */
    readonly destinationStreamArn: string;
    /**
     * `AWS::Pinpoint::EventStream.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-eventstream.html#cfn-pinpoint-eventstream-rolearn
     * @external
     */
    readonly roleArn: string;
}
/**
 * A CloudFormation `AWS::Pinpoint::EventStream`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-eventstream.html
 * @external
 * @cloudformationResource AWS::Pinpoint::EventStream
 */
export declare class CfnEventStream extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Pinpoint::EventStream";
    /**
     * `AWS::Pinpoint::EventStream.ApplicationId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-eventstream.html#cfn-pinpoint-eventstream-applicationid
     * @external
     */
    applicationId: string;
    /**
     * `AWS::Pinpoint::EventStream.DestinationStreamArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-eventstream.html#cfn-pinpoint-eventstream-destinationstreamarn
     * @external
     */
    destinationStreamArn: string;
    /**
     * `AWS::Pinpoint::EventStream.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-eventstream.html#cfn-pinpoint-eventstream-rolearn
     * @external
     */
    roleArn: string;
    /**
     * Create a new `AWS::Pinpoint::EventStream`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnEventStreamProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Pinpoint::GCMChannel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-gcmchannel.html
 * @external
 */
export interface CfnGCMChannelProps {
    /**
     * `AWS::Pinpoint::GCMChannel.ApiKey`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-gcmchannel.html#cfn-pinpoint-gcmchannel-apikey
     * @external
     */
    readonly apiKey: string;
    /**
     * `AWS::Pinpoint::GCMChannel.ApplicationId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-gcmchannel.html#cfn-pinpoint-gcmchannel-applicationid
     * @external
     */
    readonly applicationId: string;
    /**
     * `AWS::Pinpoint::GCMChannel.Enabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-gcmchannel.html#cfn-pinpoint-gcmchannel-enabled
     * @external
     */
    readonly enabled?: boolean | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Pinpoint::GCMChannel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-gcmchannel.html
 * @external
 * @cloudformationResource AWS::Pinpoint::GCMChannel
 */
export declare class CfnGCMChannel extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Pinpoint::GCMChannel";
    /**
     * `AWS::Pinpoint::GCMChannel.ApiKey`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-gcmchannel.html#cfn-pinpoint-gcmchannel-apikey
     * @external
     */
    apiKey: string;
    /**
     * `AWS::Pinpoint::GCMChannel.ApplicationId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-gcmchannel.html#cfn-pinpoint-gcmchannel-applicationid
     * @external
     */
    applicationId: string;
    /**
     * `AWS::Pinpoint::GCMChannel.Enabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-gcmchannel.html#cfn-pinpoint-gcmchannel-enabled
     * @external
     */
    enabled: boolean | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Pinpoint::GCMChannel`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnGCMChannelProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Pinpoint::PushTemplate`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html
 * @external
 */
export interface CfnPushTemplateProps {
    /**
     * `AWS::Pinpoint::PushTemplate.TemplateName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-templatename
     * @external
     */
    readonly templateName: string;
    /**
     * `AWS::Pinpoint::PushTemplate.ADM`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-adm
     * @external
     */
    readonly adm?: CfnPushTemplate.AndroidPushNotificationTemplateProperty | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::PushTemplate.APNS`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-apns
     * @external
     */
    readonly apns?: CfnPushTemplate.APNSPushNotificationTemplateProperty | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::PushTemplate.Baidu`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-baidu
     * @external
     */
    readonly baidu?: CfnPushTemplate.AndroidPushNotificationTemplateProperty | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::PushTemplate.Default`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-default
     * @external
     */
    readonly default?: CfnPushTemplate.DefaultPushNotificationTemplateProperty | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::PushTemplate.DefaultSubstitutions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-defaultsubstitutions
     * @external
     */
    readonly defaultSubstitutions?: string;
    /**
     * `AWS::Pinpoint::PushTemplate.GCM`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-gcm
     * @external
     */
    readonly gcm?: CfnPushTemplate.AndroidPushNotificationTemplateProperty | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::PushTemplate.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-tags
     * @external
     */
    readonly tags?: any;
    /**
     * `AWS::Pinpoint::PushTemplate.TemplateDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-templatedescription
     * @external
     */
    readonly templateDescription?: string;
}
/**
 * A CloudFormation `AWS::Pinpoint::PushTemplate`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html
 * @external
 * @cloudformationResource AWS::Pinpoint::PushTemplate
 */
export declare class CfnPushTemplate extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Pinpoint::PushTemplate";
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::Pinpoint::PushTemplate.TemplateName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-templatename
     * @external
     */
    templateName: string;
    /**
     * `AWS::Pinpoint::PushTemplate.ADM`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-adm
     * @external
     */
    adm: CfnPushTemplate.AndroidPushNotificationTemplateProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::PushTemplate.APNS`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-apns
     * @external
     */
    apns: CfnPushTemplate.APNSPushNotificationTemplateProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::PushTemplate.Baidu`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-baidu
     * @external
     */
    baidu: CfnPushTemplate.AndroidPushNotificationTemplateProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::PushTemplate.Default`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-default
     * @external
     */
    default: CfnPushTemplate.DefaultPushNotificationTemplateProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::PushTemplate.DefaultSubstitutions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-defaultsubstitutions
     * @external
     */
    defaultSubstitutions: string | undefined;
    /**
     * `AWS::Pinpoint::PushTemplate.GCM`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-gcm
     * @external
     */
    gcm: CfnPushTemplate.AndroidPushNotificationTemplateProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::PushTemplate.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::Pinpoint::PushTemplate.TemplateDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-templatedescription
     * @external
     */
    templateDescription: string | undefined;
    /**
     * Create a new `AWS::Pinpoint::PushTemplate`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnPushTemplateProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Pinpoint::PushTemplate`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html
 * @external
 * @cloudformationResource AWS::Pinpoint::PushTemplate
 */
export declare namespace CfnPushTemplate {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-apnspushnotificationtemplate.html
     * @external
     */
    interface APNSPushNotificationTemplateProperty {
        /**
         * `CfnPushTemplate.APNSPushNotificationTemplateProperty.Action`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-apnspushnotificationtemplate.html#cfn-pinpoint-pushtemplate-apnspushnotificationtemplate-action
         * @external
         */
        readonly action?: string;
        /**
         * `CfnPushTemplate.APNSPushNotificationTemplateProperty.Body`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-apnspushnotificationtemplate.html#cfn-pinpoint-pushtemplate-apnspushnotificationtemplate-body
         * @external
         */
        readonly body?: string;
        /**
         * `CfnPushTemplate.APNSPushNotificationTemplateProperty.MediaUrl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-apnspushnotificationtemplate.html#cfn-pinpoint-pushtemplate-apnspushnotificationtemplate-mediaurl
         * @external
         */
        readonly mediaUrl?: string;
        /**
         * `CfnPushTemplate.APNSPushNotificationTemplateProperty.Sound`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-apnspushnotificationtemplate.html#cfn-pinpoint-pushtemplate-apnspushnotificationtemplate-sound
         * @external
         */
        readonly sound?: string;
        /**
         * `CfnPushTemplate.APNSPushNotificationTemplateProperty.Title`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-apnspushnotificationtemplate.html#cfn-pinpoint-pushtemplate-apnspushnotificationtemplate-title
         * @external
         */
        readonly title?: string;
        /**
         * `CfnPushTemplate.APNSPushNotificationTemplateProperty.Url`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-apnspushnotificationtemplate.html#cfn-pinpoint-pushtemplate-apnspushnotificationtemplate-url
         * @external
         */
        readonly url?: string;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::PushTemplate`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html
 * @external
 * @cloudformationResource AWS::Pinpoint::PushTemplate
 */
export declare namespace CfnPushTemplate {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-androidpushnotificationtemplate.html
     * @external
     */
    interface AndroidPushNotificationTemplateProperty {
        /**
         * `CfnPushTemplate.AndroidPushNotificationTemplateProperty.Action`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-androidpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-androidpushnotificationtemplate-action
         * @external
         */
        readonly action?: string;
        /**
         * `CfnPushTemplate.AndroidPushNotificationTemplateProperty.Body`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-androidpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-androidpushnotificationtemplate-body
         * @external
         */
        readonly body?: string;
        /**
         * `CfnPushTemplate.AndroidPushNotificationTemplateProperty.ImageIconUrl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-androidpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-androidpushnotificationtemplate-imageiconurl
         * @external
         */
        readonly imageIconUrl?: string;
        /**
         * `CfnPushTemplate.AndroidPushNotificationTemplateProperty.ImageUrl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-androidpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-androidpushnotificationtemplate-imageurl
         * @external
         */
        readonly imageUrl?: string;
        /**
         * `CfnPushTemplate.AndroidPushNotificationTemplateProperty.SmallImageIconUrl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-androidpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-androidpushnotificationtemplate-smallimageiconurl
         * @external
         */
        readonly smallImageIconUrl?: string;
        /**
         * `CfnPushTemplate.AndroidPushNotificationTemplateProperty.Sound`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-androidpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-androidpushnotificationtemplate-sound
         * @external
         */
        readonly sound?: string;
        /**
         * `CfnPushTemplate.AndroidPushNotificationTemplateProperty.Title`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-androidpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-androidpushnotificationtemplate-title
         * @external
         */
        readonly title?: string;
        /**
         * `CfnPushTemplate.AndroidPushNotificationTemplateProperty.Url`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-androidpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-androidpushnotificationtemplate-url
         * @external
         */
        readonly url?: string;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::PushTemplate`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html
 * @external
 * @cloudformationResource AWS::Pinpoint::PushTemplate
 */
export declare namespace CfnPushTemplate {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-defaultpushnotificationtemplate.html
     * @external
     */
    interface DefaultPushNotificationTemplateProperty {
        /**
         * `CfnPushTemplate.DefaultPushNotificationTemplateProperty.Action`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-defaultpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-defaultpushnotificationtemplate-action
         * @external
         */
        readonly action?: string;
        /**
         * `CfnPushTemplate.DefaultPushNotificationTemplateProperty.Body`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-defaultpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-defaultpushnotificationtemplate-body
         * @external
         */
        readonly body?: string;
        /**
         * `CfnPushTemplate.DefaultPushNotificationTemplateProperty.Sound`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-defaultpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-defaultpushnotificationtemplate-sound
         * @external
         */
        readonly sound?: string;
        /**
         * `CfnPushTemplate.DefaultPushNotificationTemplateProperty.Title`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-defaultpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-defaultpushnotificationtemplate-title
         * @external
         */
        readonly title?: string;
        /**
         * `CfnPushTemplate.DefaultPushNotificationTemplateProperty.Url`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-defaultpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-defaultpushnotificationtemplate-url
         * @external
         */
        readonly url?: string;
    }
}
/**
 * Properties for defining a `AWS::Pinpoint::SMSChannel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smschannel.html
 * @external
 */
export interface CfnSMSChannelProps {
    /**
     * `AWS::Pinpoint::SMSChannel.ApplicationId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smschannel.html#cfn-pinpoint-smschannel-applicationid
     * @external
     */
    readonly applicationId: string;
    /**
     * `AWS::Pinpoint::SMSChannel.Enabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smschannel.html#cfn-pinpoint-smschannel-enabled
     * @external
     */
    readonly enabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::SMSChannel.SenderId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smschannel.html#cfn-pinpoint-smschannel-senderid
     * @external
     */
    readonly senderId?: string;
    /**
     * `AWS::Pinpoint::SMSChannel.ShortCode`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smschannel.html#cfn-pinpoint-smschannel-shortcode
     * @external
     */
    readonly shortCode?: string;
}
/**
 * A CloudFormation `AWS::Pinpoint::SMSChannel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smschannel.html
 * @external
 * @cloudformationResource AWS::Pinpoint::SMSChannel
 */
export declare class CfnSMSChannel extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Pinpoint::SMSChannel";
    /**
     * `AWS::Pinpoint::SMSChannel.ApplicationId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smschannel.html#cfn-pinpoint-smschannel-applicationid
     * @external
     */
    applicationId: string;
    /**
     * `AWS::Pinpoint::SMSChannel.Enabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smschannel.html#cfn-pinpoint-smschannel-enabled
     * @external
     */
    enabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::SMSChannel.SenderId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smschannel.html#cfn-pinpoint-smschannel-senderid
     * @external
     */
    senderId: string | undefined;
    /**
     * `AWS::Pinpoint::SMSChannel.ShortCode`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smschannel.html#cfn-pinpoint-smschannel-shortcode
     * @external
     */
    shortCode: string | undefined;
    /**
     * Create a new `AWS::Pinpoint::SMSChannel`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSMSChannelProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Pinpoint::Segment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html
 * @external
 */
export interface CfnSegmentProps {
    /**
     * `AWS::Pinpoint::Segment.ApplicationId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html#cfn-pinpoint-segment-applicationid
     * @external
     */
    readonly applicationId: string;
    /**
     * `AWS::Pinpoint::Segment.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html#cfn-pinpoint-segment-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::Pinpoint::Segment.Dimensions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html#cfn-pinpoint-segment-dimensions
     * @external
     */
    readonly dimensions?: CfnSegment.SegmentDimensionsProperty | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::Segment.SegmentGroups`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html#cfn-pinpoint-segment-segmentgroups
     * @external
     */
    readonly segmentGroups?: CfnSegment.SegmentGroupsProperty | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::Segment.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html#cfn-pinpoint-segment-tags
     * @external
     */
    readonly tags?: any;
}
/**
 * A CloudFormation `AWS::Pinpoint::Segment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html
 * @external
 * @cloudformationResource AWS::Pinpoint::Segment
 */
export declare class CfnSegment extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Pinpoint::Segment";
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute SegmentId
     */
    readonly attrSegmentId: string;
    /**
     * `AWS::Pinpoint::Segment.ApplicationId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html#cfn-pinpoint-segment-applicationid
     * @external
     */
    applicationId: string;
    /**
     * `AWS::Pinpoint::Segment.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html#cfn-pinpoint-segment-name
     * @external
     */
    name: string;
    /**
     * `AWS::Pinpoint::Segment.Dimensions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html#cfn-pinpoint-segment-dimensions
     * @external
     */
    dimensions: CfnSegment.SegmentDimensionsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::Segment.SegmentGroups`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html#cfn-pinpoint-segment-segmentgroups
     * @external
     */
    segmentGroups: CfnSegment.SegmentGroupsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::Segment.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html#cfn-pinpoint-segment-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Pinpoint::Segment`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSegmentProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Pinpoint::Segment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html
 * @external
 * @cloudformationResource AWS::Pinpoint::Segment
 */
export declare namespace CfnSegment {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-attributedimension.html
     * @external
     */
    interface AttributeDimensionProperty {
        /**
         * `CfnSegment.AttributeDimensionProperty.AttributeType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-attributedimension.html#cfn-pinpoint-segment-attributedimension-attributetype
         * @external
         */
        readonly attributeType?: string;
        /**
         * `CfnSegment.AttributeDimensionProperty.Values`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-attributedimension.html#cfn-pinpoint-segment-attributedimension-values
         * @external
         */
        readonly values?: string[];
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::Segment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html
 * @external
 * @cloudformationResource AWS::Pinpoint::Segment
 */
export declare namespace CfnSegment {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-behavior.html
     * @external
     */
    interface BehaviorProperty {
        /**
         * `CfnSegment.BehaviorProperty.Recency`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-behavior.html#cfn-pinpoint-segment-segmentdimensions-behavior-recency
         * @external
         */
        readonly recency?: CfnSegment.RecencyProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::Segment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html
 * @external
 * @cloudformationResource AWS::Pinpoint::Segment
 */
export declare namespace CfnSegment {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-location-gpspoint-coordinates.html
     * @external
     */
    interface CoordinatesProperty {
        /**
         * `CfnSegment.CoordinatesProperty.Latitude`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-location-gpspoint-coordinates.html#cfn-pinpoint-segment-segmentdimensions-location-gpspoint-coordinates-latitude
         * @external
         */
        readonly latitude: number;
        /**
         * `CfnSegment.CoordinatesProperty.Longitude`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-location-gpspoint-coordinates.html#cfn-pinpoint-segment-segmentdimensions-location-gpspoint-coordinates-longitude
         * @external
         */
        readonly longitude: number;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::Segment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html
 * @external
 * @cloudformationResource AWS::Pinpoint::Segment
 */
export declare namespace CfnSegment {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-demographic.html
     * @external
     */
    interface DemographicProperty {
        /**
         * `CfnSegment.DemographicProperty.AppVersion`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-demographic.html#cfn-pinpoint-segment-segmentdimensions-demographic-appversion
         * @external
         */
        readonly appVersion?: CfnSegment.SetDimensionProperty | cdk.IResolvable;
        /**
         * `CfnSegment.DemographicProperty.Channel`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-demographic.html#cfn-pinpoint-segment-segmentdimensions-demographic-channel
         * @external
         */
        readonly channel?: CfnSegment.SetDimensionProperty | cdk.IResolvable;
        /**
         * `CfnSegment.DemographicProperty.DeviceType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-demographic.html#cfn-pinpoint-segment-segmentdimensions-demographic-devicetype
         * @external
         */
        readonly deviceType?: CfnSegment.SetDimensionProperty | cdk.IResolvable;
        /**
         * `CfnSegment.DemographicProperty.Make`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-demographic.html#cfn-pinpoint-segment-segmentdimensions-demographic-make
         * @external
         */
        readonly make?: CfnSegment.SetDimensionProperty | cdk.IResolvable;
        /**
         * `CfnSegment.DemographicProperty.Model`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-demographic.html#cfn-pinpoint-segment-segmentdimensions-demographic-model
         * @external
         */
        readonly model?: CfnSegment.SetDimensionProperty | cdk.IResolvable;
        /**
         * `CfnSegment.DemographicProperty.Platform`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-demographic.html#cfn-pinpoint-segment-segmentdimensions-demographic-platform
         * @external
         */
        readonly platform?: CfnSegment.SetDimensionProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::Segment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html
 * @external
 * @cloudformationResource AWS::Pinpoint::Segment
 */
export declare namespace CfnSegment {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-location-gpspoint.html
     * @external
     */
    interface GPSPointProperty {
        /**
         * `CfnSegment.GPSPointProperty.Coordinates`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-location-gpspoint.html#cfn-pinpoint-segment-segmentdimensions-location-gpspoint-coordinates
         * @external
         */
        readonly coordinates: CfnSegment.CoordinatesProperty | cdk.IResolvable;
        /**
         * `CfnSegment.GPSPointProperty.RangeInKilometers`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-location-gpspoint.html#cfn-pinpoint-segment-segmentdimensions-location-gpspoint-rangeinkilometers
         * @external
         */
        readonly rangeInKilometers: number;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::Segment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html
 * @external
 * @cloudformationResource AWS::Pinpoint::Segment
 */
export declare namespace CfnSegment {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentgroups-groups.html
     * @external
     */
    interface GroupsProperty {
        /**
         * `CfnSegment.GroupsProperty.Dimensions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentgroups-groups.html#cfn-pinpoint-segment-segmentgroups-groups-dimensions
         * @external
         */
        readonly dimensions?: Array<CfnSegment.SegmentDimensionsProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnSegment.GroupsProperty.SourceSegments`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentgroups-groups.html#cfn-pinpoint-segment-segmentgroups-groups-sourcesegments
         * @external
         */
        readonly sourceSegments?: Array<CfnSegment.SourceSegmentsProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnSegment.GroupsProperty.SourceType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentgroups-groups.html#cfn-pinpoint-segment-segmentgroups-groups-sourcetype
         * @external
         */
        readonly sourceType?: string;
        /**
         * `CfnSegment.GroupsProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentgroups-groups.html#cfn-pinpoint-segment-segmentgroups-groups-type
         * @external
         */
        readonly type?: string;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::Segment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html
 * @external
 * @cloudformationResource AWS::Pinpoint::Segment
 */
export declare namespace CfnSegment {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-location.html
     * @external
     */
    interface LocationProperty {
        /**
         * `CfnSegment.LocationProperty.Country`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-location.html#cfn-pinpoint-segment-segmentdimensions-location-country
         * @external
         */
        readonly country?: CfnSegment.SetDimensionProperty | cdk.IResolvable;
        /**
         * `CfnSegment.LocationProperty.GPSPoint`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-location.html#cfn-pinpoint-segment-segmentdimensions-location-gpspoint
         * @external
         */
        readonly gpsPoint?: CfnSegment.GPSPointProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::Segment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html
 * @external
 * @cloudformationResource AWS::Pinpoint::Segment
 */
export declare namespace CfnSegment {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-behavior-recency.html
     * @external
     */
    interface RecencyProperty {
        /**
         * `CfnSegment.RecencyProperty.Duration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-behavior-recency.html#cfn-pinpoint-segment-segmentdimensions-behavior-recency-duration
         * @external
         */
        readonly duration: string;
        /**
         * `CfnSegment.RecencyProperty.RecencyType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-behavior-recency.html#cfn-pinpoint-segment-segmentdimensions-behavior-recency-recencytype
         * @external
         */
        readonly recencyType: string;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::Segment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html
 * @external
 * @cloudformationResource AWS::Pinpoint::Segment
 */
export declare namespace CfnSegment {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions.html
     * @external
     */
    interface SegmentDimensionsProperty {
        /**
         * `CfnSegment.SegmentDimensionsProperty.Attributes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions.html#cfn-pinpoint-segment-segmentdimensions-attributes
         * @external
         */
        readonly attributes?: any | cdk.IResolvable;
        /**
         * `CfnSegment.SegmentDimensionsProperty.Behavior`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions.html#cfn-pinpoint-segment-segmentdimensions-behavior
         * @external
         */
        readonly behavior?: CfnSegment.BehaviorProperty | cdk.IResolvable;
        /**
         * `CfnSegment.SegmentDimensionsProperty.Demographic`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions.html#cfn-pinpoint-segment-segmentdimensions-demographic
         * @external
         */
        readonly demographic?: CfnSegment.DemographicProperty | cdk.IResolvable;
        /**
         * `CfnSegment.SegmentDimensionsProperty.Location`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions.html#cfn-pinpoint-segment-segmentdimensions-location
         * @external
         */
        readonly location?: CfnSegment.LocationProperty | cdk.IResolvable;
        /**
         * `CfnSegment.SegmentDimensionsProperty.Metrics`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions.html#cfn-pinpoint-segment-segmentdimensions-metrics
         * @external
         */
        readonly metrics?: any | cdk.IResolvable;
        /**
         * `CfnSegment.SegmentDimensionsProperty.UserAttributes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions.html#cfn-pinpoint-segment-segmentdimensions-userattributes
         * @external
         */
        readonly userAttributes?: any | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::Segment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html
 * @external
 * @cloudformationResource AWS::Pinpoint::Segment
 */
export declare namespace CfnSegment {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentgroups.html
     * @external
     */
    interface SegmentGroupsProperty {
        /**
         * `CfnSegment.SegmentGroupsProperty.Groups`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentgroups.html#cfn-pinpoint-segment-segmentgroups-groups
         * @external
         */
        readonly groups?: Array<CfnSegment.GroupsProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnSegment.SegmentGroupsProperty.Include`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentgroups.html#cfn-pinpoint-segment-segmentgroups-include
         * @external
         */
        readonly include?: string;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::Segment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html
 * @external
 * @cloudformationResource AWS::Pinpoint::Segment
 */
export declare namespace CfnSegment {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-setdimension.html
     * @external
     */
    interface SetDimensionProperty {
        /**
         * `CfnSegment.SetDimensionProperty.DimensionType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-setdimension.html#cfn-pinpoint-segment-setdimension-dimensiontype
         * @external
         */
        readonly dimensionType?: string;
        /**
         * `CfnSegment.SetDimensionProperty.Values`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-setdimension.html#cfn-pinpoint-segment-setdimension-values
         * @external
         */
        readonly values?: string[];
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::Segment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html
 * @external
 * @cloudformationResource AWS::Pinpoint::Segment
 */
export declare namespace CfnSegment {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentgroups-groups-sourcesegments.html
     * @external
     */
    interface SourceSegmentsProperty {
        /**
         * `CfnSegment.SourceSegmentsProperty.Id`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentgroups-groups-sourcesegments.html#cfn-pinpoint-segment-segmentgroups-groups-sourcesegments-id
         * @external
         */
        readonly id: string;
        /**
         * `CfnSegment.SourceSegmentsProperty.Version`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentgroups-groups-sourcesegments.html#cfn-pinpoint-segment-segmentgroups-groups-sourcesegments-version
         * @external
         */
        readonly version?: number;
    }
}
/**
 * Properties for defining a `AWS::Pinpoint::SmsTemplate`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smstemplate.html
 * @external
 */
export interface CfnSmsTemplateProps {
    /**
     * `AWS::Pinpoint::SmsTemplate.Body`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smstemplate.html#cfn-pinpoint-smstemplate-body
     * @external
     */
    readonly body: string;
    /**
     * `AWS::Pinpoint::SmsTemplate.TemplateName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smstemplate.html#cfn-pinpoint-smstemplate-templatename
     * @external
     */
    readonly templateName: string;
    /**
     * `AWS::Pinpoint::SmsTemplate.DefaultSubstitutions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smstemplate.html#cfn-pinpoint-smstemplate-defaultsubstitutions
     * @external
     */
    readonly defaultSubstitutions?: string;
    /**
     * `AWS::Pinpoint::SmsTemplate.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smstemplate.html#cfn-pinpoint-smstemplate-tags
     * @external
     */
    readonly tags?: any;
    /**
     * `AWS::Pinpoint::SmsTemplate.TemplateDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smstemplate.html#cfn-pinpoint-smstemplate-templatedescription
     * @external
     */
    readonly templateDescription?: string;
}
/**
 * A CloudFormation `AWS::Pinpoint::SmsTemplate`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smstemplate.html
 * @external
 * @cloudformationResource AWS::Pinpoint::SmsTemplate
 */
export declare class CfnSmsTemplate extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Pinpoint::SmsTemplate";
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::Pinpoint::SmsTemplate.Body`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smstemplate.html#cfn-pinpoint-smstemplate-body
     * @external
     */
    body: string;
    /**
     * `AWS::Pinpoint::SmsTemplate.TemplateName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smstemplate.html#cfn-pinpoint-smstemplate-templatename
     * @external
     */
    templateName: string;
    /**
     * `AWS::Pinpoint::SmsTemplate.DefaultSubstitutions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smstemplate.html#cfn-pinpoint-smstemplate-defaultsubstitutions
     * @external
     */
    defaultSubstitutions: string | undefined;
    /**
     * `AWS::Pinpoint::SmsTemplate.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smstemplate.html#cfn-pinpoint-smstemplate-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::Pinpoint::SmsTemplate.TemplateDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smstemplate.html#cfn-pinpoint-smstemplate-templatedescription
     * @external
     */
    templateDescription: string | undefined;
    /**
     * Create a new `AWS::Pinpoint::SmsTemplate`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSmsTemplateProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Pinpoint::VoiceChannel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-voicechannel.html
 * @external
 */
export interface CfnVoiceChannelProps {
    /**
     * `AWS::Pinpoint::VoiceChannel.ApplicationId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-voicechannel.html#cfn-pinpoint-voicechannel-applicationid
     * @external
     */
    readonly applicationId: string;
    /**
     * `AWS::Pinpoint::VoiceChannel.Enabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-voicechannel.html#cfn-pinpoint-voicechannel-enabled
     * @external
     */
    readonly enabled?: boolean | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Pinpoint::VoiceChannel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-voicechannel.html
 * @external
 * @cloudformationResource AWS::Pinpoint::VoiceChannel
 */
export declare class CfnVoiceChannel extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Pinpoint::VoiceChannel";
    /**
     * `AWS::Pinpoint::VoiceChannel.ApplicationId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-voicechannel.html#cfn-pinpoint-voicechannel-applicationid
     * @external
     */
    applicationId: string;
    /**
     * `AWS::Pinpoint::VoiceChannel.Enabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-voicechannel.html#cfn-pinpoint-voicechannel-enabled
     * @external
     */
    enabled: boolean | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Pinpoint::VoiceChannel`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVoiceChannelProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
