import * as cdk from "../../core";
/**
 * Properties for defining a `AWS::OpsWorks::App`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-app.html
 * @external
 */
export interface CfnAppProps {
    /**
     * `AWS::OpsWorks::App.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-app.html#cfn-opsworks-app-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::OpsWorks::App.StackId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-app.html#cfn-opsworks-app-stackid
     * @external
     */
    readonly stackId: string;
    /**
     * `AWS::OpsWorks::App.Type`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-app.html#cfn-opsworks-app-type
     * @external
     */
    readonly type: string;
    /**
     * `AWS::OpsWorks::App.AppSource`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-app.html#cfn-opsworks-app-appsource
     * @external
     */
    readonly appSource?: CfnApp.SourceProperty | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::App.Attributes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-app.html#cfn-opsworks-app-attributes
     * @external
     */
    readonly attributes?: {
        [key: string]: (string);
    } | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::App.DataSources`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-app.html#cfn-opsworks-app-datasources
     * @external
     */
    readonly dataSources?: Array<CfnApp.DataSourceProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::App.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-app.html#cfn-opsworks-app-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::OpsWorks::App.Domains`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-app.html#cfn-opsworks-app-domains
     * @external
     */
    readonly domains?: string[];
    /**
     * `AWS::OpsWorks::App.EnableSsl`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-app.html#cfn-opsworks-app-enablessl
     * @external
     */
    readonly enableSsl?: boolean | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::App.Environment`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-app.html#cfn-opsworks-app-environment
     * @external
     */
    readonly environment?: Array<CfnApp.EnvironmentVariableProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::App.Shortname`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-app.html#cfn-opsworks-app-shortname
     * @external
     */
    readonly shortname?: string;
    /**
     * `AWS::OpsWorks::App.SslConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-app.html#cfn-opsworks-app-sslconfiguration
     * @external
     */
    readonly sslConfiguration?: CfnApp.SslConfigurationProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::OpsWorks::App`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-app.html
 * @external
 * @cloudformationResource AWS::OpsWorks::App
 */
export declare class CfnApp extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::OpsWorks::App";
    /**
     * `AWS::OpsWorks::App.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-app.html#cfn-opsworks-app-name
     * @external
     */
    name: string;
    /**
     * `AWS::OpsWorks::App.StackId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-app.html#cfn-opsworks-app-stackid
     * @external
     */
    stackId: string;
    /**
     * `AWS::OpsWorks::App.Type`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-app.html#cfn-opsworks-app-type
     * @external
     */
    type: string;
    /**
     * `AWS::OpsWorks::App.AppSource`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-app.html#cfn-opsworks-app-appsource
     * @external
     */
    appSource: CfnApp.SourceProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorks::App.Attributes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-app.html#cfn-opsworks-app-attributes
     * @external
     */
    attributes: {
        [key: string]: (string);
    } | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorks::App.DataSources`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-app.html#cfn-opsworks-app-datasources
     * @external
     */
    dataSources: Array<CfnApp.DataSourceProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorks::App.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-app.html#cfn-opsworks-app-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::OpsWorks::App.Domains`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-app.html#cfn-opsworks-app-domains
     * @external
     */
    domains: string[] | undefined;
    /**
     * `AWS::OpsWorks::App.EnableSsl`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-app.html#cfn-opsworks-app-enablessl
     * @external
     */
    enableSsl: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorks::App.Environment`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-app.html#cfn-opsworks-app-environment
     * @external
     */
    environment: Array<CfnApp.EnvironmentVariableProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorks::App.Shortname`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-app.html#cfn-opsworks-app-shortname
     * @external
     */
    shortname: string | undefined;
    /**
     * `AWS::OpsWorks::App.SslConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-app.html#cfn-opsworks-app-sslconfiguration
     * @external
     */
    sslConfiguration: CfnApp.SslConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::OpsWorks::App`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAppProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::OpsWorks::App`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-app.html
 * @external
 * @cloudformationResource AWS::OpsWorks::App
 */
export declare namespace CfnApp {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-app-datasource.html
     * @external
     */
    interface DataSourceProperty {
        /**
         * `CfnApp.DataSourceProperty.Arn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-app-datasource.html#cfn-opsworks-app-datasource-arn
         * @external
         */
        readonly arn?: string;
        /**
         * `CfnApp.DataSourceProperty.DatabaseName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-app-datasource.html#cfn-opsworks-app-datasource-databasename
         * @external
         */
        readonly databaseName?: string;
        /**
         * `CfnApp.DataSourceProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-app-datasource.html#cfn-opsworks-app-datasource-type
         * @external
         */
        readonly type?: string;
    }
}
/**
 * A CloudFormation `AWS::OpsWorks::App`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-app.html
 * @external
 * @cloudformationResource AWS::OpsWorks::App
 */
export declare namespace CfnApp {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-app-environment.html
     * @external
     */
    interface EnvironmentVariableProperty {
        /**
         * `CfnApp.EnvironmentVariableProperty.Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-app-environment.html#cfn-opsworks-app-environment-key
         * @external
         */
        readonly key: string;
        /**
         * `CfnApp.EnvironmentVariableProperty.Secure`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-app-environment.html#cfn-opsworks-app-environment-secure
         * @external
         */
        readonly secure?: boolean | cdk.IResolvable;
        /**
         * `CfnApp.EnvironmentVariableProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-app-environment.html#value
         * @external
         */
        readonly value: string;
    }
}
/**
 * A CloudFormation `AWS::OpsWorks::App`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-app.html
 * @external
 * @cloudformationResource AWS::OpsWorks::App
 */
export declare namespace CfnApp {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-source.html
     * @external
     */
    interface SourceProperty {
        /**
         * `CfnApp.SourceProperty.Password`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-source.html#cfn-opsworks-custcookbooksource-pw
         * @external
         */
        readonly password?: string;
        /**
         * `CfnApp.SourceProperty.Revision`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-source.html#cfn-opsworks-custcookbooksource-revision
         * @external
         */
        readonly revision?: string;
        /**
         * `CfnApp.SourceProperty.SshKey`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-source.html#cfn-opsworks-custcookbooksource-sshkey
         * @external
         */
        readonly sshKey?: string;
        /**
         * `CfnApp.SourceProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-source.html#cfn-opsworks-custcookbooksource-type
         * @external
         */
        readonly type?: string;
        /**
         * `CfnApp.SourceProperty.Url`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-source.html#cfn-opsworks-custcookbooksource-url
         * @external
         */
        readonly url?: string;
        /**
         * `CfnApp.SourceProperty.Username`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-source.html#cfn-opsworks-custcookbooksource-username
         * @external
         */
        readonly username?: string;
    }
}
/**
 * A CloudFormation `AWS::OpsWorks::App`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-app.html
 * @external
 * @cloudformationResource AWS::OpsWorks::App
 */
export declare namespace CfnApp {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-app-sslconfiguration.html
     * @external
     */
    interface SslConfigurationProperty {
        /**
         * `CfnApp.SslConfigurationProperty.Certificate`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-app-sslconfiguration.html#cfn-opsworks-app-sslconfig-certificate
         * @external
         */
        readonly certificate?: string;
        /**
         * `CfnApp.SslConfigurationProperty.Chain`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-app-sslconfiguration.html#cfn-opsworks-app-sslconfig-chain
         * @external
         */
        readonly chain?: string;
        /**
         * `CfnApp.SslConfigurationProperty.PrivateKey`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-app-sslconfiguration.html#cfn-opsworks-app-sslconfig-privatekey
         * @external
         */
        readonly privateKey?: string;
    }
}
/**
 * Properties for defining a `AWS::OpsWorks::ElasticLoadBalancerAttachment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-elbattachment.html
 * @external
 */
export interface CfnElasticLoadBalancerAttachmentProps {
    /**
     * `AWS::OpsWorks::ElasticLoadBalancerAttachment.ElasticLoadBalancerName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-elbattachment.html#cfn-opsworks-elbattachment-elbname
     * @external
     */
    readonly elasticLoadBalancerName: string;
    /**
     * `AWS::OpsWorks::ElasticLoadBalancerAttachment.LayerId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-elbattachment.html#cfn-opsworks-elbattachment-layerid
     * @external
     */
    readonly layerId: string;
}
/**
 * A CloudFormation `AWS::OpsWorks::ElasticLoadBalancerAttachment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-elbattachment.html
 * @external
 * @cloudformationResource AWS::OpsWorks::ElasticLoadBalancerAttachment
 */
export declare class CfnElasticLoadBalancerAttachment extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::OpsWorks::ElasticLoadBalancerAttachment";
    /**
     * `AWS::OpsWorks::ElasticLoadBalancerAttachment.ElasticLoadBalancerName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-elbattachment.html#cfn-opsworks-elbattachment-elbname
     * @external
     */
    elasticLoadBalancerName: string;
    /**
     * `AWS::OpsWorks::ElasticLoadBalancerAttachment.LayerId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-elbattachment.html#cfn-opsworks-elbattachment-layerid
     * @external
     */
    layerId: string;
    /**
     * Create a new `AWS::OpsWorks::ElasticLoadBalancerAttachment`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnElasticLoadBalancerAttachmentProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::OpsWorks::Instance`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html
 * @external
 */
export interface CfnInstanceProps {
    /**
     * `AWS::OpsWorks::Instance.InstanceType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-instancetype
     * @external
     */
    readonly instanceType: string;
    /**
     * `AWS::OpsWorks::Instance.LayerIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-layerids
     * @external
     */
    readonly layerIds: string[];
    /**
     * `AWS::OpsWorks::Instance.StackId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-stackid
     * @external
     */
    readonly stackId: string;
    /**
     * `AWS::OpsWorks::Instance.AgentVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-agentversion
     * @external
     */
    readonly agentVersion?: string;
    /**
     * `AWS::OpsWorks::Instance.AmiId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-amiid
     * @external
     */
    readonly amiId?: string;
    /**
     * `AWS::OpsWorks::Instance.Architecture`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-architecture
     * @external
     */
    readonly architecture?: string;
    /**
     * `AWS::OpsWorks::Instance.AutoScalingType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-autoscalingtype
     * @external
     */
    readonly autoScalingType?: string;
    /**
     * `AWS::OpsWorks::Instance.AvailabilityZone`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-availabilityzone
     * @external
     */
    readonly availabilityZone?: string;
    /**
     * `AWS::OpsWorks::Instance.BlockDeviceMappings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-blockdevicemappings
     * @external
     */
    readonly blockDeviceMappings?: Array<CfnInstance.BlockDeviceMappingProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::Instance.EbsOptimized`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-ebsoptimized
     * @external
     */
    readonly ebsOptimized?: boolean | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::Instance.ElasticIps`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-elasticips
     * @external
     */
    readonly elasticIps?: string[];
    /**
     * `AWS::OpsWorks::Instance.Hostname`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-hostname
     * @external
     */
    readonly hostname?: string;
    /**
     * `AWS::OpsWorks::Instance.InstallUpdatesOnBoot`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-installupdatesonboot
     * @external
     */
    readonly installUpdatesOnBoot?: boolean | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::Instance.Os`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-os
     * @external
     */
    readonly os?: string;
    /**
     * `AWS::OpsWorks::Instance.RootDeviceType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-rootdevicetype
     * @external
     */
    readonly rootDeviceType?: string;
    /**
     * `AWS::OpsWorks::Instance.SshKeyName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-sshkeyname
     * @external
     */
    readonly sshKeyName?: string;
    /**
     * `AWS::OpsWorks::Instance.SubnetId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-subnetid
     * @external
     */
    readonly subnetId?: string;
    /**
     * `AWS::OpsWorks::Instance.Tenancy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-tenancy
     * @external
     */
    readonly tenancy?: string;
    /**
     * `AWS::OpsWorks::Instance.TimeBasedAutoScaling`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-timebasedautoscaling
     * @external
     */
    readonly timeBasedAutoScaling?: CfnInstance.TimeBasedAutoScalingProperty | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::Instance.VirtualizationType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-virtualizationtype
     * @external
     */
    readonly virtualizationType?: string;
    /**
     * `AWS::OpsWorks::Instance.Volumes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-volumes
     * @external
     */
    readonly volumes?: string[];
}
/**
 * A CloudFormation `AWS::OpsWorks::Instance`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html
 * @external
 * @cloudformationResource AWS::OpsWorks::Instance
 */
export declare class CfnInstance extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::OpsWorks::Instance";
    /**
     * @external
     * @cloudformationAttribute AvailabilityZone
     */
    readonly attrAvailabilityZone: string;
    /**
     * @external
     * @cloudformationAttribute PrivateDnsName
     */
    readonly attrPrivateDnsName: string;
    /**
     * @external
     * @cloudformationAttribute PrivateIp
     */
    readonly attrPrivateIp: string;
    /**
     * @external
     * @cloudformationAttribute PublicDnsName
     */
    readonly attrPublicDnsName: string;
    /**
     * @external
     * @cloudformationAttribute PublicIp
     */
    readonly attrPublicIp: string;
    /**
     * `AWS::OpsWorks::Instance.InstanceType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-instancetype
     * @external
     */
    instanceType: string;
    /**
     * `AWS::OpsWorks::Instance.LayerIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-layerids
     * @external
     */
    layerIds: string[];
    /**
     * `AWS::OpsWorks::Instance.StackId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-stackid
     * @external
     */
    stackId: string;
    /**
     * `AWS::OpsWorks::Instance.AgentVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-agentversion
     * @external
     */
    agentVersion: string | undefined;
    /**
     * `AWS::OpsWorks::Instance.AmiId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-amiid
     * @external
     */
    amiId: string | undefined;
    /**
     * `AWS::OpsWorks::Instance.Architecture`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-architecture
     * @external
     */
    architecture: string | undefined;
    /**
     * `AWS::OpsWorks::Instance.AutoScalingType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-autoscalingtype
     * @external
     */
    autoScalingType: string | undefined;
    /**
     * `AWS::OpsWorks::Instance.AvailabilityZone`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-availabilityzone
     * @external
     */
    availabilityZone: string | undefined;
    /**
     * `AWS::OpsWorks::Instance.BlockDeviceMappings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-blockdevicemappings
     * @external
     */
    blockDeviceMappings: Array<CfnInstance.BlockDeviceMappingProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorks::Instance.EbsOptimized`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-ebsoptimized
     * @external
     */
    ebsOptimized: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorks::Instance.ElasticIps`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-elasticips
     * @external
     */
    elasticIps: string[] | undefined;
    /**
     * `AWS::OpsWorks::Instance.Hostname`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-hostname
     * @external
     */
    hostname: string | undefined;
    /**
     * `AWS::OpsWorks::Instance.InstallUpdatesOnBoot`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-installupdatesonboot
     * @external
     */
    installUpdatesOnBoot: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorks::Instance.Os`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-os
     * @external
     */
    os: string | undefined;
    /**
     * `AWS::OpsWorks::Instance.RootDeviceType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-rootdevicetype
     * @external
     */
    rootDeviceType: string | undefined;
    /**
     * `AWS::OpsWorks::Instance.SshKeyName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-sshkeyname
     * @external
     */
    sshKeyName: string | undefined;
    /**
     * `AWS::OpsWorks::Instance.SubnetId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-subnetid
     * @external
     */
    subnetId: string | undefined;
    /**
     * `AWS::OpsWorks::Instance.Tenancy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-tenancy
     * @external
     */
    tenancy: string | undefined;
    /**
     * `AWS::OpsWorks::Instance.TimeBasedAutoScaling`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-timebasedautoscaling
     * @external
     */
    timeBasedAutoScaling: CfnInstance.TimeBasedAutoScalingProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorks::Instance.VirtualizationType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-virtualizationtype
     * @external
     */
    virtualizationType: string | undefined;
    /**
     * `AWS::OpsWorks::Instance.Volumes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-volumes
     * @external
     */
    volumes: string[] | undefined;
    /**
     * Create a new `AWS::OpsWorks::Instance`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnInstanceProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::OpsWorks::Instance`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html
 * @external
 * @cloudformationResource AWS::OpsWorks::Instance
 */
export declare namespace CfnInstance {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-instance-blockdevicemapping.html
     * @external
     */
    interface BlockDeviceMappingProperty {
        /**
         * `CfnInstance.BlockDeviceMappingProperty.DeviceName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-instance-blockdevicemapping.html#cfn-opsworks-instance-blockdevicemapping-devicename
         * @external
         */
        readonly deviceName?: string;
        /**
         * `CfnInstance.BlockDeviceMappingProperty.Ebs`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-instance-blockdevicemapping.html#cfn-opsworks-instance-blockdevicemapping-ebs
         * @external
         */
        readonly ebs?: CfnInstance.EbsBlockDeviceProperty | cdk.IResolvable;
        /**
         * `CfnInstance.BlockDeviceMappingProperty.NoDevice`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-instance-blockdevicemapping.html#cfn-opsworks-instance-blockdevicemapping-nodevice
         * @external
         */
        readonly noDevice?: string;
        /**
         * `CfnInstance.BlockDeviceMappingProperty.VirtualName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-instance-blockdevicemapping.html#cfn-opsworks-instance-blockdevicemapping-virtualname
         * @external
         */
        readonly virtualName?: string;
    }
}
/**
 * A CloudFormation `AWS::OpsWorks::Instance`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html
 * @external
 * @cloudformationResource AWS::OpsWorks::Instance
 */
export declare namespace CfnInstance {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-instance-ebsblockdevice.html
     * @external
     */
    interface EbsBlockDeviceProperty {
        /**
         * `CfnInstance.EbsBlockDeviceProperty.DeleteOnTermination`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-instance-ebsblockdevice.html#cfn-opsworks-instance-ebsblockdevice-deleteontermination
         * @external
         */
        readonly deleteOnTermination?: boolean | cdk.IResolvable;
        /**
         * `CfnInstance.EbsBlockDeviceProperty.Iops`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-instance-ebsblockdevice.html#cfn-opsworks-instance-ebsblockdevice-iops
         * @external
         */
        readonly iops?: number;
        /**
         * `CfnInstance.EbsBlockDeviceProperty.SnapshotId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-instance-ebsblockdevice.html#cfn-opsworks-instance-ebsblockdevice-snapshotid
         * @external
         */
        readonly snapshotId?: string;
        /**
         * `CfnInstance.EbsBlockDeviceProperty.VolumeSize`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-instance-ebsblockdevice.html#cfn-opsworks-instance-ebsblockdevice-volumesize
         * @external
         */
        readonly volumeSize?: number;
        /**
         * `CfnInstance.EbsBlockDeviceProperty.VolumeType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-instance-ebsblockdevice.html#cfn-opsworks-instance-ebsblockdevice-volumetype
         * @external
         */
        readonly volumeType?: string;
    }
}
/**
 * A CloudFormation `AWS::OpsWorks::Instance`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html
 * @external
 * @cloudformationResource AWS::OpsWorks::Instance
 */
export declare namespace CfnInstance {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-instance-timebasedautoscaling.html
     * @external
     */
    interface TimeBasedAutoScalingProperty {
        /**
         * `CfnInstance.TimeBasedAutoScalingProperty.Friday`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-instance-timebasedautoscaling.html#cfn-opsworks-instance-timebasedautoscaling-friday
         * @external
         */
        readonly friday?: {
            [key: string]: (string);
        } | cdk.IResolvable;
        /**
         * `CfnInstance.TimeBasedAutoScalingProperty.Monday`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-instance-timebasedautoscaling.html#cfn-opsworks-instance-timebasedautoscaling-monday
         * @external
         */
        readonly monday?: {
            [key: string]: (string);
        } | cdk.IResolvable;
        /**
         * `CfnInstance.TimeBasedAutoScalingProperty.Saturday`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-instance-timebasedautoscaling.html#cfn-opsworks-instance-timebasedautoscaling-saturday
         * @external
         */
        readonly saturday?: {
            [key: string]: (string);
        } | cdk.IResolvable;
        /**
         * `CfnInstance.TimeBasedAutoScalingProperty.Sunday`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-instance-timebasedautoscaling.html#cfn-opsworks-instance-timebasedautoscaling-sunday
         * @external
         */
        readonly sunday?: {
            [key: string]: (string);
        } | cdk.IResolvable;
        /**
         * `CfnInstance.TimeBasedAutoScalingProperty.Thursday`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-instance-timebasedautoscaling.html#cfn-opsworks-instance-timebasedautoscaling-thursday
         * @external
         */
        readonly thursday?: {
            [key: string]: (string);
        } | cdk.IResolvable;
        /**
         * `CfnInstance.TimeBasedAutoScalingProperty.Tuesday`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-instance-timebasedautoscaling.html#cfn-opsworks-instance-timebasedautoscaling-tuesday
         * @external
         */
        readonly tuesday?: {
            [key: string]: (string);
        } | cdk.IResolvable;
        /**
         * `CfnInstance.TimeBasedAutoScalingProperty.Wednesday`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-instance-timebasedautoscaling.html#cfn-opsworks-instance-timebasedautoscaling-wednesday
         * @external
         */
        readonly wednesday?: {
            [key: string]: (string);
        } | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::OpsWorks::Layer`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html
 * @external
 */
export interface CfnLayerProps {
    /**
     * `AWS::OpsWorks::Layer.AutoAssignElasticIps`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-autoassignelasticips
     * @external
     */
    readonly autoAssignElasticIps: boolean | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::Layer.AutoAssignPublicIps`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-autoassignpublicips
     * @external
     */
    readonly autoAssignPublicIps: boolean | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::Layer.EnableAutoHealing`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-enableautohealing
     * @external
     */
    readonly enableAutoHealing: boolean | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::Layer.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::OpsWorks::Layer.Shortname`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-shortname
     * @external
     */
    readonly shortname: string;
    /**
     * `AWS::OpsWorks::Layer.StackId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-stackid
     * @external
     */
    readonly stackId: string;
    /**
     * `AWS::OpsWorks::Layer.Type`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-type
     * @external
     */
    readonly type: string;
    /**
     * `AWS::OpsWorks::Layer.Attributes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-attributes
     * @external
     */
    readonly attributes?: {
        [key: string]: (string);
    } | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::Layer.CustomInstanceProfileArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-custominstanceprofilearn
     * @external
     */
    readonly customInstanceProfileArn?: string;
    /**
     * `AWS::OpsWorks::Layer.CustomJson`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-customjson
     * @external
     */
    readonly customJson?: any | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::Layer.CustomRecipes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-customrecipes
     * @external
     */
    readonly customRecipes?: CfnLayer.RecipesProperty | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::Layer.CustomSecurityGroupIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-customsecuritygroupids
     * @external
     */
    readonly customSecurityGroupIds?: string[];
    /**
     * `AWS::OpsWorks::Layer.InstallUpdatesOnBoot`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-installupdatesonboot
     * @external
     */
    readonly installUpdatesOnBoot?: boolean | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::Layer.LifecycleEventConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-lifecycleeventconfiguration
     * @external
     */
    readonly lifecycleEventConfiguration?: CfnLayer.LifecycleEventConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::Layer.LoadBasedAutoScaling`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-loadbasedautoscaling
     * @external
     */
    readonly loadBasedAutoScaling?: CfnLayer.LoadBasedAutoScalingProperty | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::Layer.Packages`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-packages
     * @external
     */
    readonly packages?: string[];
    /**
     * `AWS::OpsWorks::Layer.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::OpsWorks::Layer.UseEbsOptimizedInstances`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-useebsoptimizedinstances
     * @external
     */
    readonly useEbsOptimizedInstances?: boolean | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::Layer.VolumeConfigurations`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-volumeconfigurations
     * @external
     */
    readonly volumeConfigurations?: Array<CfnLayer.VolumeConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::OpsWorks::Layer`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html
 * @external
 * @cloudformationResource AWS::OpsWorks::Layer
 */
export declare class CfnLayer extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::OpsWorks::Layer";
    /**
     * `AWS::OpsWorks::Layer.AutoAssignElasticIps`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-autoassignelasticips
     * @external
     */
    autoAssignElasticIps: boolean | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::Layer.AutoAssignPublicIps`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-autoassignpublicips
     * @external
     */
    autoAssignPublicIps: boolean | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::Layer.EnableAutoHealing`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-enableautohealing
     * @external
     */
    enableAutoHealing: boolean | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::Layer.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-name
     * @external
     */
    name: string;
    /**
     * `AWS::OpsWorks::Layer.Shortname`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-shortname
     * @external
     */
    shortname: string;
    /**
     * `AWS::OpsWorks::Layer.StackId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-stackid
     * @external
     */
    stackId: string;
    /**
     * `AWS::OpsWorks::Layer.Type`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-type
     * @external
     */
    type: string;
    /**
     * `AWS::OpsWorks::Layer.Attributes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-attributes
     * @external
     */
    attributes: {
        [key: string]: (string);
    } | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorks::Layer.CustomInstanceProfileArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-custominstanceprofilearn
     * @external
     */
    customInstanceProfileArn: string | undefined;
    /**
     * `AWS::OpsWorks::Layer.CustomJson`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-customjson
     * @external
     */
    customJson: any | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorks::Layer.CustomRecipes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-customrecipes
     * @external
     */
    customRecipes: CfnLayer.RecipesProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorks::Layer.CustomSecurityGroupIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-customsecuritygroupids
     * @external
     */
    customSecurityGroupIds: string[] | undefined;
    /**
     * `AWS::OpsWorks::Layer.InstallUpdatesOnBoot`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-installupdatesonboot
     * @external
     */
    installUpdatesOnBoot: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorks::Layer.LifecycleEventConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-lifecycleeventconfiguration
     * @external
     */
    lifecycleEventConfiguration: CfnLayer.LifecycleEventConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorks::Layer.LoadBasedAutoScaling`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-loadbasedautoscaling
     * @external
     */
    loadBasedAutoScaling: CfnLayer.LoadBasedAutoScalingProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorks::Layer.Packages`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-packages
     * @external
     */
    packages: string[] | undefined;
    /**
     * `AWS::OpsWorks::Layer.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::OpsWorks::Layer.UseEbsOptimizedInstances`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-useebsoptimizedinstances
     * @external
     */
    useEbsOptimizedInstances: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorks::Layer.VolumeConfigurations`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-volumeconfigurations
     * @external
     */
    volumeConfigurations: Array<CfnLayer.VolumeConfigurationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::OpsWorks::Layer`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnLayerProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::OpsWorks::Layer`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html
 * @external
 * @cloudformationResource AWS::OpsWorks::Layer
 */
export declare namespace CfnLayer {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-loadbasedautoscaling-autoscalingthresholds.html
     * @external
     */
    interface AutoScalingThresholdsProperty {
        /**
         * `CfnLayer.AutoScalingThresholdsProperty.CpuThreshold`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-loadbasedautoscaling-autoscalingthresholds.html#cfn-opsworks-layer-loadbasedautoscaling-autoscalingthresholds-cputhreshold
         * @external
         */
        readonly cpuThreshold?: number;
        /**
         * `CfnLayer.AutoScalingThresholdsProperty.IgnoreMetricsTime`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-loadbasedautoscaling-autoscalingthresholds.html#cfn-opsworks-layer-loadbasedautoscaling-autoscalingthresholds-ignoremetricstime
         * @external
         */
        readonly ignoreMetricsTime?: number;
        /**
         * `CfnLayer.AutoScalingThresholdsProperty.InstanceCount`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-loadbasedautoscaling-autoscalingthresholds.html#cfn-opsworks-layer-loadbasedautoscaling-autoscalingthresholds-instancecount
         * @external
         */
        readonly instanceCount?: number;
        /**
         * `CfnLayer.AutoScalingThresholdsProperty.LoadThreshold`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-loadbasedautoscaling-autoscalingthresholds.html#cfn-opsworks-layer-loadbasedautoscaling-autoscalingthresholds-loadthreshold
         * @external
         */
        readonly loadThreshold?: number;
        /**
         * `CfnLayer.AutoScalingThresholdsProperty.MemoryThreshold`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-loadbasedautoscaling-autoscalingthresholds.html#cfn-opsworks-layer-loadbasedautoscaling-autoscalingthresholds-memorythreshold
         * @external
         */
        readonly memoryThreshold?: number;
        /**
         * `CfnLayer.AutoScalingThresholdsProperty.ThresholdsWaitTime`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-loadbasedautoscaling-autoscalingthresholds.html#cfn-opsworks-layer-loadbasedautoscaling-autoscalingthresholds-thresholdwaittime
         * @external
         */
        readonly thresholdsWaitTime?: number;
    }
}
/**
 * A CloudFormation `AWS::OpsWorks::Layer`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html
 * @external
 * @cloudformationResource AWS::OpsWorks::Layer
 */
export declare namespace CfnLayer {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-lifecycleeventconfiguration.html
     * @external
     */
    interface LifecycleEventConfigurationProperty {
        /**
         * `CfnLayer.LifecycleEventConfigurationProperty.ShutdownEventConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-lifecycleeventconfiguration.html#cfn-opsworks-layer-lifecycleconfiguration-shutdowneventconfiguration
         * @external
         */
        readonly shutdownEventConfiguration?: CfnLayer.ShutdownEventConfigurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::OpsWorks::Layer`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html
 * @external
 * @cloudformationResource AWS::OpsWorks::Layer
 */
export declare namespace CfnLayer {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-loadbasedautoscaling.html
     * @external
     */
    interface LoadBasedAutoScalingProperty {
        /**
         * `CfnLayer.LoadBasedAutoScalingProperty.DownScaling`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-loadbasedautoscaling.html#cfn-opsworks-layer-loadbasedautoscaling-downscaling
         * @external
         */
        readonly downScaling?: CfnLayer.AutoScalingThresholdsProperty | cdk.IResolvable;
        /**
         * `CfnLayer.LoadBasedAutoScalingProperty.Enable`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-loadbasedautoscaling.html#cfn-opsworks-layer-loadbasedautoscaling-enable
         * @external
         */
        readonly enable?: boolean | cdk.IResolvable;
        /**
         * `CfnLayer.LoadBasedAutoScalingProperty.UpScaling`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-loadbasedautoscaling.html#cfn-opsworks-layer-loadbasedautoscaling-upscaling
         * @external
         */
        readonly upScaling?: CfnLayer.AutoScalingThresholdsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::OpsWorks::Layer`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html
 * @external
 * @cloudformationResource AWS::OpsWorks::Layer
 */
export declare namespace CfnLayer {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-recipes.html
     * @external
     */
    interface RecipesProperty {
        /**
         * `CfnLayer.RecipesProperty.Configure`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-recipes.html#cfn-opsworks-layer-customrecipes-configure
         * @external
         */
        readonly configure?: string[];
        /**
         * `CfnLayer.RecipesProperty.Deploy`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-recipes.html#cfn-opsworks-layer-customrecipes-deploy
         * @external
         */
        readonly deploy?: string[];
        /**
         * `CfnLayer.RecipesProperty.Setup`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-recipes.html#cfn-opsworks-layer-customrecipes-setup
         * @external
         */
        readonly setup?: string[];
        /**
         * `CfnLayer.RecipesProperty.Shutdown`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-recipes.html#cfn-opsworks-layer-customrecipes-shutdown
         * @external
         */
        readonly shutdown?: string[];
        /**
         * `CfnLayer.RecipesProperty.Undeploy`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-recipes.html#cfn-opsworks-layer-customrecipes-undeploy
         * @external
         */
        readonly undeploy?: string[];
    }
}
/**
 * A CloudFormation `AWS::OpsWorks::Layer`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html
 * @external
 * @cloudformationResource AWS::OpsWorks::Layer
 */
export declare namespace CfnLayer {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-lifecycleeventconfiguration-shutdowneventconfiguration.html
     * @external
     */
    interface ShutdownEventConfigurationProperty {
        /**
         * `CfnLayer.ShutdownEventConfigurationProperty.DelayUntilElbConnectionsDrained`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-lifecycleeventconfiguration-shutdowneventconfiguration.html#cfn-opsworks-layer-lifecycleconfiguration-shutdowneventconfiguration-delayuntilelbconnectionsdrained
         * @external
         */
        readonly delayUntilElbConnectionsDrained?: boolean | cdk.IResolvable;
        /**
         * `CfnLayer.ShutdownEventConfigurationProperty.ExecutionTimeout`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-lifecycleeventconfiguration-shutdowneventconfiguration.html#cfn-opsworks-layer-lifecycleconfiguration-shutdowneventconfiguration-executiontimeout
         * @external
         */
        readonly executionTimeout?: number;
    }
}
/**
 * A CloudFormation `AWS::OpsWorks::Layer`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html
 * @external
 * @cloudformationResource AWS::OpsWorks::Layer
 */
export declare namespace CfnLayer {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-volumeconfiguration.html
     * @external
     */
    interface VolumeConfigurationProperty {
        /**
         * `CfnLayer.VolumeConfigurationProperty.Encrypted`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-volumeconfiguration.html#cfn-opsworks-layer-volumeconfiguration-encrypted
         * @external
         */
        readonly encrypted?: boolean | cdk.IResolvable;
        /**
         * `CfnLayer.VolumeConfigurationProperty.Iops`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-volumeconfiguration.html#cfn-opsworks-layer-volconfig-iops
         * @external
         */
        readonly iops?: number;
        /**
         * `CfnLayer.VolumeConfigurationProperty.MountPoint`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-volumeconfiguration.html#cfn-opsworks-layer-volconfig-mountpoint
         * @external
         */
        readonly mountPoint?: string;
        /**
         * `CfnLayer.VolumeConfigurationProperty.NumberOfDisks`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-volumeconfiguration.html#cfn-opsworks-layer-volconfig-numberofdisks
         * @external
         */
        readonly numberOfDisks?: number;
        /**
         * `CfnLayer.VolumeConfigurationProperty.RaidLevel`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-volumeconfiguration.html#cfn-opsworks-layer-volconfig-raidlevel
         * @external
         */
        readonly raidLevel?: number;
        /**
         * `CfnLayer.VolumeConfigurationProperty.Size`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-volumeconfiguration.html#cfn-opsworks-layer-volconfig-size
         * @external
         */
        readonly size?: number;
        /**
         * `CfnLayer.VolumeConfigurationProperty.VolumeType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-volumeconfiguration.html#cfn-opsworks-layer-volconfig-volumetype
         * @external
         */
        readonly volumeType?: string;
    }
}
/**
 * Properties for defining a `AWS::OpsWorks::Stack`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html
 * @external
 */
export interface CfnStackProps {
    /**
     * `AWS::OpsWorks::Stack.DefaultInstanceProfileArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-defaultinstanceprof
     * @external
     */
    readonly defaultInstanceProfileArn: string;
    /**
     * `AWS::OpsWorks::Stack.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::OpsWorks::Stack.ServiceRoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-servicerolearn
     * @external
     */
    readonly serviceRoleArn: string;
    /**
     * `AWS::OpsWorks::Stack.AgentVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-agentversion
     * @external
     */
    readonly agentVersion?: string;
    /**
     * `AWS::OpsWorks::Stack.Attributes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-attributes
     * @external
     */
    readonly attributes?: {
        [key: string]: (string);
    } | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::Stack.ChefConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-chefconfiguration
     * @external
     */
    readonly chefConfiguration?: CfnStack.ChefConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::Stack.CloneAppIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-cloneappids
     * @external
     */
    readonly cloneAppIds?: string[];
    /**
     * `AWS::OpsWorks::Stack.ClonePermissions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-clonepermissions
     * @external
     */
    readonly clonePermissions?: boolean | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::Stack.ConfigurationManager`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-configmanager
     * @external
     */
    readonly configurationManager?: CfnStack.StackConfigurationManagerProperty | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::Stack.CustomCookbooksSource`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-custcookbooksource
     * @external
     */
    readonly customCookbooksSource?: CfnStack.SourceProperty | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::Stack.CustomJson`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-custjson
     * @external
     */
    readonly customJson?: any | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::Stack.DefaultAvailabilityZone`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-defaultaz
     * @external
     */
    readonly defaultAvailabilityZone?: string;
    /**
     * `AWS::OpsWorks::Stack.DefaultOs`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-defaultos
     * @external
     */
    readonly defaultOs?: string;
    /**
     * `AWS::OpsWorks::Stack.DefaultRootDeviceType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-defaultrootdevicetype
     * @external
     */
    readonly defaultRootDeviceType?: string;
    /**
     * `AWS::OpsWorks::Stack.DefaultSshKeyName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-defaultsshkeyname
     * @external
     */
    readonly defaultSshKeyName?: string;
    /**
     * `AWS::OpsWorks::Stack.DefaultSubnetId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#defaultsubnet
     * @external
     */
    readonly defaultSubnetId?: string;
    /**
     * `AWS::OpsWorks::Stack.EcsClusterArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-ecsclusterarn
     * @external
     */
    readonly ecsClusterArn?: string;
    /**
     * `AWS::OpsWorks::Stack.ElasticIps`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-elasticips
     * @external
     */
    readonly elasticIps?: Array<CfnStack.ElasticIpProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::Stack.HostnameTheme`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-hostnametheme
     * @external
     */
    readonly hostnameTheme?: string;
    /**
     * `AWS::OpsWorks::Stack.RdsDbInstances`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-rdsdbinstances
     * @external
     */
    readonly rdsDbInstances?: Array<CfnStack.RdsDbInstanceProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::Stack.SourceStackId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-sourcestackid
     * @external
     */
    readonly sourceStackId?: string;
    /**
     * `AWS::OpsWorks::Stack.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::OpsWorks::Stack.UseCustomCookbooks`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#usecustcookbooks
     * @external
     */
    readonly useCustomCookbooks?: boolean | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::Stack.UseOpsworksSecurityGroups`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-useopsworkssecuritygroups
     * @external
     */
    readonly useOpsworksSecurityGroups?: boolean | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::Stack.VpcId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-vpcid
     * @external
     */
    readonly vpcId?: string;
}
/**
 * A CloudFormation `AWS::OpsWorks::Stack`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html
 * @external
 * @cloudformationResource AWS::OpsWorks::Stack
 */
export declare class CfnStack extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::OpsWorks::Stack";
    /**
     * `AWS::OpsWorks::Stack.DefaultInstanceProfileArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-defaultinstanceprof
     * @external
     */
    defaultInstanceProfileArn: string;
    /**
     * `AWS::OpsWorks::Stack.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-name
     * @external
     */
    name: string;
    /**
     * `AWS::OpsWorks::Stack.ServiceRoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-servicerolearn
     * @external
     */
    serviceRoleArn: string;
    /**
     * `AWS::OpsWorks::Stack.AgentVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-agentversion
     * @external
     */
    agentVersion: string | undefined;
    /**
     * `AWS::OpsWorks::Stack.Attributes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-attributes
     * @external
     */
    attributes: {
        [key: string]: (string);
    } | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorks::Stack.ChefConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-chefconfiguration
     * @external
     */
    chefConfiguration: CfnStack.ChefConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorks::Stack.CloneAppIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-cloneappids
     * @external
     */
    cloneAppIds: string[] | undefined;
    /**
     * `AWS::OpsWorks::Stack.ClonePermissions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-clonepermissions
     * @external
     */
    clonePermissions: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorks::Stack.ConfigurationManager`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-configmanager
     * @external
     */
    configurationManager: CfnStack.StackConfigurationManagerProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorks::Stack.CustomCookbooksSource`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-custcookbooksource
     * @external
     */
    customCookbooksSource: CfnStack.SourceProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorks::Stack.CustomJson`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-custjson
     * @external
     */
    customJson: any | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorks::Stack.DefaultAvailabilityZone`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-defaultaz
     * @external
     */
    defaultAvailabilityZone: string | undefined;
    /**
     * `AWS::OpsWorks::Stack.DefaultOs`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-defaultos
     * @external
     */
    defaultOs: string | undefined;
    /**
     * `AWS::OpsWorks::Stack.DefaultRootDeviceType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-defaultrootdevicetype
     * @external
     */
    defaultRootDeviceType: string | undefined;
    /**
     * `AWS::OpsWorks::Stack.DefaultSshKeyName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-defaultsshkeyname
     * @external
     */
    defaultSshKeyName: string | undefined;
    /**
     * `AWS::OpsWorks::Stack.DefaultSubnetId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#defaultsubnet
     * @external
     */
    defaultSubnetId: string | undefined;
    /**
     * `AWS::OpsWorks::Stack.EcsClusterArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-ecsclusterarn
     * @external
     */
    ecsClusterArn: string | undefined;
    /**
     * `AWS::OpsWorks::Stack.ElasticIps`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-elasticips
     * @external
     */
    elasticIps: Array<CfnStack.ElasticIpProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorks::Stack.HostnameTheme`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-hostnametheme
     * @external
     */
    hostnameTheme: string | undefined;
    /**
     * `AWS::OpsWorks::Stack.RdsDbInstances`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-rdsdbinstances
     * @external
     */
    rdsDbInstances: Array<CfnStack.RdsDbInstanceProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorks::Stack.SourceStackId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-sourcestackid
     * @external
     */
    sourceStackId: string | undefined;
    /**
     * `AWS::OpsWorks::Stack.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::OpsWorks::Stack.UseCustomCookbooks`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#usecustcookbooks
     * @external
     */
    useCustomCookbooks: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorks::Stack.UseOpsworksSecurityGroups`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-useopsworkssecuritygroups
     * @external
     */
    useOpsworksSecurityGroups: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorks::Stack.VpcId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-vpcid
     * @external
     */
    vpcId: string | undefined;
    /**
     * Create a new `AWS::OpsWorks::Stack`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnStackProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::OpsWorks::Stack`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html
 * @external
 * @cloudformationResource AWS::OpsWorks::Stack
 */
export declare namespace CfnStack {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-chefconfiguration.html
     * @external
     */
    interface ChefConfigurationProperty {
        /**
         * `CfnStack.ChefConfigurationProperty.BerkshelfVersion`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-chefconfiguration.html#cfn-opsworks-chefconfiguration-berkshelfversion
         * @external
         */
        readonly berkshelfVersion?: string;
        /**
         * `CfnStack.ChefConfigurationProperty.ManageBerkshelf`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-chefconfiguration.html#cfn-opsworks-chefconfiguration-berkshelfversion
         * @external
         */
        readonly manageBerkshelf?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::OpsWorks::Stack`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html
 * @external
 * @cloudformationResource AWS::OpsWorks::Stack
 */
export declare namespace CfnStack {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-elasticip.html
     * @external
     */
    interface ElasticIpProperty {
        /**
         * `CfnStack.ElasticIpProperty.Ip`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-elasticip.html#cfn-opsworks-stack-elasticip-ip
         * @external
         */
        readonly ip: string;
        /**
         * `CfnStack.ElasticIpProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-elasticip.html#cfn-opsworks-stack-elasticip-name
         * @external
         */
        readonly name?: string;
    }
}
/**
 * A CloudFormation `AWS::OpsWorks::Stack`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html
 * @external
 * @cloudformationResource AWS::OpsWorks::Stack
 */
export declare namespace CfnStack {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-rdsdbinstance.html
     * @external
     */
    interface RdsDbInstanceProperty {
        /**
         * `CfnStack.RdsDbInstanceProperty.DbPassword`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-rdsdbinstance.html#cfn-opsworks-stack-rdsdbinstance-dbpassword
         * @external
         */
        readonly dbPassword: string;
        /**
         * `CfnStack.RdsDbInstanceProperty.DbUser`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-rdsdbinstance.html#cfn-opsworks-stack-rdsdbinstance-dbuser
         * @external
         */
        readonly dbUser: string;
        /**
         * `CfnStack.RdsDbInstanceProperty.RdsDbInstanceArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-rdsdbinstance.html#cfn-opsworks-stack-rdsdbinstance-rdsdbinstancearn
         * @external
         */
        readonly rdsDbInstanceArn: string;
    }
}
/**
 * A CloudFormation `AWS::OpsWorks::Stack`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html
 * @external
 * @cloudformationResource AWS::OpsWorks::Stack
 */
export declare namespace CfnStack {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-source.html
     * @external
     */
    interface SourceProperty {
        /**
         * `CfnStack.SourceProperty.Password`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-source.html#cfn-opsworks-custcookbooksource-password
         * @external
         */
        readonly password?: string;
        /**
         * `CfnStack.SourceProperty.Revision`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-source.html#cfn-opsworks-custcookbooksource-revision
         * @external
         */
        readonly revision?: string;
        /**
         * `CfnStack.SourceProperty.SshKey`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-source.html#cfn-opsworks-custcookbooksource-sshkey
         * @external
         */
        readonly sshKey?: string;
        /**
         * `CfnStack.SourceProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-source.html#cfn-opsworks-custcookbooksource-type
         * @external
         */
        readonly type?: string;
        /**
         * `CfnStack.SourceProperty.Url`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-source.html#cfn-opsworks-custcookbooksource-url
         * @external
         */
        readonly url?: string;
        /**
         * `CfnStack.SourceProperty.Username`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-source.html#cfn-opsworks-custcookbooksource-username
         * @external
         */
        readonly username?: string;
    }
}
/**
 * A CloudFormation `AWS::OpsWorks::Stack`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html
 * @external
 * @cloudformationResource AWS::OpsWorks::Stack
 */
export declare namespace CfnStack {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-stackconfigmanager.html
     * @external
     */
    interface StackConfigurationManagerProperty {
        /**
         * `CfnStack.StackConfigurationManagerProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-stackconfigmanager.html#cfn-opsworks-configmanager-name
         * @external
         */
        readonly name?: string;
        /**
         * `CfnStack.StackConfigurationManagerProperty.Version`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-stackconfigmanager.html#cfn-opsworks-configmanager-version
         * @external
         */
        readonly version?: string;
    }
}
/**
 * Properties for defining a `AWS::OpsWorks::UserProfile`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-userprofile.html
 * @external
 */
export interface CfnUserProfileProps {
    /**
     * `AWS::OpsWorks::UserProfile.IamUserArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-userprofile.html#cfn-opsworks-userprofile-iamuserarn
     * @external
     */
    readonly iamUserArn: string;
    /**
     * `AWS::OpsWorks::UserProfile.AllowSelfManagement`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-userprofile.html#cfn-opsworks-userprofile-allowselfmanagement
     * @external
     */
    readonly allowSelfManagement?: boolean | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::UserProfile.SshPublicKey`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-userprofile.html#cfn-opsworks-userprofile-sshpublickey
     * @external
     */
    readonly sshPublicKey?: string;
    /**
     * `AWS::OpsWorks::UserProfile.SshUsername`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-userprofile.html#cfn-opsworks-userprofile-sshusername
     * @external
     */
    readonly sshUsername?: string;
}
/**
 * A CloudFormation `AWS::OpsWorks::UserProfile`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-userprofile.html
 * @external
 * @cloudformationResource AWS::OpsWorks::UserProfile
 */
export declare class CfnUserProfile extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::OpsWorks::UserProfile";
    /**
     * @external
     * @cloudformationAttribute SshUsername
     */
    readonly attrSshUsername: string;
    /**
     * `AWS::OpsWorks::UserProfile.IamUserArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-userprofile.html#cfn-opsworks-userprofile-iamuserarn
     * @external
     */
    iamUserArn: string;
    /**
     * `AWS::OpsWorks::UserProfile.AllowSelfManagement`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-userprofile.html#cfn-opsworks-userprofile-allowselfmanagement
     * @external
     */
    allowSelfManagement: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorks::UserProfile.SshPublicKey`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-userprofile.html#cfn-opsworks-userprofile-sshpublickey
     * @external
     */
    sshPublicKey: string | undefined;
    /**
     * `AWS::OpsWorks::UserProfile.SshUsername`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-userprofile.html#cfn-opsworks-userprofile-sshusername
     * @external
     */
    sshUsername: string | undefined;
    /**
     * Create a new `AWS::OpsWorks::UserProfile`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnUserProfileProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::OpsWorks::Volume`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-volume.html
 * @external
 */
export interface CfnVolumeProps {
    /**
     * `AWS::OpsWorks::Volume.Ec2VolumeId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-volume.html#cfn-opsworks-volume-ec2volumeid
     * @external
     */
    readonly ec2VolumeId: string;
    /**
     * `AWS::OpsWorks::Volume.StackId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-volume.html#cfn-opsworks-volume-stackid
     * @external
     */
    readonly stackId: string;
    /**
     * `AWS::OpsWorks::Volume.MountPoint`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-volume.html#cfn-opsworks-volume-mountpoint
     * @external
     */
    readonly mountPoint?: string;
    /**
     * `AWS::OpsWorks::Volume.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-volume.html#cfn-opsworks-volume-name
     * @external
     */
    readonly name?: string;
}
/**
 * A CloudFormation `AWS::OpsWorks::Volume`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-volume.html
 * @external
 * @cloudformationResource AWS::OpsWorks::Volume
 */
export declare class CfnVolume extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::OpsWorks::Volume";
    /**
     * `AWS::OpsWorks::Volume.Ec2VolumeId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-volume.html#cfn-opsworks-volume-ec2volumeid
     * @external
     */
    ec2VolumeId: string;
    /**
     * `AWS::OpsWorks::Volume.StackId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-volume.html#cfn-opsworks-volume-stackid
     * @external
     */
    stackId: string;
    /**
     * `AWS::OpsWorks::Volume.MountPoint`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-volume.html#cfn-opsworks-volume-mountpoint
     * @external
     */
    mountPoint: string | undefined;
    /**
     * `AWS::OpsWorks::Volume.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-volume.html#cfn-opsworks-volume-name
     * @external
     */
    name: string | undefined;
    /**
     * Create a new `AWS::OpsWorks::Volume`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVolumeProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
