import * as cdk from "../../core";
/**
 * Properties for defining a `AWS::ManagedBlockchain::Member`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html
 * @external
 */
export interface CfnMemberProps {
    /**
     * `AWS::ManagedBlockchain::Member.MemberConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html#cfn-managedblockchain-member-memberconfiguration
     * @external
     */
    readonly memberConfiguration: CfnMember.MemberConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::ManagedBlockchain::Member.InvitationId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html#cfn-managedblockchain-member-invitationid
     * @external
     */
    readonly invitationId?: string;
    /**
     * `AWS::ManagedBlockchain::Member.NetworkConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html#cfn-managedblockchain-member-networkconfiguration
     * @external
     */
    readonly networkConfiguration?: CfnMember.NetworkConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::ManagedBlockchain::Member.NetworkId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html#cfn-managedblockchain-member-networkid
     * @external
     */
    readonly networkId?: string;
}
/**
 * A CloudFormation `AWS::ManagedBlockchain::Member`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html
 * @external
 * @cloudformationResource AWS::ManagedBlockchain::Member
 */
export declare class CfnMember extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ManagedBlockchain::Member";
    /**
     * @external
     * @cloudformationAttribute MemberId
     */
    readonly attrMemberId: string;
    /**
     * @external
     * @cloudformationAttribute NetworkId
     */
    readonly attrNetworkId: string;
    /**
     * `AWS::ManagedBlockchain::Member.MemberConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html#cfn-managedblockchain-member-memberconfiguration
     * @external
     */
    memberConfiguration: CfnMember.MemberConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::ManagedBlockchain::Member.InvitationId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html#cfn-managedblockchain-member-invitationid
     * @external
     */
    invitationId: string | undefined;
    /**
     * `AWS::ManagedBlockchain::Member.NetworkConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html#cfn-managedblockchain-member-networkconfiguration
     * @external
     */
    networkConfiguration: CfnMember.NetworkConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ManagedBlockchain::Member.NetworkId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html#cfn-managedblockchain-member-networkid
     * @external
     */
    networkId: string | undefined;
    /**
     * Create a new `AWS::ManagedBlockchain::Member`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnMemberProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ManagedBlockchain::Member`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html
 * @external
 * @cloudformationResource AWS::ManagedBlockchain::Member
 */
export declare namespace CfnMember {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-approvalthresholdpolicy.html
     * @external
     */
    interface ApprovalThresholdPolicyProperty {
        /**
         * `CfnMember.ApprovalThresholdPolicyProperty.ProposalDurationInHours`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-approvalthresholdpolicy.html#cfn-managedblockchain-member-approvalthresholdpolicy-proposaldurationinhours
         * @external
         */
        readonly proposalDurationInHours?: number;
        /**
         * `CfnMember.ApprovalThresholdPolicyProperty.ThresholdComparator`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-approvalthresholdpolicy.html#cfn-managedblockchain-member-approvalthresholdpolicy-thresholdcomparator
         * @external
         */
        readonly thresholdComparator?: string;
        /**
         * `CfnMember.ApprovalThresholdPolicyProperty.ThresholdPercentage`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-approvalthresholdpolicy.html#cfn-managedblockchain-member-approvalthresholdpolicy-thresholdpercentage
         * @external
         */
        readonly thresholdPercentage?: number;
    }
}
/**
 * A CloudFormation `AWS::ManagedBlockchain::Member`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html
 * @external
 * @cloudformationResource AWS::ManagedBlockchain::Member
 */
export declare namespace CfnMember {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-memberconfiguration.html
     * @external
     */
    interface MemberConfigurationProperty {
        /**
         * `CfnMember.MemberConfigurationProperty.Description`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-memberconfiguration.html#cfn-managedblockchain-member-memberconfiguration-description
         * @external
         */
        readonly description?: string;
        /**
         * `CfnMember.MemberConfigurationProperty.MemberFrameworkConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-memberconfiguration.html#cfn-managedblockchain-member-memberconfiguration-memberframeworkconfiguration
         * @external
         */
        readonly memberFrameworkConfiguration?: CfnMember.MemberFrameworkConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnMember.MemberConfigurationProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-memberconfiguration.html#cfn-managedblockchain-member-memberconfiguration-name
         * @external
         */
        readonly name: string;
    }
}
/**
 * A CloudFormation `AWS::ManagedBlockchain::Member`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html
 * @external
 * @cloudformationResource AWS::ManagedBlockchain::Member
 */
export declare namespace CfnMember {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-memberfabricconfiguration.html
     * @external
     */
    interface MemberFabricConfigurationProperty {
        /**
         * `CfnMember.MemberFabricConfigurationProperty.AdminPassword`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-memberfabricconfiguration.html#cfn-managedblockchain-member-memberfabricconfiguration-adminpassword
         * @external
         */
        readonly adminPassword: string;
        /**
         * `CfnMember.MemberFabricConfigurationProperty.AdminUsername`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-memberfabricconfiguration.html#cfn-managedblockchain-member-memberfabricconfiguration-adminusername
         * @external
         */
        readonly adminUsername: string;
    }
}
/**
 * A CloudFormation `AWS::ManagedBlockchain::Member`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html
 * @external
 * @cloudformationResource AWS::ManagedBlockchain::Member
 */
export declare namespace CfnMember {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-memberframeworkconfiguration.html
     * @external
     */
    interface MemberFrameworkConfigurationProperty {
        /**
         * `CfnMember.MemberFrameworkConfigurationProperty.MemberFabricConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-memberframeworkconfiguration.html#cfn-managedblockchain-member-memberframeworkconfiguration-memberfabricconfiguration
         * @external
         */
        readonly memberFabricConfiguration?: CfnMember.MemberFabricConfigurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::ManagedBlockchain::Member`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html
 * @external
 * @cloudformationResource AWS::ManagedBlockchain::Member
 */
export declare namespace CfnMember {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkconfiguration.html
     * @external
     */
    interface NetworkConfigurationProperty {
        /**
         * `CfnMember.NetworkConfigurationProperty.Description`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkconfiguration.html#cfn-managedblockchain-member-networkconfiguration-description
         * @external
         */
        readonly description?: string;
        /**
         * `CfnMember.NetworkConfigurationProperty.Framework`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkconfiguration.html#cfn-managedblockchain-member-networkconfiguration-framework
         * @external
         */
        readonly framework: string;
        /**
         * `CfnMember.NetworkConfigurationProperty.FrameworkVersion`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkconfiguration.html#cfn-managedblockchain-member-networkconfiguration-frameworkversion
         * @external
         */
        readonly frameworkVersion: string;
        /**
         * `CfnMember.NetworkConfigurationProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkconfiguration.html#cfn-managedblockchain-member-networkconfiguration-name
         * @external
         */
        readonly name: string;
        /**
         * `CfnMember.NetworkConfigurationProperty.NetworkFrameworkConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkconfiguration.html#cfn-managedblockchain-member-networkconfiguration-networkframeworkconfiguration
         * @external
         */
        readonly networkFrameworkConfiguration?: CfnMember.NetworkFrameworkConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnMember.NetworkConfigurationProperty.VotingPolicy`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkconfiguration.html#cfn-managedblockchain-member-networkconfiguration-votingpolicy
         * @external
         */
        readonly votingPolicy: CfnMember.VotingPolicyProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::ManagedBlockchain::Member`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html
 * @external
 * @cloudformationResource AWS::ManagedBlockchain::Member
 */
export declare namespace CfnMember {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkfabricconfiguration.html
     * @external
     */
    interface NetworkFabricConfigurationProperty {
        /**
         * `CfnMember.NetworkFabricConfigurationProperty.Edition`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkfabricconfiguration.html#cfn-managedblockchain-member-networkfabricconfiguration-edition
         * @external
         */
        readonly edition: string;
    }
}
/**
 * A CloudFormation `AWS::ManagedBlockchain::Member`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html
 * @external
 * @cloudformationResource AWS::ManagedBlockchain::Member
 */
export declare namespace CfnMember {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkframeworkconfiguration.html
     * @external
     */
    interface NetworkFrameworkConfigurationProperty {
        /**
         * `CfnMember.NetworkFrameworkConfigurationProperty.NetworkFabricConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkframeworkconfiguration.html#cfn-managedblockchain-member-networkframeworkconfiguration-networkfabricconfiguration
         * @external
         */
        readonly networkFabricConfiguration?: CfnMember.NetworkFabricConfigurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::ManagedBlockchain::Member`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html
 * @external
 * @cloudformationResource AWS::ManagedBlockchain::Member
 */
export declare namespace CfnMember {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-votingpolicy.html
     * @external
     */
    interface VotingPolicyProperty {
        /**
         * `CfnMember.VotingPolicyProperty.ApprovalThresholdPolicy`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-votingpolicy.html#cfn-managedblockchain-member-votingpolicy-approvalthresholdpolicy
         * @external
         */
        readonly approvalThresholdPolicy?: CfnMember.ApprovalThresholdPolicyProperty | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::ManagedBlockchain::Node`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-node.html
 * @external
 */
export interface CfnNodeProps {
    /**
     * `AWS::ManagedBlockchain::Node.MemberId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-node.html#cfn-managedblockchain-node-memberid
     * @external
     */
    readonly memberId: string;
    /**
     * `AWS::ManagedBlockchain::Node.NetworkId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-node.html#cfn-managedblockchain-node-networkid
     * @external
     */
    readonly networkId: string;
    /**
     * `AWS::ManagedBlockchain::Node.NodeConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-node.html#cfn-managedblockchain-node-nodeconfiguration
     * @external
     */
    readonly nodeConfiguration: CfnNode.NodeConfigurationProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::ManagedBlockchain::Node`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-node.html
 * @external
 * @cloudformationResource AWS::ManagedBlockchain::Node
 */
export declare class CfnNode extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ManagedBlockchain::Node";
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute MemberId
     */
    readonly attrMemberId: string;
    /**
     * @external
     * @cloudformationAttribute NetworkId
     */
    readonly attrNetworkId: string;
    /**
     * @external
     * @cloudformationAttribute NodeId
     */
    readonly attrNodeId: string;
    /**
     * `AWS::ManagedBlockchain::Node.MemberId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-node.html#cfn-managedblockchain-node-memberid
     * @external
     */
    memberId: string;
    /**
     * `AWS::ManagedBlockchain::Node.NetworkId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-node.html#cfn-managedblockchain-node-networkid
     * @external
     */
    networkId: string;
    /**
     * `AWS::ManagedBlockchain::Node.NodeConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-node.html#cfn-managedblockchain-node-nodeconfiguration
     * @external
     */
    nodeConfiguration: CfnNode.NodeConfigurationProperty | cdk.IResolvable;
    /**
     * Create a new `AWS::ManagedBlockchain::Node`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnNodeProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ManagedBlockchain::Node`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-node.html
 * @external
 * @cloudformationResource AWS::ManagedBlockchain::Node
 */
export declare namespace CfnNode {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-node-nodeconfiguration.html
     * @external
     */
    interface NodeConfigurationProperty {
        /**
         * `CfnNode.NodeConfigurationProperty.AvailabilityZone`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-node-nodeconfiguration.html#cfn-managedblockchain-node-nodeconfiguration-availabilityzone
         * @external
         */
        readonly availabilityZone: string;
        /**
         * `CfnNode.NodeConfigurationProperty.InstanceType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-node-nodeconfiguration.html#cfn-managedblockchain-node-nodeconfiguration-instancetype
         * @external
         */
        readonly instanceType: string;
    }
}
