/**
 * (experimental) Interface for objects that can render themselves to log patterns.
 *
 * @experimental
 */
export interface IFilterPattern {
    /**
     * @experimental
     */
    readonly logPatternString: string;
}
/**
 * (experimental) Base class for patterns that only match JSON log events.
 *
 * @experimental
 */
export declare abstract class JsonPattern implements IFilterPattern {
    readonly jsonPatternString: string;
    /**
     * @experimental
     */
    constructor(jsonPatternString: string);
    /**
     * @experimental
     */
    get logPatternString(): string;
}
/**
 * (experimental) A collection of static methods to generate appropriate ILogPatterns.
 *
 * @experimental
 */
export declare class FilterPattern {
    /**
     * (experimental) Use the given string as log pattern.
     *
     * See https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html
     * for information on writing log patterns.
     *
     * @param logPatternString The pattern string to use.
     * @experimental
     */
    static literal(logPatternString: string): IFilterPattern;
    /**
     * (experimental) A log pattern that matches all events.
     *
     * @experimental
     */
    static allEvents(): IFilterPattern;
    /**
     * (experimental) A log pattern that matches if all the strings given appear in the event.
     *
     * @param terms The words to search for.
     * @experimental
     */
    static allTerms(...terms: string[]): IFilterPattern;
    /**
     * (experimental) A log pattern that matches if any of the strings given appear in the event.
     *
     * @param terms The words to search for.
     * @experimental
     */
    static anyTerm(...terms: string[]): IFilterPattern;
    /**
     * (experimental) A log pattern that matches if any of the given term groups matches the event.
     *
     * A term group matches an event if all the terms in it appear in the event string.
     *
     * @param termGroups A list of term groups to search for.
     * @experimental
     */
    static anyTermGroup(...termGroups: string[][]): IFilterPattern;
    /**
     * (experimental) A JSON log pattern that compares string values.
     *
     * This pattern only matches if the event is a JSON event, and the indicated field inside
     * compares with the string value.
     *
     * Use '$' to indicate the root of the JSON structure. The comparison operator can only
     * compare equality or inequality. The '*' wildcard may appear in the value may at the
     * start or at the end.
     *
     * For more information, see:
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html
     *
     * @param jsonField Field inside JSON.
     * @param comparison Comparison to carry out.
     * @param value The string value to compare to.
     * @experimental
     */
    static stringValue(jsonField: string, comparison: string, value: string): JsonPattern;
    /**
     * (experimental) A JSON log pattern that compares numerical values.
     *
     * This pattern only matches if the event is a JSON event, and the indicated field inside
     * compares with the value in the indicated way.
     *
     * Use '$' to indicate the root of the JSON structure. The comparison operator can only
     * compare equality or inequality. The '*' wildcard may appear in the value may at the
     * start or at the end.
     *
     * For more information, see:
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html
     *
     * @param jsonField Field inside JSON.
     * @param comparison Comparison to carry out.
     * @param value The numerical value to compare to.
     * @experimental
     */
    static numberValue(jsonField: string, comparison: string, value: number): JsonPattern;
    /**
     * (experimental) A JSON log pattern that matches if the field exists and has the special value 'null'.
     *
     * @param jsonField Field inside JSON.
     * @experimental
     */
    static isNull(jsonField: string): JsonPattern;
    /**
     * (experimental) A JSON log pattern that matches if the field does not exist.
     *
     * @param jsonField Field inside JSON.
     * @experimental
     */
    static notExists(jsonField: string): JsonPattern;
    /**
     * (experimental) A JSON log patter that matches if the field exists.
     *
     * This is a readable convenience wrapper over 'field = *'
     *
     * @param jsonField Field inside JSON.
     * @experimental
     */
    static exists(jsonField: string): JsonPattern;
    /**
     * (experimental) A JSON log pattern that matches if the field exists and equals the boolean value.
     *
     * @param jsonField Field inside JSON.
     * @param value The value to match.
     * @experimental
     */
    static booleanValue(jsonField: string, value: boolean): JsonPattern;
    /**
     * (experimental) A JSON log pattern that matches if all given JSON log patterns match.
     *
     * @experimental
     */
    static all(...patterns: JsonPattern[]): JsonPattern;
    /**
     * (experimental) A JSON log pattern that matches if any of the given JSON log patterns match.
     *
     * @experimental
     */
    static any(...patterns: JsonPattern[]): JsonPattern;
    /**
     * (experimental) A space delimited log pattern matcher.
     *
     * The log event is divided into space-delimited columns (optionally
     * enclosed by "" or [] to capture spaces into column values), and names
     * are given to each column.
     *
     * '...' may be specified once to match any number of columns.
     *
     * Afterwards, conditions may be added to individual columns.
     *
     * @param columns The columns in the space-delimited log stream.
     * @experimental
     */
    static spaceDelimited(...columns: string[]): SpaceDelimitedTextPattern;
}
export declare type RestrictionMap = {
    [column: string]: ColumnRestriction[];
};
/**
 * (experimental) Space delimited text pattern.
 *
 * @experimental
 */
export declare class SpaceDelimitedTextPattern implements IFilterPattern {
    private readonly columns;
    private readonly restrictions;
    /**
     * (experimental) Construct a new instance of a space delimited text pattern.
     *
     * Since this class must be public, we can't rely on the user only creating it through
     * the `LogPattern.spaceDelimited()` factory function. We must therefore validate the
     * argument in the constructor. Since we're returning a copy on every mutation, and we
     * don't want to re-validate the same things on every construction, we provide a limited
     * set of mutator functions and only validate the new data every time.
     *
     * @experimental
     */
    static construct(columns: string[]): SpaceDelimitedTextPattern;
    /**
     * @experimental
     */
    protected constructor(columns: string[], restrictions: RestrictionMap);
    /**
     * (experimental) Restrict where the pattern applies.
     *
     * @experimental
     */
    whereString(columnName: string, comparison: string, value: string): SpaceDelimitedTextPattern;
    /**
     * (experimental) Restrict where the pattern applies.
     *
     * @experimental
     */
    whereNumber(columnName: string, comparison: string, value: number): SpaceDelimitedTextPattern;
    /**
     * @experimental
     */
    get logPatternString(): string;
    /**
     * Return the column expression for the given column
     */
    private columnExpression;
    /**
     * Make a copy of the current restrictions and add one
     */
    private addRestriction;
}
/**
 * @experimental
 */
export interface ColumnRestriction {
    /**
     * (experimental) Comparison operator to use.
     *
     * @experimental
     */
    readonly comparison: string;
    /**
     * (experimental) String value to compare to.
     *
     * Exactly one of 'stringValue' and 'numberValue' must be set.
     *
     * @experimental
     */
    readonly stringValue?: string;
    /**
     * (experimental) Number value to compare to.
     *
     * Exactly one of 'stringValue' and 'numberValue' must be set.
     *
     * @experimental
     */
    readonly numberValue?: number;
}
