import { BundlingDockerImage } from "../../core";
/**
 * @experimental
 */
export interface LambdaRuntimeProps {
    /**
     * (experimental) Whether the ``ZipFile`` (aka inline code) property can be used with this runtime.
     *
     * @default false
     * @experimental
     */
    readonly supportsInlineCode?: boolean;
    /**
     * (experimental) The Docker image name to be used for bundling in this runtime.
     *
     * @default - the latest docker image "amazon/aws-sam-cli-build-image-<runtime>" from https://hub.docker.com/u/amazon
     * @experimental
     */
    readonly bundlingDockerImage?: string;
}
/**
 * @experimental
 */
export declare enum RuntimeFamily {
    /**
     * @experimental
     */
    NODEJS = 0,
    /**
     * @experimental
     */
    JAVA = 1,
    /**
     * @experimental
     */
    PYTHON = 2,
    /**
     * @experimental
     */
    DOTNET_CORE = 3,
    /**
     * @experimental
     */
    GO = 4,
    /**
     * @experimental
     */
    RUBY = 5,
    /**
     * @experimental
     */
    OTHER = 6
}
/**
 * (experimental) Lambda function runtime environment.
 *
 * If you need to use a runtime name that doesn't exist as a static member, you
 * can instantiate a `Runtime` object, e.g: `new Runtime('nodejs99.99')`.
 *
 * @experimental
 */
export declare class Runtime {
    /**
     * (experimental) A list of all known `Runtime`'s.
     *
     * @experimental
     */
    static readonly ALL: Runtime[];
    /**
     * (deprecated) The NodeJS runtime (nodejs).
     *
     * @deprecated Use {@link NODEJS_10_X}
     */
    static readonly NODEJS: Runtime;
    /**
     * (deprecated) The NodeJS 4.3 runtime (nodejs4.3).
     *
     * @deprecated Use {@link NODEJS_10_X}
     */
    static readonly NODEJS_4_3: Runtime;
    /**
     * (deprecated) The NodeJS 6.10 runtime (nodejs6.10).
     *
     * @deprecated Use {@link NODEJS_10_X}
     */
    static readonly NODEJS_6_10: Runtime;
    /**
     * (deprecated) The NodeJS 8.10 runtime (nodejs8.10).
     *
     * @deprecated Use {@link NODEJS_10_X}
     */
    static readonly NODEJS_8_10: Runtime;
    /**
     * (experimental) The NodeJS 10.x runtime (nodejs10.x).
     *
     * @experimental
     */
    static readonly NODEJS_10_X: Runtime;
    /**
     * (experimental) The NodeJS 12.x runtime (nodejs12.x).
     *
     * @experimental
     */
    static readonly NODEJS_12_X: Runtime;
    /**
     * (experimental) The Python 2.7 runtime (python2.7).
     *
     * @experimental
     */
    static readonly PYTHON_2_7: Runtime;
    /**
     * (experimental) The Python 3.6 runtime (python3.6).
     *
     * @experimental
     */
    static readonly PYTHON_3_6: Runtime;
    /**
     * (experimental) The Python 3.7 runtime (python3.7).
     *
     * @experimental
     */
    static readonly PYTHON_3_7: Runtime;
    /**
     * (experimental) The Python 3.8 runtime (python3.8).
     *
     * @experimental
     */
    static readonly PYTHON_3_8: Runtime;
    /**
     * (experimental) The Java 8 runtime (java8).
     *
     * @experimental
     */
    static readonly JAVA_8: Runtime;
    /**
     * (experimental) The Java 8 Corretto runtime (java8.al2).
     *
     * @experimental
     */
    static readonly JAVA_8_CORRETTO: Runtime;
    /**
     * (experimental) The Java 11 runtime (java11).
     *
     * @experimental
     */
    static readonly JAVA_11: Runtime;
    /**
     * (deprecated) The .NET Core 1.0 runtime (dotnetcore1.0).
     *
     * @deprecated Use {@link DOTNET_CORE_2_1}
     */
    static readonly DOTNET_CORE_1: Runtime;
    /**
     * (deprecated) The .NET Core 2.0 runtime (dotnetcore2.0).
     *
     * @deprecated Use {@link DOTNET_CORE_2_1}
     */
    static readonly DOTNET_CORE_2: Runtime;
    /**
     * (experimental) The .NET Core 2.1 runtime (dotnetcore2.1).
     *
     * @experimental
     */
    static readonly DOTNET_CORE_2_1: Runtime;
    /**
     * (experimental) The .NET Core 3.1 runtime (dotnetcore3.1).
     *
     * @experimental
     */
    static readonly DOTNET_CORE_3_1: Runtime;
    /**
     * (experimental) The Go 1.x runtime (go1.x).
     *
     * @experimental
     */
    static readonly GO_1_X: Runtime;
    /**
     * (experimental) The Ruby 2.5 runtime (ruby2.5).
     *
     * @experimental
     */
    static readonly RUBY_2_5: Runtime;
    /**
     * (experimental) The Ruby 2.7 runtime (ruby2.7).
     *
     * @experimental
     */
    static readonly RUBY_2_7: Runtime;
    /**
     * (experimental) The custom provided runtime (provided).
     *
     * @experimental
     */
    static readonly PROVIDED: Runtime;
    /**
     * (experimental) The custom provided runtime (provided).
     *
     * @experimental
     */
    static readonly PROVIDED_AL2: Runtime;
    /**
     * (experimental) The name of this runtime, as expected by the Lambda resource.
     *
     * @experimental
     */
    readonly name: string;
    /**
     * (experimental) Whether the ``ZipFile`` (aka inline code) property can be used with this runtime.
     *
     * @experimental
     */
    readonly supportsInlineCode: boolean;
    /**
     * (experimental) The runtime family.
     *
     * @experimental
     */
    readonly family?: RuntimeFamily;
    /**
     * (experimental) The bundling Docker image for this runtime.
     *
     * @experimental
     */
    readonly bundlingDockerImage: BundlingDockerImage;
    /**
     * @experimental
     */
    constructor(name: string, family?: RuntimeFamily, props?: LambdaRuntimeProps);
    /**
     * @experimental
     */
    toString(): string;
    /**
     * @experimental
     */
    runtimeEquals(other: Runtime): boolean;
}
