import { IResource, Resource } from "../../core";
import { Construct } from 'constructs';
import { Code } from './code';
import { Runtime } from './runtime';
/**
 * @experimental
 */
export interface LayerVersionProps {
    /**
     * (experimental) The runtimes compatible with this Layer.
     *
     * @default - All runtimes are supported.
     * @experimental
     */
    readonly compatibleRuntimes?: Runtime[];
    /**
     * (experimental) The content of this Layer.
     *
     * Using `Code.fromInline` is not supported.
     *
     * @experimental
     */
    readonly code: Code;
    /**
     * (experimental) The description the this Lambda Layer.
     *
     * @default - No description.
     * @experimental
     */
    readonly description?: string;
    /**
     * (experimental) The SPDX licence identifier or URL to the license file for this layer.
     *
     * @default - No license information will be recorded.
     * @experimental
     */
    readonly license?: string;
    /**
     * (experimental) The name of the layer.
     *
     * @default - A name will be generated.
     * @experimental
     */
    readonly layerVersionName?: string;
}
/**
 * @experimental
 */
export interface ILayerVersion extends IResource {
    /**
     * (experimental) The ARN of the Lambda Layer version that this Layer defines.
     *
     * @experimental
     * @attribute true
     */
    readonly layerVersionArn: string;
    /**
     * (experimental) The runtimes compatible with this Layer.
     *
     * @default Runtime.All
     * @experimental
     */
    readonly compatibleRuntimes?: Runtime[];
    /**
     * (experimental) Add permission for this layer version to specific entities.
     *
     * Usage within
     * the same account where the layer is defined is always allowed and does not
     * require calling this method. Note that the principal that creates the
     * Lambda function using the layer (for example, a CloudFormation changeset
     * execution role) also needs to have the ``lambda:GetLayerVersion``
     * permission on the layer version.
     *
     * @param id the ID of the grant in the construct tree.
     * @param permission the identification of the grantee.
     * @experimental
     */
    addPermission(id: string, permission: LayerVersionPermission): void;
}
/**
 * A reference to a Lambda Layer version.
 */
declare abstract class LayerVersionBase extends Resource implements ILayerVersion {
    abstract readonly layerVersionArn: string;
    abstract readonly compatibleRuntimes?: Runtime[];
    /**
     * (experimental) Add permission for this layer version to specific entities.
     *
     * Usage within
     * the same account where the layer is defined is always allowed and does not
     * require calling this method. Note that the principal that creates the
     * Lambda function using the layer (for example, a CloudFormation changeset
     * execution role) also needs to have the ``lambda:GetLayerVersion``
     * permission on the layer version.
     *
     * @experimental
     */
    addPermission(id: string, permission: LayerVersionPermission): void;
}
/**
 * (experimental) Identification of an account (or organization) that is allowed to access a Lambda Layer Version.
 *
 * @experimental
 */
export interface LayerVersionPermission {
    /**
     * (experimental) The AWS Account id of the account that is authorized to use a Lambda Layer Version.
     *
     * The wild-card ``'*'`` can be
     * used to grant access to "any" account (or any account in an organization when ``organizationId`` is specified).
     *
     * @experimental
     */
    readonly accountId: string;
    /**
     * (experimental) The ID of the AWS Organization to hwich the grant is restricted.
     *
     * Can only be specified if ``accountId`` is ``'*'``
     *
     * @experimental
     */
    readonly organizationId?: string;
}
/**
 * (experimental) Properties necessary to import a LayerVersion.
 *
 * @experimental
 */
export interface LayerVersionAttributes {
    /**
     * (experimental) The ARN of the LayerVersion.
     *
     * @experimental
     */
    readonly layerVersionArn: string;
    /**
     * (experimental) The list of compatible runtimes with this Layer.
     *
     * @experimental
     */
    readonly compatibleRuntimes?: Runtime[];
}
/**
 * (experimental) Defines a new Lambda Layer version.
 *
 * @experimental
 */
export declare class LayerVersion extends LayerVersionBase {
    /**
     * (experimental) Imports a layer version by ARN.
     *
     * Assumes it is compatible with all Lambda runtimes.
     *
     * @experimental
     */
    static fromLayerVersionArn(scope: Construct, id: string, layerVersionArn: string): ILayerVersion;
    /**
     * (experimental) Imports a Layer that has been defined externally.
     *
     * @param scope the parent Construct that will use the imported layer.
     * @param id the id of the imported layer in the construct tree.
     * @param attrs the properties of the imported layer.
     * @experimental
     */
    static fromLayerVersionAttributes(scope: Construct, id: string, attrs: LayerVersionAttributes): ILayerVersion;
    /**
     * (experimental) The ARN of the Lambda Layer version that this Layer defines.
     *
     * @experimental
     */
    readonly layerVersionArn: string;
    /**
     * (experimental) The runtimes compatible with this Layer.
     *
     * @experimental
     */
    readonly compatibleRuntimes?: Runtime[];
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: LayerVersionProps);
}
export {};
