"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EventInvokeConfig = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const destination_1 = require("./destination");
const lambda_generated_1 = require("./lambda.generated");
/**
 * (experimental) Configure options for asynchronous invocation on a version or an alias.
 *
 * By default, Lambda retries an asynchronous invocation twice if the function
 * returns an error. It retains events in a queue for up to six hours. When an
 * event fails all processing attempts or stays in the asynchronous invocation
 * queue for too long, Lambda discards it.
 *
 * @experimental
 */
class EventInvokeConfig extends core_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        if (props.maxEventAge && (props.maxEventAge.toSeconds() < 60 || props.maxEventAge.toSeconds() > 21600)) {
            throw new Error('`maximumEventAge` must represent a `Duration` that is between 60 and 21600 seconds.');
        }
        if (props.retryAttempts && (props.retryAttempts < 0 || props.retryAttempts > 2)) {
            throw new Error('`retryAttempts` must be between 0 and 2.');
        }
        new lambda_generated_1.CfnEventInvokeConfig(this, 'Resource', {
            destinationConfig: props.onFailure || props.onSuccess
                ? {
                    ...props.onFailure ? { onFailure: props.onFailure.bind(this, props.function, { type: destination_1.DestinationType.FAILURE }) } : {},
                    ...props.onSuccess ? { onSuccess: props.onSuccess.bind(this, props.function, { type: destination_1.DestinationType.SUCCESS }) } : {},
                }
                : undefined,
            functionName: props.function.functionName,
            maximumEventAgeInSeconds: props.maxEventAge && props.maxEventAge.toSeconds(),
            maximumRetryAttempts: props.retryAttempts !== undefined ? props.retryAttempts : undefined,
            qualifier: props.qualifier || '$LATEST',
        });
    }
}
exports.EventInvokeConfig = EventInvokeConfig;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZXZlbnQtaW52b2tlLWNvbmZpZy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImV2ZW50LWludm9rZS1jb25maWcudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEscUNBQWdELENBQUMsZ0RBQWdEO0FBRWpHLCtDQUE4RDtBQUU5RCx5REFBMEQ7Ozs7Ozs7Ozs7O0FBNEQxRCxNQUFhLGlCQUFrQixTQUFRLGVBQVE7Ozs7SUFDM0MsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUE2QjtRQUNuRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQ2pCLElBQUksS0FBSyxDQUFDLFdBQVcsSUFBSSxDQUFDLEtBQUssQ0FBQyxXQUFXLENBQUMsU0FBUyxFQUFFLEdBQUcsRUFBRSxJQUFJLEtBQUssQ0FBQyxXQUFXLENBQUMsU0FBUyxFQUFFLEdBQUcsS0FBSyxDQUFDLEVBQUU7WUFDcEcsTUFBTSxJQUFJLEtBQUssQ0FBQyxxRkFBcUYsQ0FBQyxDQUFDO1NBQzFHO1FBQ0QsSUFBSSxLQUFLLENBQUMsYUFBYSxJQUFJLENBQUMsS0FBSyxDQUFDLGFBQWEsR0FBRyxDQUFDLElBQUksS0FBSyxDQUFDLGFBQWEsR0FBRyxDQUFDLENBQUMsRUFBRTtZQUM3RSxNQUFNLElBQUksS0FBSyxDQUFDLDBDQUEwQyxDQUFDLENBQUM7U0FDL0Q7UUFDRCxJQUFJLHVDQUFvQixDQUFDLElBQUksRUFBRSxVQUFVLEVBQUU7WUFDdkMsaUJBQWlCLEVBQUUsS0FBSyxDQUFDLFNBQVMsSUFBSSxLQUFLLENBQUMsU0FBUztnQkFDakQsQ0FBQyxDQUFDO29CQUNFLEdBQUcsS0FBSyxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUMsRUFBRSxTQUFTLEVBQUUsS0FBSyxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsSUFBSSxFQUFFLEtBQUssQ0FBQyxRQUFRLEVBQUUsRUFBRSxJQUFJLEVBQUUsNkJBQWUsQ0FBQyxPQUFPLEVBQUUsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLEVBQUU7b0JBQ3RILEdBQUcsS0FBSyxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUMsRUFBRSxTQUFTLEVBQUUsS0FBSyxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsSUFBSSxFQUFFLEtBQUssQ0FBQyxRQUFRLEVBQUUsRUFBRSxJQUFJLEVBQUUsNkJBQWUsQ0FBQyxPQUFPLEVBQUUsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLEVBQUU7aUJBQ3pIO2dCQUNELENBQUMsQ0FBQyxTQUFTO1lBQ2YsWUFBWSxFQUFFLEtBQUssQ0FBQyxRQUFRLENBQUMsWUFBWTtZQUN6Qyx3QkFBd0IsRUFBRSxLQUFLLENBQUMsV0FBVyxJQUFJLEtBQUssQ0FBQyxXQUFXLENBQUMsU0FBUyxFQUFFO1lBQzVFLG9CQUFvQixFQUFFLEtBQUssQ0FBQyxhQUFhLEtBQUssU0FBUyxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsYUFBYSxDQUFDLENBQUMsQ0FBQyxTQUFTO1lBQ3pGLFNBQVMsRUFBRSxLQUFLLENBQUMsU0FBUyxJQUFJLFNBQVM7U0FDMUMsQ0FBQyxDQUFDO0lBQ1AsQ0FBQztDQUNKO0FBdEJELDhDQXNCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IER1cmF0aW9uLCBSZXNvdXJjZSB9IGZyb20gXCIuLi8uLi9jb3JlXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9jb3JlJ1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBEZXN0aW5hdGlvblR5cGUsIElEZXN0aW5hdGlvbiB9IGZyb20gJy4vZGVzdGluYXRpb24nO1xuaW1wb3J0IHsgSUZ1bmN0aW9uIH0gZnJvbSAnLi9mdW5jdGlvbi1iYXNlJztcbmltcG9ydCB7IENmbkV2ZW50SW52b2tlQ29uZmlnIH0gZnJvbSAnLi9sYW1iZGEuZ2VuZXJhdGVkJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgRXZlbnRJbnZva2VDb25maWdPcHRpb25zIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHJlYWRvbmx5IG9uRmFpbHVyZT86IElEZXN0aW5hdGlvbjtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICByZWFkb25seSBvblN1Y2Nlc3M/OiBJRGVzdGluYXRpb247XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcmVhZG9ubHkgbWF4RXZlbnRBZ2U/OiBEdXJhdGlvbjtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICByZWFkb25seSByZXRyeUF0dGVtcHRzPzogbnVtYmVyO1xufVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBFdmVudEludm9rZUNvbmZpZ1Byb3BzIGV4dGVuZHMgRXZlbnRJbnZva2VDb25maWdPcHRpb25zIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHJlYWRvbmx5IGZ1bmN0aW9uOiBJRnVuY3Rpb247XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcmVhZG9ubHkgcXVhbGlmaWVyPzogc3RyaW5nO1xufVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIEV2ZW50SW52b2tlQ29uZmlnIGV4dGVuZHMgUmVzb3VyY2Uge1xuICAgIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBFdmVudEludm9rZUNvbmZpZ1Byb3BzKSB7XG4gICAgICAgIHN1cGVyKHNjb3BlLCBpZCk7XG4gICAgICAgIGlmIChwcm9wcy5tYXhFdmVudEFnZSAmJiAocHJvcHMubWF4RXZlbnRBZ2UudG9TZWNvbmRzKCkgPCA2MCB8fCBwcm9wcy5tYXhFdmVudEFnZS50b1NlY29uZHMoKSA+IDIxNjAwKSkge1xuICAgICAgICAgICAgdGhyb3cgbmV3IEVycm9yKCdgbWF4aW11bUV2ZW50QWdlYCBtdXN0IHJlcHJlc2VudCBhIGBEdXJhdGlvbmAgdGhhdCBpcyBiZXR3ZWVuIDYwIGFuZCAyMTYwMCBzZWNvbmRzLicpO1xuICAgICAgICB9XG4gICAgICAgIGlmIChwcm9wcy5yZXRyeUF0dGVtcHRzICYmIChwcm9wcy5yZXRyeUF0dGVtcHRzIDwgMCB8fCBwcm9wcy5yZXRyeUF0dGVtcHRzID4gMikpIHtcbiAgICAgICAgICAgIHRocm93IG5ldyBFcnJvcignYHJldHJ5QXR0ZW1wdHNgIG11c3QgYmUgYmV0d2VlbiAwIGFuZCAyLicpO1xuICAgICAgICB9XG4gICAgICAgIG5ldyBDZm5FdmVudEludm9rZUNvbmZpZyh0aGlzLCAnUmVzb3VyY2UnLCB7XG4gICAgICAgICAgICBkZXN0aW5hdGlvbkNvbmZpZzogcHJvcHMub25GYWlsdXJlIHx8IHByb3BzLm9uU3VjY2Vzc1xuICAgICAgICAgICAgICAgID8ge1xuICAgICAgICAgICAgICAgICAgICAuLi5wcm9wcy5vbkZhaWx1cmUgPyB7IG9uRmFpbHVyZTogcHJvcHMub25GYWlsdXJlLmJpbmQodGhpcywgcHJvcHMuZnVuY3Rpb24sIHsgdHlwZTogRGVzdGluYXRpb25UeXBlLkZBSUxVUkUgfSkgfSA6IHt9LFxuICAgICAgICAgICAgICAgICAgICAuLi5wcm9wcy5vblN1Y2Nlc3MgPyB7IG9uU3VjY2VzczogcHJvcHMub25TdWNjZXNzLmJpbmQodGhpcywgcHJvcHMuZnVuY3Rpb24sIHsgdHlwZTogRGVzdGluYXRpb25UeXBlLlNVQ0NFU1MgfSkgfSA6IHt9LFxuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICA6IHVuZGVmaW5lZCxcbiAgICAgICAgICAgIGZ1bmN0aW9uTmFtZTogcHJvcHMuZnVuY3Rpb24uZnVuY3Rpb25OYW1lLFxuICAgICAgICAgICAgbWF4aW11bUV2ZW50QWdlSW5TZWNvbmRzOiBwcm9wcy5tYXhFdmVudEFnZSAmJiBwcm9wcy5tYXhFdmVudEFnZS50b1NlY29uZHMoKSxcbiAgICAgICAgICAgIG1heGltdW1SZXRyeUF0dGVtcHRzOiBwcm9wcy5yZXRyeUF0dGVtcHRzICE9PSB1bmRlZmluZWQgPyBwcm9wcy5yZXRyeUF0dGVtcHRzIDogdW5kZWZpbmVkLFxuICAgICAgICAgICAgcXVhbGlmaWVyOiBwcm9wcy5xdWFsaWZpZXIgfHwgJyRMQVRFU1QnLFxuICAgICAgICB9KTtcbiAgICB9XG59XG4iXX0=